########## about #############
# data inks: CV-PU1 dilution series (in Gink manuscript named Gink5)
# data pre-inks: LH-ESRF-M5 with SDC 2 mg/m2 (samples 106-108)

########### prelims #################
library(ggplot2)
library(latex2exp) # To use latex in plots
library(reshape2) # for reshaping my data into the long format.
library(scales)
library(MetBrewer)


########### color palettes ###############
### colorblind-friendly from https://jfly.uni-koeln.de/color/
# The palette with grey:
cbPalette <- c("#999999", "#E69F00", "#56B4E9", "#009E73", #"#F0E442", 
               "#0072B2", "#D55E00", "#CC79A7")

# The palette with black:
cbbPalette <- c("#000000", "#E69F00", "#56B4E9", "#009E73", #"#F0E442", 
                "#0072B2", "#D55E00", "#CC79A7")

# another palette with 15 colors (source: https://jacksonlab.agronomy.wisc.edu/2016/05/23/15-level-colorblind-friendly-palette/)
pal <- c("#000000","#004949","#009292","#ff6db6","#ffb6db",
         "#490092","#006ddb","#b66dff","#6db6ff","#b6dbff",
         "#920000","#924900","#db6d00","#24ff24","#ffff6d")
cbPalblue <- c("#f0f9e8", "#bae4bc", "#7bccc4", "#43a2ca","#0868ac")
cbPalblueyellow <- c("#ffffcc", "#a1dab4", "#41b6c4", "#2c7fb8","#253494")
cbPalVivid_correctorder <- c("#AF1B3F", "#F4A698", "#262626", "#6BAA75", "#255C99", "#7EA3CC")
cbPalVivid <- c("#AF1B3F", "#F4A698", "#255C99", "#7EA3CC", "#262626", "#6BAA75")
cm2inch <- 1/2.54

# To use for fills, add
# scale_fill_manual(values=cbPalette)

# To use for line and point colors, add
# scale_colour_manual(values=cbPalette)

################# Read data ################################################################
rheo_data <- read.csv(file="C:/Users/s168562/OneDrive - TU Eindhoven/PhD/1_StretchableGink/Data_analysis/Rheology/Rheology_results_LH-PU_overview_2021-12-13.csv", 
                        header=F, sep=",",dec=".",skip=5)
outfolder <- "C:/Users/s168562/OneDrive - TU Eindhoven/PhD/1_StretchableGink/Data_analysis/Rheology/2021-12-13_SD_manuscript/"


################ plot LH-PU14,15,vtt1,vtt2, LH-PU20 manuscript names ######################################
rheo_df <- data.frame(shear_rate = rheo_data[,1],
                      Gink1 = rheo_data[,64],
                      Gink2 = rheo_data[,66],
                      Gink3 = rheo_data[,68],
                      Gink4 = rheo_data[,70],
                      Gink5 = rheo_data[,94]
)

rheo_sd_df <- data.frame(shear_rate = rheo_data[,1],
                         Gink1= rheo_data[,65],
                         Gink2 = rheo_data[,67],
                         Gink3 = rheo_data[,69],
                         Gink4 = rheo_data[,71],
                         Gink5 = rheo_data[,95]
)


## Reshape my data into a long-format with one column for the ink number and one for the viscosity value.
rheo_long <- melt(rheo_df, id.var = 1)
rheo_sd_long <- melt(rheo_sd_df, id.var = 1)
rheo_long$sd <- rheo_sd_long$value
rheo_long$min <- rheo_long$value - rheo_sd_long$value
rheo_long$max <- rheo_long$value + rheo_sd_long$value
colnames(rheo_long)[colnames(rheo_long) == "variable"] <- "Ink" # Rename column


## Plot (annotation_logticks) - pdf
figname <- "Gink1-5_vivid_logticks"
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 6.5*cm2inch, height = 4.5*cm2inch, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_long, aes(x = shear_rate, y = value, color = Ink, shape = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = shear_rate, ymin = min, ymax = max), width = 0.025) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  scale_colour_manual(values=cbPalVivid) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot (annotation_logticks) - tiff
figname <- "Gink1-5_vivid_logticks"
tiff(paste(outfolder, figname, ".tiff", sep=""),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_long, aes(x = shear_rate, y = value, color = Ink, shape = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = shear_rate, ymin = min, ymax = max), width = 0.025) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  scale_colour_manual(values=cbPalVivid) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

################ plot LH-PU14,15,vtt1,vtt2, LH-PU20 manuscript names AVERAGED ######################################
rheo_df <- data.frame(shear_rate = rheo_data[,1],
                      Gink1 = rheo_data[,64],
                      Gink2 = rheo_data[,66],
                      Gink3 = rheo_data[,68],
                      Gink4 = rheo_data[,70],
                      Gink5 = rheo_data[,94]
)

rheo_df$average <- rowMeans(rheo_df[ , c(2, 3, 4, 5, 6)])
rheo_df$sd <- apply(rheo_df[ , c(2, 3, 4, 5, 6)], 1, sd)
rheo_df$min2 <- rheo_df$average - 2*rheo_df$sd
rheo_df$max2 <- rheo_df$average + 2*rheo_df$sd

######### error bar *2 ##################
## Plot (annotation_logticks) - pdf - smaller - error bar *2
figname <- "Gink1-5_mean_vivid_logticks_smaller_sd2"
pdf(paste(outfolder, figname, ".pdf", sep=""), width = 5.5*cm2inch, height = 3.8*cm2inch, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_df, aes(x = shear_rate, y = average)) + # 
  geom_point(size = 0.75, 
             color = met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)[4]) + #, color = cbPalVivid[3]
  geom_errorbar(aes(x = shear_rate, ymin = min2, ymax = max2), width = 0.15, size = 0.3, 
                color = met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)[4]) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  # scale_colour_manual(values=cbPalVivid) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3"
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot (annotation_logticks) - tiff  smaller - error bar * 2
figname <- "Gink1-5_mean_vivid_logticks_smaller_sd2"
tiff(paste(outfolder, figname, ".tiff", sep=""), 
     width = 5.5, height = 3.8, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_df, aes(x = shear_rate, y = average)) + # 
  geom_point(size = 0.75, 
             color = met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)[4]) + #, color = cbPalVivid[3]
  geom_errorbar(aes(x = shear_rate, ymin = min2, ymax = max2), width = 0.15, size = 0.3, 
                color = met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)[4]) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  # scale_colour_manual(values=cbPalVivid) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3"
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

######### error bar *2 pink smaller ##################

## Plot (annotation_logticks) - pdf - smaller blue - error bar *2
figname <- "Gink1-5_mean_vivid_logticks_smaller_pink_sd2_2"
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 5.5*cm2inch, height = 3.8*cm2inch, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_df, aes(x = shear_rate, y = average)) +
  geom_point(size = 0.75, color = cbPalVivid[1]) +
  geom_errorbar(aes(x = shear_rate, ymin = min2, ymax = max2), width = 0.15, size = 0.3, color = cbPalVivid[1]) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_color_hue(l=55, c=100) + # default l = 65, c = 100
  # scale_color_brewer(palette = "Paired") +
  scale_colour_manual(values=cbPalVivid) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

################ plot CV-PU1 dilution series manuscript names Gink6 only subset ######################################
rheo_df <- data.frame(shear_rate = rheo_data[,1],
                      Gink_0mL = rheo_data[,76],
                      Gink_10mL = rheo_data[,80],
                      Gink_20mL = rheo_data[,84],
                      Gink_30mL = rheo_data[,88]
)

rheo_sd_df <- data.frame(shear_rate = rheo_data[,1],
                         Gink_0mL = rheo_data[,77],
                         Gink_10mL = rheo_data[,81],
                         Gink_20mL = rheo_data[,85],
                         Gink_30mL = rheo_data[,89]
)

## Reshape my data into a long-format with one column for the ink number and one for the viscosity value.
rheo_long <- melt(rheo_df, id.var = 1)
rheo_sd_long <- melt(rheo_sd_df, id.var = 1)
rheo_long$sd <- rheo_sd_long$value
rheo_long$min <- rheo_long$value - rheo_sd_long$value
rheo_long$max <- rheo_long$value + rheo_sd_long$value
colnames(rheo_long)[colnames(rheo_long) == "variable"] <- "Ink" # Rename column

## Plot (no annotation_logticks) - pdf
figname <- "Gink6_dilution_series_subset"
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 6.5*cm2inch, height = 4.5*cm2inch, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_long, aes(x = shear_rate, y = value, color = Ink, shape = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = shear_rate, ymin = min, ymax = max), width = 0.025, color = cbPalVivid[3]) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_colour_manual(values=rev(cbPalblue[2:5])) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3"
  # scale_alpha_discrete(range=rev(c(0.25, 1))) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot (no annotation_logticks) - tiff
figname <- "Gink6_dilution_series_subset"
tiff(paste(outfolder, figname, ".tiff", sep=""),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_long, aes(x = shear_rate, y = value, color = Ink, shape = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = shear_rate, ymin = min, ymax = max), width = 0.025, color = cbPalVivid[3]) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  # scale_colour_manual(values=rev(cbPalblue[2:5])) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3"
  # scale_alpha_discrete(range=rev(c(0.25, 1))) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot (annotation_logticks) - pdf
figname <- "Gink6_dilution_series_subset_logticks"
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 6.5*cm2inch, height = 4.5*cm2inch, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_long, aes(x = shear_rate, y = value, color = Ink, shape = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = shear_rate, ymin = min, ymax = max), width = 0.025, color = cbPalVivid[3]) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3"
  scale_alpha_discrete(range=rev(c(0.25, 1))) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot (annotation_logticks) - tiff
figname <- "Gink6_dilution_series_subset_logticks"
tiff(paste(outfolder, figname, ".tiff", sep=""),
     width = 6.5, height = 4.5, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_long, aes(x = shear_rate, y = value, color = Ink, shape = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = shear_rate, ymin = min, ymax = max), width = 0.025, color = cbPalVivid[3]) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3"
  # scale_alpha_discrete(range=rev(c(0.25, 1))) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot (annotation_logticks) - pdf - smaller
figname = "Gink6_dilution_series_subset_logticks_smaller"
pdf(paste(outfolder, figname, ".pdf", sep=""),
    width = 5.5*cm2inch, height = 3.8*cm2inch, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_long, aes(x = shear_rate, y = value, color = Ink, shape = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = shear_rate, ymin = min, ymax = max), width = 0.025, color = cbPalVivid[3]) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3"
  # scale_alpha_discrete(range=rev(c(0.25, 1))) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()

## Plot (annotation_logticks) - tiff - smaller
figname = "Gink6_dilution_series_subset_logticks_smaller"
tiff(paste(outfolder, figname, ".itff", sep=""),
     width = 5.5, height = 3.8, units = "cm", compression = "lzw", res = 800, pointsize = 8, bg = "transparent")
viscosity_plot <-  ggplot(data = rheo_long, aes(x = shear_rate, y = value, color = Ink, shape = Ink)) +
  geom_point(size = 0.75) +
  # geom_errorbar(aes(x = shear_rate, ymin = min, ymax = max), width = 0.025, color = cbPalVivid[3]) +
  scale_x_log10(labels = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), breaks = c(0.001, 0.01, 0.1, 1, 10, 100, 1000), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_x_log10(labels = scientific, breaks = c(0.01, 1, 100), limits = c(0.001, 1000), sec.axis = dup_axis(labels = NULL, name = "")) + #scientific / label_number(accuracy = .1)
  # scale_y_log10(labels = c(.1, 10, 1000, "100000"), breaks = c(.1, 10, 1000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  scale_y_log10(labels = c(.1, 1, 10, 100, 1000, 10000, "100000"), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000), sec.axis = dup_axis(labels = NULL, name = "")) +
  # scale_y_log10(labels = label_number(accuracy = 1), breaks = c(.1, 1, 10, 100, 1000, 10000, 100000), limits = c(.1, 100000)) +
  annotation_logticks(sides = "trbl", size = 0.125,
                      short = unit(.25,"mm"),
                      mid = unit(.5,"mm"),
                      long = unit(.7,"mm")) + #0.125
  xlab(TeX("Shear rate \\[s^{-1}\\]")) +
  ylab(TeX("Viscosity \\[Pa s\\]")) +
  scale_shape_manual(values = c(16, 15, 17, 18, 21, 22, 23, 24, 25)) +
  scale_colour_manual(values=met.brewer("OKeeffe1", n = 4, type = "continuous", direction = 1, override.order = FALSE)) + # "Cassatt1" (!), "Hiroshige",  "Hokusai3" (-1), "Isfahan1", "Johnson", "OKeeffe1" (!), "OKeeffe2", "Tam", "VanGogh3"
  # scale_alpha_discrete(range=rev(c(0.25, 1))) +
  theme_bw(base_size = 8) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),
        axis.ticks.length=unit(-.8, "mm"), axis.text.x = element_text(vjust = -0.25, colour="black"), #axis.ticks.length=unit(-.25, "cm") to have ticks on the inside
        axis.text.y = element_text(margin=unit(c(0.125,0.125,0.125,0.125), "cm"), colour="black"),
        legend.position = c(0.75, 0.75),
        legend.spacing = unit(0.1, "cm"),
        legend.key.size = unit(0.125, "cm"),
        legend.background = element_rect(fill = "transparent"),
        legend.title = element_blank()) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))) #, axis.text = element_text(margin=margin(50,50,2,2,"pt"))
viscosity_plot
dev.off()
