# -*- coding: utf-8 -*-
"""
Created on Thu Mar 24 15:33:08 2022

@author: s168562
"""

# Packages
import numpy as np
import matplotlib.pyplot as plt
import os
import pandas as pd

# Input
outpathfull = r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\2_HR_printing\Data_analysis\DLS\IKA_time_series\Figures"
sample = "LH-GNP13-90min" # sample name as will be added to output
filepath = r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\2_HR_printing\Data_analysis\DLS\IKA_time_series" # r to escape the backslashes
filename = "LH-GNP13-90_2022-05-04.csv"

# Plot preliminaries
plt.style.use('default') # default, ggplot, seaborn-*, dark_background, fivethirtyeight
plt.rcParams['font.size'] = 8 # set plot font size matplotlib
cm = 1/2.54  # convert centimeters to inches
cbPalVivid_correctorder = ["#999999", "#AF1B3F", "#F4A698", "#262626", "#6BAA75", "#255C99", "#7EA3CC"]
cbPalVivid = ["#999999", "#AF1B3F", "#F4A698", "#255C99", "#7EA3CC", "#262626", "#6BAA75"]
TUred = "#C81919"

if not os.path.exists(outpathfull):
    os.makedirs(outpathfull)

# Read data
fullpath = os.path.join(filepath,filename)
df = pd.read_csv(fullpath, skiprows = 4, sep=",", header = None)    
df.columns = ["Particle_diameter", "Freq_int_weighted1", "Freq_vol_weighted1",
                 "Freq_num_weighted1", "Freq_int_weighted2", "Freq_vol_weighted2",
                 "Freq_num_weighted2", "Freq_int_weighted3", "Freq_vol_weighted3",
                 "Freq_num_weighted3"]

# Plot
plt.figure(figsize= [5.5*cm, 3.8*cm])
plt.plot(df['Particle_diameter'], df["Freq_int_weighted1"], color = cbPalVivid[1]) # TUred
plt.plot(df['Particle_diameter'], df["Freq_int_weighted2"], color = cbPalVivid[2]) # TUred
plt.plot(df['Particle_diameter'], df["Freq_int_weighted3"], color = cbPalVivid[3]) # TUred
plt.xscale('log')
ax = plt.axes()
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
# ax.set_xticks([10, 100, 1000, 10000])
ax.set_xlim(10,10000)
# for axis in [ax.xaxis, ax.yaxis]:
#     axis.set_major_formatter(ScalarFormatter())
ax.set_facecolor("white")
plt.xlabel(r'Hydrodynamic diameter [nm]')
plt.ylabel(r'Probability [%]') # r'Probability'
figurepath_pdf = os.path.join(outpathfull, sample + "diameter_dist_int1-3.pdf")
figurepath_tiff = os.path.join(outpathfull, sample + "diameter_dist_int1-3.tiff")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()