# -*- coding: utf-8 -*-
"""
Created on Mon Jan 17 19:59:55 2022

@author: s168562

Plot some GF values vs IPL Energy
"""

# packages
import matplotlib.pyplot as plt
import pandas as pd
import os # for file paths
from cycler import cycler # for plot color maps


# Output folders
# sys.path.append(os.getcwd())
os.chdir(r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining\Analysis")
outpathfull = r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining\Analysis\Figures\Scatterplots"

## Data
filepath = r"C:\Users\s168562\OneDrive - TU Eindhoven\PhD\1_StretchableGink\Data_analysis\Holst_straining" # r to escape the backslashes
filename = "GF_data_for_scatter_plots.csv"
fullpath = os.path.join(filepath,filename)
df = pd.read_csv(fullpath, nrows = 8)

## Plot prerequisites
if not os.path.exists(outpathfull):
    os.makedirs(outpathfull)

plt.style.use('default') # default, ggplot, seaborn-*, dark_background, fivethirtyeight
plt.rcParams['font.size'] = 8 # set plot font size matplotlib
cm = 1/2.54  # convert centimeters to inches
from matplotlib.patches import Patch # for manual legend entries
from matplotlib.lines import Line2D # for manual legend entries
### Default sans-serif fonts:
# plt.rcParams['font.sans-serif'] = ['DejaVu Sans',
#  'Bitstream Vera Sans',
#  'Computer Modern Sans Serif',
#  'Lucida Grande',
#  'Verdana',
#  'Geneva',
#  'Lucid',
#  'Arial',
#  'Helvetica',
#  'Avant Garde',
#  'sans-serif']
plt.rcParams['font.sans-serif'] = ['sans-serif',
                                   'sans-serif',
                                   'DejaVu Sans',
 'Bitstream Vera Sans',
 'Computer Modern Sans Serif',
 'Lucida Grande',
 'Verdana',
 'Geneva',
 'Lucid',
 'Arial',
 'Helvetica',
 'Avant Garde']

#plt.style.available()

# Set font to Latex
# from matplotlib import rc
# rc('font', **{'family':'serif','serif':['Palatino']})
# rc('text', usetex=True)

# Color palettes
cbbPalette = ["#000000", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7"]
cbPalVivid_correctorder = ["#999999", "#AF1B3F", "#F4A698", "#262626", "#6BAA75", "#255C99", "#7EA3CC"]
cbPalVivid = ["#999999", "#AF1B3F", "#F4A698", "#255C99", "#7EA3CC", "#262626", "#6BAA75"]

## set color map (only works when first manually running the script palettes.py stored here:)
# C:\Users\s168562\OneDrive - TU Eindhoven\PhD\Code general\MetBrewer-main\MetBrewer-main\Python\met_brewer
colormap = met_brew(name="OKeeffe1", n=4, brew_type="continuous")


## Plots
# Distinguish between the two substrates
df_EU94 = df[df['Substrate'] == "EU94"]
df_ST604 = df[df['Substrate'] == "ST604"]


# GF vs E
plt.figure(figsize= [5.5*cm, 3.8*cm])
plt.scatter(df_EU94['E'], df_EU94['GF1000'], color = cbPalVivid[3], marker = "o",
            label = "EU94")
plt.scatter(df_ST604['E'], df_ST604['GF1000'], color = cbPalVivid[2], marker = "d",
            label = "ST604")
ax = plt.axes()
ax.set_ylim(5, 30)
ax.set_xlim(-0.1, 2.6)
ax.set_xticks([0, 0.5, 1, 1.5, 2, 2.5])
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
ax.set_facecolor("white")
plt.xlabel(r'Energy [J cm$^{-2}$]')
plt.ylabel(r'$GF_{1000}$')
plt.legend(fontsize = 'small', loc = 'lower right', frameon = False, framealpha = 1,
           edgecolor = 'white')
figurepath_pdf = os.path.join(outpathfull, "GF_E.pdf")
figurepath_tiff = os.path.join(outpathfull, "GF_E.tiff")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

# DGF vs E
plt.figure(figsize= [5.5*cm, 3.8*cm])
plt.scatter(df_EU94['E'], df_EU94['DGF1000'], color = cbPalVivid[3], marker = "o",
            label = "EU94")
plt.scatter(df_ST604['E'], df_ST604['DGF1000'], color = cbPalVivid[2], marker = "d",
            label = "ST604")
ax = plt.axes()
ax.set_xlim(-0.1, 2.6)
ax.set_xticks([0, 0.5, 1, 1.5, 2, 2.5])
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
ax.set_facecolor("white")
plt.xlabel(r'Energy [J cm$^{-2}$]')
plt.ylabel(r'$DGF_{1000}$')
plt.legend(fontsize = 'small', loc = 'best', frameon = False, framealpha = 1,
           edgecolor = 'white')
figurepath_pdf = os.path.join(outpathfull, "DGF_E.pdf")
figurepath_tiff = os.path.join(outpathfull, "DGF_E.tiff")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

# Rf/R0 vs E
plt.figure(figsize= [5.5*cm, 3.8*cm])
plt.scatter(df_EU94['E'], df_EU94['Rf/R0'], color = cbPalVivid[3], marker = "o",
            label = "EU94")
plt.scatter(df_ST604['E'], df_ST604['Rf/R0'], color = cbPalVivid[2], marker = "d",
            label = "ST604")
ax = plt.axes()
ax.set_ylim(1.5, 4.5)
ax.set_xlim(-0.1, 2.6)
ax.set_xticks([0, 0.5, 1, 1.5, 2, 2.5])
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
ax.set_facecolor("white")
plt.xlabel(r'Energy [J cm$^{-2}$]')
plt.ylabel(r'$R_f/R_0$')
plt.legend(fontsize = 'small', loc = 'best', frameon = False, framealpha = 1,
           edgecolor = 'white')
figurepath_pdf = os.path.join(outpathfull, "RfR0_E.pdf")
figurepath_tiff = os.path.join(outpathfull, "RfR0_E.tiff")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()

# Rs vs E
plt.figure(figsize= [5.5*cm, 3.8*cm])
plt.errorbar(df_EU94['E'], df_EU94['Rs'], yerr = df_EU94['Rs_SD'], 
             color = cbPalVivid[3], fmt = "o", capsize = 5,
             label = "EU94")
plt.errorbar(df_ST604['E'], df_ST604['Rs'], yerr = df_ST604['Rs_SD'], 
             color = cbPalVivid[2], fmt = "d", capsize = 5,
             label = "ST604")
ax = plt.axes()
ax.set_ylim(0, 80)
ax.set_xlim(-0.1, 2.6)
ax.set_xticks([0, 0.5, 1, 1.5, 2, 2.5])
ax.tick_params(axis="both",direction="in", left="off",labelleft="on", right = "on",
               top = "on")
ax.set_facecolor("white")
plt.xlabel(r'Energy [J cm$^{-2}$]')
plt.ylabel(r'$R_s$ [' + chr(937) + ' ' + chr(9643) + r'$^{-1}$' + r'mil$^{-1}$]')
plt.legend(fontsize = 'small', loc = 'best', frameon = False, framealpha = 1,
           edgecolor = 'white')
figurepath_pdf = os.path.join(outpathfull, "Rs_E.pdf")
figurepath_tiff = os.path.join(outpathfull, "Rs_E.tiff")
plt.savefig(figurepath_tiff, dpi = 300, bbox_inches='tight', transparent = True)
plt.savefig(figurepath_pdf, dpi = 300, bbox_inches='tight', transparent = True)
plt.show()
