#!/bin/sh

#SBATCH --job-name=NAME
#SBATCH --time=24:00:00
#SBATCH --ntasks=144
#SBATCH --cpus-per-task=1
#SBATCH --mem-per-cpu=4GB
# --nodes=6

module load 2022r2
module load openmpi/4.1.1
module load openfoam/2106-intel-mkl

module list

rm -rf ./0

cp -r ./0.orig ./0

rm -rf ./constant/polyMesh

blockMesh  > blockMesh.log 2>&1

topoSet    > topoSet.log 2>&1

decomposePar -force > decompose.log 2>&1

mpirun -n 144 simpleFoam -parallel > solver.log 2>&1

reconstructPar -latestTime  > reconstructPar.log 2>&1

# rm -rf processor*
