//+
SetFactory("OpenCASCADE");
//+
x_dist=22.78;
y_dist=1.94;
z_dist=4.17;

Box(1) = {0, 0, 0, x_dist, y_dist, z_dist};
//+
Sphere(2) = {0, 1.4, 1.5, 0.7, -Pi/2, Pi/2, 2*Pi};
Sphere(3) = {0, 1.7, 4.17, 0.55, -Pi/2, Pi/2, 2*Pi};
Sphere(4) = {2.6, 1.94, 2.4, 1, -Pi/2, Pi/2, 2*Pi};
Sphere(5) = {5.5, 1.4, 4.5, 1.1, -Pi/2, Pi/2, 2*Pi};
Sphere(6) = {6.75, 1.7, 2.2, 0.5, -Pi/2, Pi/2, 2*Pi};
Sphere(7) = {7.75, 1.94, 1.8, 0.4, -Pi/2, Pi/2, 2*Pi};
Sphere(8) = {7.65, 1.94, 2.8, 0.4, -Pi/2, Pi/2, 2*Pi};
Sphere(9) = {9.75, 1.94, 2.45, 1.5, -Pi/2, Pi/2, 2*Pi};
Sphere(10) = {13, 1.6, 4.17, 0.9, -Pi/2, Pi/2, 2*Pi};
Sphere(11) = {15, 1.94, 1.7, 1.4, -Pi/2, Pi/2, 2*Pi};
Sphere(12) = {190, -0.4, 4.17, 1.6, -Pi/2, Pi/2, 2*Pi};
Sphere(13) = {18, 1.94, 4.1, 1.2, -Pi/2, Pi/2, 2*Pi};
Sphere(14) = {18.5, 1.94, 2, 0.5, -Pi/2, Pi/2, 2*Pi};
Sphere(15) = {22, 1.94, 2, 1.3, -Pi/2, Pi/2, 2*Pi};
Sphere(16) = {21.5, -0.5, 4.17, 1.6, -Pi/2, Pi/2, 2*Pi};
Sphere(17) = {5, 1.3, 0.6, 0.5, -Pi/2, Pi/2, 2*Pi};
//+
BooleanDifference{ Volume{1}; Delete; }{ Volume{2}; Volume{3}; Volume{4}; Volume{5}; Volume{6}; Volume{7}; Volume{8}; Volume{9}; Volume{10}; Volume{11}; Volume{12}; Volume{13}; Volume{14}; Volume{15}; Volume{16};  Volume{17}; Delete;}

eps=1e-3;
Physical Volume("block")={1};
Physical Surface("left") = {Surface In BoundingBox {-eps, -eps, -eps, eps, y_dist+eps, z_dist+eps}};
Physical Surface("bottom") = {Surface In BoundingBox {-eps, -eps, -eps, x_dist+eps, eps, z_dist+eps}};
Physical Surface("back") = {Surface In BoundingBox {-eps, -eps, -eps, x_dist+eps, y_dist+eps, eps}};
Physical Surface("right") = {Surface In BoundingBox {x_dist-eps, -eps, -eps, x_dist+eps, y_dist +eps, z_dist+eps}};
Physical Surface("top") = {Surface In BoundingBox {-eps, y_dist-eps, -eps, x_dist+eps, y_dist +eps, z_dist+eps}};
Physical Surface("front") = {Surface In BoundingBox {-eps, -eps, z_dist-eps, x_dist+eps, y_dist +eps, z_dist+eps}};
Physical Surface("grains") = {Surface In BoundingBox {0, 0, 0, x_dist, y_dist, z_dist}};
