# OperationAIR - Assist In Respiration


<img src="./docs/img/OperationAIR_Name.png" alt="OperationAIR_Name" style="zoom:20%;" />

## OperationAIR: Who are we?

OperationAIR is a student team of Delft University of Technology that developed a simplified ventilator: the AIRone. It was developed as a non-certified, advanced emergency ventilator at times of a national shortage due to the covid-19 pandemic, in close contact with experts from Leiden University Medical Center and Erasmus Medical Center.

<img src="./docs/img/AIRone-Final-1.png" alt="AIRone-Final-1" style="zoom: 67%;" />

## AIRone: What is it?

The AIRone operates and functions as a regular, pressure-regulated  ventilator, but with essential functionalities only. In short, it uses a pressurised gas source, reduces the pressure accordingly and delivers  gas to the patient by a set of proportional valves (see below for more  details). Oxygen concentration is regulated using two Mass Flow  Controllers on the gas inlets.

<img src="./docs/img/Specifications_AIRone.png" style="zoom:75%;" />

The  AIRone provides positive-pressure ventilation (PPV) for emergency  automatic ventilation, created for the use on adult (suspected) COVID-19 patients who need non-weaned respiratory support to bridge a longer  period of time until conventional ventilation becomes available.

## Adjustable settings

- Inspiratory pressure (Pinsp)
- Positive end-expiratory pressure (PEEP)
- Respiratory rate (RR)
- I:E ratio
- Oxygen concentration(%) (FiO2)

## Project Motivation

The design of the AIRone is final. As national ICU admissions are  dropping large scale production is not necessary. The AIRone is  currently being produced in a small batch to complete the design cycle  and to share this expertise with the international community. Software  engineers will continue to work on an additional module to enable  patient respiration triggers for weaning.

The AIRone was recommended by clinicians to be used at times of  national shortage of certified ventilators. Official approval has not  been obtained, due to the disappeared urgency of emergency ventilators.  Therefore, the safety or efficacy of the AIRone for use in humans has  not been proven. However, thorough design verification was performed  using an advanced artificial test lung. Additionally, design  documentation is under review by a notified body. Also, multiple  usability tests by doctors and nurses lead to the current user-friendly  design.

<img src="./docs/img/Interior_AIRone.png" style="zoom:75%;" />

## General Working Principle

The AIRone uses pressurized medical air and oxygen that is available  in most Dutch hospitals, reduces it to the required pressure, and  delivers this to the patient using a set of proportional valves that are controlled using a central microcontroller.

The physician can start up the device and use the touchscreen (GUI)  to set ventilation parameters to the desired settings. The GUI will  communicate these setting to the MicroController Unit (MCU). The MCU  then controls all valves to ventilate the patient accordingly.

The AIRone has two male NIST (Non-interchangeable screw thread)  connectors, one for compressed medical air and one for oxygen. The  female counterparts of these connectors should be available in the Dutch hospital and can be connected to the AIRone. The input pressure of both oxygen and compressed air may vary between 4 and 8 bar. In the device,  the oxygen and air pressure is reduced to 4 bar. Two Mass Flow  Controllers (MFCs) are used to control the flow of both gasses into a  mixing chamber. This ensures a highly controlled mixing ratio, having a  gas with the desired oxygen concentration as result. A pressure sensor  in the mixing chamber gives feedback to the MFCs, adjusting their flow  to keep the pressure in the chamber at 650 mbar. As a back-up, a back  pressure regulator ensures the pressure in the chamber will never exceed 1 bar by blowing off air when the pressure is too high.

Downstream of the mixing chamber, a proportional valve regulates the  pressure going into the patient. Generally, the valve will open at the  start of inspiration and close when the pressure at the lungs is at the  desired plateau pressure.  Before the gas mixture flows to the patient  it passes a check valve which blocks flow coming back from the patient.

During expiration, the gas is filtered by a HEPA filter. The gas then passes another check valve, and also a pressure relief valve, which  opens when the pressure in the system rises above 70 cmH20. The gas is  then released to outside the system by another proportional valve that  opens at the beginning of the expiration and closes at the end of the  expiration.

------

**Be aware this design explicitly focuses on use in the Dutch  healthcare infrastructure. Alterations of this design will be needed for local implementation. Please leave your contact information and  additional information in this form so we can discuss matters or offer  advice and support:** https://forms.gle/rWXyzbqTNrqdJqee8

## DISCLAIMER

Licensor means Technische Universiteit Delft and OperationAIR. Licensee means any business, organisation or person using the Licensed Material. Licensed Material means all information pertaining to the last resort ventilator also known as the AIRone

### Intended use

1. The AIRone is a last resort device. It is not designed to replace the currently available, conventional ventilators. The AIRone is a pressure-controlled emergency mechanical ventilation system created for the treatment of COVID-19 patients, who need respiratory support, for who no conventional ventilation machine is available. 
2. The for profit exploitation of the Licensed Material is explicitly prohibited.

### Disclaimer of Warranties and Limitation of Liability.

The Licensor offers the Licensed Material “as-is” and “as-available”, and makes no representations or warranties of any kind concerning the Licensed Material, whether express, implied, statutory, or other. This includes, without limitation, warranties of title, merchantability, fitness for a particular purpose, non-infringement, absence of latent or other defects, accuracy, or the presence or absence of errors, whether or not known or discoverable.

To the extent possible, in no event will the Licensor be liable to Licensee on any legal grounds (including, but not limited to, gross negligence and wilful misconduct) or otherwise for any direct, special, indirect, incidental, consequential, punitive, exemplary, or other losses, costs, expenses, or damages arising out of this Public License or use of the Licensed Material, even if the Licensor has been advised of the possibility of such losses, costs, expenses, or damages.

The disclaimer of warranties and limitation of liability provided above shall be interpreted in a manner that, to the extent possible, most closely approximates an absolute disclaimer and waiver of all liability.

## Project Organization

├── **docs**
│   ├── **EN**
│   │   ├── **PDF**
│   │   │   ├── Assembly-Manual
│   │   │   │   ├── 10. Work Instruction Subassembly 10 -Connect components _ Components to plate_ EN.pdf
│   │   │   │   ├── 11. Work Instruction Subassembly 11 - Wiring_EN.pdf
│   │   │   │   ├── 12. Work Instruction Subassembly 12 - Bottom plate + trolley_EN.pdf
│   │   │   │   ├── 13. Work Instruction Subassembly 13 - hood_to_base_EN.pdf
│   │   │   │   ├── 14. Work Instruction Subassembly extra - speaker_EN.pdf
│   │   │   │   ├── 1. Work Instructrion Subassembly 1 - MFC-AIR_EN.pdf
│   │   │   │   ├── 2. Work Instruction Subassembly 2 - MFC-OXYGEN_EN.pdf
│   │   │   │   ├── 3D Printing Overview.pdf
│   │   │   │   ├── 3. Work Instruction Subassembly 3 - Mixing chamber_EN.pdf
│   │   │   │   ├── 4A. Work Instruction Subassembly 4A - Swagelok_EN.pdf
│   │   │   │   ├── 4B. Work Instruction Subassembly 4B - 3D blocks_EN.pdf
│   │   │   │   ├── 4C. Work Instruction Subassembly 4C - Insp_Tract_EN.pdf
│   │   │   │   ├── 5. Work Instruction Subassembly 5- Expiratory Tract_EN.pdf
│   │   │   │   ├── 6B. Work Instruction Subassembly 6B- SD_software_EN.pdf
│   │   │   │   ├── 6C. Work Instruction Subassembly 6C- SD_connection_EN.pdf
│   │   │   │   ├── 6. Work Instruction Subassembly 6 - PCB + wiring_EN.pdf
│   │   │   │   ├── 7. Work Instruction Subbassembly 7 - Hood_EN.pdf
│   │   │   │   ├── 8. Work Instruction Subassembly 8 - Bottom plate_EN.pdf
│   │   │   │   └── 9. Work Instruction Subassembly 9 - Trolley_EN.pdf
│   │   │   ├── Bill-of-Materials.pdf
│   │   │   ├── Design-Specifications.pdf
│   │   │   ├── Design-Verification.pdf
│   │   │   ├── Instruction-Manual.pdf
│   │   │   ├── Lessons-Learnt.pdf
│   │   │   ├── OperationAIR-Services.pdf
│   │   │   ├── README (Disclaimer + File Structure).pdf
│   │   │   ├── Team-Organization.pdf
│   │   │   └── Technical-Manual.pdf
│   │   └── **Src**
│   │       ├── Bill-of-Material.md
│   │       ├── Disclaimer.md
│   │       ├── Lessons-Learnt.md
│   │       └── OperationAIR-Services.md
│   └── **img**
│       ├── AIRone-Final-1.png
│       ├── Architecture.jpg
│       ├── Interior_AIRone.png
│       ├── OperationAIR_Name.png
│       ├── **Renders**
│       │   ├── Airchain_EX.JPG
│       │   ├── Airchain.JPG
│       │   ├── Cap_Back.JPG
│       │   ├── Cap_Front.JPG
│       │   ├── Expiration_EX.JPG
│       │   ├── Expiration.JPG
│       │   ├── Exterior_Front_Back.JPG
│       │   ├── Exterior.JPG
│       │   ├── Exterior_Transparent.JPG
│       │   ├── Inspiration_3Dprint_EX.JPG
│       │   ├── Inspiration_3Dprint.JPG
│       │   ├── Inspiration_EX.JPG
│       │   ├── Inspiration_incl_3Dprint.JPG
│       │   ├── Inspiration.JPG
│       │   ├── Interior_Exterior.JPG
│       │   ├── Interior.JPG
│       │   ├── Interior_Top.JPG
│       │   ├── Interior_Trolley.JPG
│       │   ├── NIST_Bottom_EX.JPG
│       │   ├── NIST_Bottom.JPG
│       │   ├── NIST_Bottom_Rear.JPG
│       │   ├── O2chain_EX.JPG
│       │   ├── O2chain.JPG
│       │   ├── PCB_EX.JPG
│       │   ├── PCB.JPG
│       │   ├── Pin_EX.JPG
│       │   ├── Pin.JPG
│       │   ├── Plate_Air.JPG
│       │   ├── Plate_Connections.JPG
│       │   ├── Plate_Expiration.JPG
│       │   ├── Plate_Fan.JPG
│       │   ├── Plate_Inspiration.JPG
│       │   ├── Plate.JPG
│       │   ├── Plate_O2.JPG
│       │   ├── Plate_Patient_Connection_EX.JPG
│       │   ├── Plate_Patient_Connection.JPG
│       │   ├── Plate_Tank02.JPG
│       │   ├── Plate_Tank.JPG
│       │   ├── Plate_Top.JPG
│       │   ├── Speaker_EX.JPG
│       │   ├── Speaker.JPG
│       │   ├── Tank_EX.JPG
│       │   ├── Tank.JPG
│       │   ├── Trolley_EX.JPG
│       │   └── Trolley.JPG
│       └── Specifications_AIRone.png
├── metadata.yaml
├── README.md
└── **src**
    ├── Hardware
    │   ├── **3D-Print**
    │   │   ├── FDM_Electronics_Housing_1.STL
    │   │   ├── FDM_Electronics_Housing_2.STL
    │   │   ├── FDM_EX_Pressure_Relief_Plate.STL
    │   │   └── FDM_Flow_Sensor_Cap.STL
    │   ├── **Electronics**
    │   │   ├── **blinky**
    │   │   │   ├── CHANGELOG
    │   │   │   ├── cmake
    │   │   │   │   ├── CPM_setup.cmake
    │   │   │   │   ├── toolchain-gcc-arm-embedded.cmake
    │   │   │   │   └── version.cmake
    │   │   │   ├── CMakeLists.txt
    │   │   │   ├── config.cmake.example
    │   │   │   ├── config.cmake.release
    │   │   │   ├── **img**
    │   │   │   │   └── uart_pinout.png
    │   │   │   ├── link.ld
    │   │   │   ├── LPC11Uxx_v7.svd
    │   │   │   ├── README.md
    │   │   │   ├── release.sh
    │   │   │   ├── **src**
    │   │   │   │   ├── **actuators**
    │   │   │   │   │   ├── control_signals.c
    │   │   │   │   │   ├── control_signals.h
    │   │   │   │   │   ├── i2c_dac.c
    │   │   │   │   │   ├── i2c_dac.h
    │   │   │   │   │   ├── PWM.c
    │   │   │   │   │   └── PWM.h
    │   │   │   │   ├── app.c
    │   │   │   │   ├── app_cli.c
    │   │   │   │   ├── app_cli.h
    │   │   │   │   ├── app.h
    │   │   │   │   ├── board_config
    │   │   │   │   │   ├── board_ADC_ID.h
    │   │   │   │   │   ├── board_config_v0.c
    │   │   │   │   │   ├── board_config_v0.h
    │   │   │   │   │   ├── board_config_v1.c
    │   │   │   │   │   ├── board_config_v1.h
    │   │   │   │   │   └── board_GPIO_ID.h
    │   │   │   │   ├── board_specific_config.c
    │   │   │   │   ├── board_specific_config.h
    │   │   │   │   ├── breathing.c
    │   │   │   │   ├── breathing.h
    │   │   │   │   ├── cli.c
    │   │   │   │   ├── cli.h
    │   │   │   │   ├── clock.c
    │   │   │   │   ├── clock.h
    │   │   │   │   ├── **crc**
    │   │   │   │   │   ├── app_cfg.h
    │   │   │   │   │   ├── crc16.c
    │   │   │   │   │   ├── crc32.c
    │   │   │   │   │   ├── crc7.c
    │   │   │   │   │   ├── crc8.c
    │   │   │   │   │   ├── crc.h
    │   │   │   │   │   └── README.md
    │   │   │   │   ├── eeprom.c
    │   │   │   │   ├── eeprom.h
    │   │   │   │   ├── global_settings.h
    │   │   │   │   ├── i2c.c
    │   │   │   │   ├── i2c.h
    │   │   │   │   ├── log.c
    │   │   │   │   ├── log.h
    │   │   │   │   ├── main.c
    │   │   │   │   ├── parse_utils.c
    │   │   │   │   ├── parse_utils.h
    │   │   │   │   ├── pi_communication.c
    │   │   │   │   ├── pi_communication.h
    │   │   │   │   ├── self_test.c
    │   │   │   │   ├── self_test.h
    │   │   │   │   ├── **sensors**
    │   │   │   │   │   ├── ADC.c
    │   │   │   │   │   ├── ADC.h
    │   │   │   │   │   ├── calculated.c
    │   │   │   │   │   ├── calculated.h
    │   │   │   │   │   ├── flow.c
    │   │   │   │   │   ├── flow.h
    │   │   │   │   │   ├── MPRLS_pressure.c
    │   │   │   │   │   ├── MPRLS_pressure.h
    │   │   │   │   │   ├── sensors.c
    │   │   │   │   │   ├── sensors.h
    │   │   │   │   │   ├── UPS_status.c
    │   │   │   │   │   └── UPS_status.h
    │   │   │   │   ├── settings.c
    │   │   │   │   ├── settings.h
    │   │   │   │   ├── stats.c
    │   │   │   │   ├── stats.h
    │   │   │   │   ├── strtof_noheap.c
    │   │   │   │   ├── strtof_noheap.h
    │   │   │   │   ├── syscalls.c
    │   │   │   │   ├── **usb**
    │   │   │   │   │   ├── app_usb.c
    │   │   │   │   │   ├── app_usbd_cfg.h
    │   │   │   │   │   ├── app_usb.h
    │   │   │   │   │   ├── cdc_desc.c
    │   │   │   │   │   ├── cdc_vcom.c
    │   │   │   │   │   ├── cdc_vcom.h
    │   │   │   │   │   ├── usb_utils.c
    │   │   │   │   │   └── usb_utils.h
    │   │   │   │   ├── version.c
    │   │   │   │   ├── version.h
    │   │   │   │   ├── watchdog.c
    │   │   │   │   └── watchdog.h
    │   │   │   ├── **tests**
    │   │   │   │   ├── CMakeLists.txt
    │   │   │   │   ├── config.cmake.example
    │   │   │   │   ├── crc.test.c
    │   │   │   │   ├── dependencies.cmake
    │   │   │   │   └── flow.test.c
    │   │   │   └── user_settings.c
    │   │   ├── **firmware**
    │   │   │   ├── CHANGELOG
    │   │   │   ├── **cmake**
    │   │   │   │   ├── CPM_setup.cmake
    │   │   │   │   ├── toolchain-gcc-arm-embedded.cmake
    │   │   │   │   └── version.cmake
    │   │   │   ├── CMakeLists.txt
    │   │   │   ├── config.cmake.example
    │   │   │   ├── config.cmake.release
    │   │   │   ├── **img**
    │   │   │   │   └── uart_pinout.png
    │   │   │   ├── link.ld
    │   │   │   ├── LPC11Uxx_v7.svd
    │   │   │   ├── README.md
    │   │   │   ├── release.sh
    │   │   │   ├── **src**
    │   │   │   │   ├── actuators
    │   │   │   │   │   ├── control_signals.c
    │   │   │   │   │   ├── control_signals.h
    │   │   │   │   │   ├── i2c_dac.c
    │   │   │   │   │   ├── i2c_dac.h
    │   │   │   │   │   ├── PWM.c
    │   │   │   │   │   └── PWM.h
    │   │   │   │   ├── app.c
    │   │   │   │   ├── app_cli.c
    │   │   │   │   ├── app_cli.h
    │   │   │   │   ├── app.h
    │   │   │   │   ├── **board_config**
    │   │   │   │   │   ├── board_ADC_ID.h
    │   │   │   │   │   ├── board_config_v0.c
    │   │   │   │   │   ├── board_config_v0.h
    │   │   │   │   │   ├── board_config_v1.c
    │   │   │   │   │   ├── board_config_v1.h
    │   │   │   │   │   └── board_GPIO_ID.h
    │   │   │   │   ├── board_specific_config.c
    │   │   │   │   ├── board_specific_config.h
    │   │   │   │   ├── breathing.c
    │   │   │   │   ├── breathing.h
    │   │   │   │   ├── cli.c
    │   │   │   │   ├── cli.h
    │   │   │   │   ├── clock.c
    │   │   │   │   ├── clock.h
    │   │   │   │   ├── crc
    │   │   │   │   │   ├── app_cfg.h
    │   │   │   │   │   ├── crc16.c
    │   │   │   │   │   ├── crc32.c
    │   │   │   │   │   ├── crc7.c
    │   │   │   │   │   ├── crc8.c
    │   │   │   │   │   ├── crc.h
    │   │   │   │   │   └── README.md
    │   │   │   │   ├── global_settings.h
    │   │   │   │   ├── i2c.c
    │   │   │   │   ├── i2c.h
    │   │   │   │   ├── log.c
    │   │   │   │   ├── log.h
    │   │   │   │   ├── main.c
    │   │   │   │   ├── parse_utils.c
    │   │   │   │   ├── parse_utils.h
    │   │   │   │   ├── pi_communication.c
    │   │   │   │   ├── pi_communication.h
    │   │   │   │   ├── self_test.c
    │   │   │   │   ├── self_test.h
    │   │   │   │   ├── **sensors**
    │   │   │   │   │   ├── ADC.c
    │   │   │   │   │   ├── ADC.h
    │   │   │   │   │   ├── calculated.c
    │   │   │   │   │   ├── calculated.h
    │   │   │   │   │   ├── flow.c
    │   │   │   │   │   ├── flow.h
    │   │   │   │   │   ├── MPRLS_pressure.c
    │   │   │   │   │   ├── MPRLS_pressure.h
    │   │   │   │   │   ├── sensors.c
    │   │   │   │   │   ├── sensors.h
    │   │   │   │   │   ├── UPS_status.c
    │   │   │   │   │   └── UPS_status.h
    │   │   │   │   ├── settings.c
    │   │   │   │   ├── settings.h
    │   │   │   │   ├── **storage**
    │   │   │   │   │   ├── eeprom.c
    │   │   │   │   │   ├── eeprom.h
    │   │   │   │   │   ├── storage.c
    │   │   │   │   │   └── storage.h
    │   │   │   │   ├── strtof_noheap.c
    │   │   │   │   ├── strtof_noheap.h
    │   │   │   │   ├── syscalls.c
    │   │   │   │   ├── system_status.c
    │   │   │   │   ├── system_status.h
    │   │   │   │   ├── **usb**
    │   │   │   │   │   ├── app_usb.c
    │   │   │   │   │   ├── app_usbd_cfg.h
    │   │   │   │   │   ├── app_usb.h
    │   │   │   │   │   ├── cdc_desc.c
    │   │   │   │   │   ├── cdc_vcom.c
    │   │   │   │   │   ├── cdc_vcom.h
    │   │   │   │   │   ├── usb_utils.c
    │   │   │   │   │   └── usb_utils.h
    │   │   │   │   ├── version.c
    │   │   │   │   ├── version.h
    │   │   │   │   ├── watchdog.c
    │   │   │   │   └── watchdog.h
    │   │   │   ├── **tests**
    │   │   │   │   ├── CMakeLists.txt
    │   │   │   │   ├── config.cmake.example
    │   │   │   │   ├── dependencies.cmake
    │   │   │   │   └── flow.test.c
    │   │   │   └── user_settings.c
    │   │   ├── **img**
    │   │   │   └── pcb_v2.jpg
    │   │   ├── LICENSE
    │   │   ├── **pcb**
    │   │   │   ├── 7001-mainboard
    │   │   │   │   ├── 7001-ventilator_mainboard-cache.lib
    │   │   │   │   ├── 7001-ventilator_mainboard.kicad_pcb
    │   │   │   │   ├── 7001-ventilator_mainboard.pro
    │   │   │   │   ├── 7001-ventilator_mainboard.sch
    │   │   │   │   ├── 7001-ventilator_mainboard.xlsx
    │   │   │   │   ├── bom
    │   │   │   │   │   └── ibom.html
    │   │   │   │   ├── fp-info-cache
    │   │   │   │   ├── fp-lib-table
    │   │   │   │   ├── gerber_2layeroperationAir-pcb-proto.zip
    │   │   │   │   ├── gerber7001-pcb-2
    │   │   │   │   │   ├── 7001-ventilator_mainboard-B_Cu.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-B_Fab.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-B_Mask.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-B_Paste.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-B_SilkS.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-Edge_Cuts.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-F_Cu.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-F_Fab.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-F_Mask.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-F_Paste.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-F_SilkS.gbr
    │   │   │   │   │   ├── 7001-ventilator_mainboard-NPTH.drl
    │   │   │   │   │   └── 7001-ventilator_mainboard-PTH.drl
    │   │   │   │   └── pressure_sensor.sch
    │   │   │   ├── jitter_kicad_ws.kicad_wks
    │   │   │   └── OperationAir.pretty
    │   │   │       └── OperationAir260.kicad_mod
    │   │   └── README.md
    │   └── **Hardware-Overview**
    │       ├── Connector-G1-2_22mm.PDF
    │       ├── Connector-G3_8-22mm.PDF
    │       ├── Overview_Exterior.png
    │       ├── Overview_Interior_3D_Printing.png
    │       ├── Overview_Interior.png
    │       ├── Selection_Cover_Closed.png
    │       ├── Selection_Cover_EX.png
    │       ├── Selection_Inspiratory_EX.png
    │       └── Selection_Speaker_Double.png
    └── **Software**
        ├── **bin**
        │   ├── firmware.bin
        │   └── mxli
        ├── **config**
        │   ├── config.yml.dev
        │   ├── config.yml.example
        │   └── config.yml.production
        ├── LICENSE
        ├── **locale**
        │   └── **nl**
        │       └── **LC_MESSAGES**
        │           ├── operationAIR.mo
        │           └── operationAIR.po
        ├── Pipfile
        ├── Pipfile.lock
        ├── README.md
        ├── resources
        │   ├── **img**
        │   │   └── logo.png
        │   └── **sounds**
        │       └── medium_alarm.wav
        ├── **scripts**
        │   ├── airone.service
        │   ├── dev_mode.sh
        │   ├── firmware_update.sh
        │   ├── install.sh
        │   ├── mcu.py
        │   ├── production_mode.sh
        │   └── start.sh
        ├── **sensorlogs**
        │   ├── sensors_0.csv
        │   └── sensors_1.csv
        ├── **src**
        │   ├── **controllers**
        │   │   ├── alarmController.py
        │   │   ├── communicationController.py
        │   │   ├── init.py
        │   │   └── viewController.py
        │   ├── init.py
        │   ├── main.py
        │   ├── **models**
        │   │   ├── init.py
        │   │   ├── mcuSensorModel.py
        │   │   └── mcuSettingsModel.py
        │   ├── operationAIR.pot
        │   ├── **utils**
        │   │   ├── airTime.py
        │   │   ├── anamolyDetection.py
        │   │   ├── config.py
        │   │   ├── constants.py
        │   │   ├── currentValueCanvas.py
        │   │   ├── flatButton.py
        │   │   ├── init.py
        │   │   ├── internationalization.py
        │   │   ├── logger.py
        │   │   ├── logPlayer.py
        │   │   └── math.py
        │   └── **views**
        │       ├── activeAlarmView.py
        │       ├── alarmOverview.py
        │       ├── alarmSettingsOverview.py
        │       ├── changeDoubleSettingView.py
        │       ├── changeSingleSettingView.py
        │       ├── graphView.py
        │       ├── init.py
        │       ├── mainView.py
        │       ├── menuView.py
        │       └── setTimeView.py
        └── update_pi_img.sh

This repository consists of 55 directories and a total of 368 files.

## Getting Started


- Instructions for Use
- Service Structure
- Team Structure
- Tips and Pitfalls

These files are intended to give other researchers a head start on  their design process. The files give an insight in our process and  prevent you from making the mistakes we made. Explore these files before you take a look at the Hardware and Software files.

### Hardware

You can find the following files and components which relate to the **Hardware**:

- AIRone Assembly
  
  - 3D model of the assembly.
- Architecture
  
  - Technical drawing of the AIRone.
- Bill Of Materials
  
  - List of parts and suppliers.
- Design Specifications
  
  - Overview of the potential risks and the measures taken to prevent them from  happening.
- Design Verification
  
  - Overview of device tests and user tests.
- Technical Manual
  
  - Product specifications of all used components.
- <u>Assembly Manuals</u>
- <u>Hardware Overviews</u>
- <u>3D Printing</u>
- <u>Renders</u>

### Software

Software is divided into two segments.

- Electronics
  -  containing the electronic designs for the PCB and the accompanying firmware of the AIRone.
- Human interface
  - containing the code for the Interface of the AIRone