
import numpy as np
import matplotlib.pyplot as plt
import os



basedir = os.path.dirname(os.path.realpath(__file__)) 

TenCate1 = np.genfromtxt(basedir + "/rawdata/" + "case1/Overal_Drag_Ten_Cate.txt")
TenCate2 = np.genfromtxt(basedir + "/rawdata/" + "case2/Overal_Drag_Ten_Cate.txt")
TenCate3 = np.genfromtxt(basedir + "/rawdata/" + "case3/Overal_Drag_Ten_Cate.txt")
TenCate4 = np.genfromtxt(basedir + "/rawdata/" + "case4/Overal_Drag_Ten_Cate.txt")


TenCate1expV = np.genfromtxt(basedir + "/TenCate/Case1Vel.csv",delimiter=',')
TenCate2expV = np.genfromtxt(basedir + "/TenCate/Case2Vel.csv",delimiter=',')
TenCate3expV = np.genfromtxt(basedir + "/TenCate/Case3Vel.csv",delimiter=',')
TenCate4expV = np.genfromtxt(basedir + "/TenCate/Case4Vel.csv",delimiter=',')


TenCate1expP = np.genfromtxt(basedir + "/TenCate/Case1Pos.csv",delimiter=',')
TenCate2expP = np.genfromtxt(basedir + "/TenCate/Case2Pos.csv",delimiter=',')
TenCate3expP = np.genfromtxt(basedir + "/TenCate/Case3Pos.csv",delimiter=',')
TenCate4expP = np.genfromtxt(basedir + "/TenCate/Case4Pos.csv",delimiter=',')



f, axs = plt.subplots(1,2, figsize=(9,4))
f.subplots_adjust(wspace=.4)

column = 2
timeoffset = 0

h = axs[0].plot(TenCate1[:,0], TenCate1[:,column]/1.5e-2 - 0.5,zorder=4)
h = axs[0].plot(TenCate2[:,0] , TenCate2[:,column]/1.5e-2 - 0.5,zorder=3)
h = axs[0].plot(TenCate3[:,0] , TenCate3[:,column]/1.5e-2 - 0.5,zorder=2)
h = axs[0].plot(TenCate4[:,0] , TenCate4[:,column]/1.5e-2 - 0.5,zorder=1)
h = axs[0].plot(TenCate1expP[:,0], TenCate1expP[:,1] * (8 / TenCate1expP[0,1]),"o", fillstyle='left', color = "C0")
h = axs[0].plot(TenCate2expP[:,0], TenCate2expP[:,1] * (8 / TenCate2expP[0,1]),"o", fillstyle='top', color =  "C1")
h = axs[0].plot(TenCate3expP[:,0], TenCate3expP[:,1] * (8 / TenCate3expP[0,1]),"o", fillstyle='right',  color = "C2") 
h = axs[0].plot(TenCate4expP[:,0], TenCate4expP[:,1] * (8 / TenCate4expP[0,1]),"o", fillstyle='bottom',  color = "C3")

axs[0].legend(["Re = 1.5", "Re = 4.1", "Re = 11.6", "Re = 32.2"])
axs[0].set_xlabel(r"t (s)")
axs[0].set_ylabel(r"$pos$ (z/D$_P$)")
axs[0].set_ylim(0, 8.2)
axs[0].set_xlim(0, 4.5)

column = 5

h = axs[1].plot(TenCate1[:,0], TenCate1[:,column],zorder=4)
h = axs[1].plot(TenCate2[:,0] , TenCate2[:,column],zorder=3)
h = axs[1].plot(TenCate3[:,0] , TenCate3[:,column],zorder=2) 
h = axs[1].plot(TenCate4[:,0] , TenCate4[:,column],zorder=1 )
h = axs[1].plot(TenCate1expV[:,0], TenCate1expV[:,1] ,"o", fillstyle='left', color = "C0")
h = axs[1].plot(TenCate2expV[:,0], TenCate2expV[:,1] ,"o", fillstyle='top', color =  "C1")
h = axs[1].plot(TenCate3expV[:,0], TenCate3expV[:,1] ,"o", fillstyle='right',  color = "C2") 
h = axs[1].plot(TenCate4expV[:,0], TenCate4expV[:,1] ,"o", fillstyle='bottom',  color = "C3")

axs[1].legend(["Re = 1.5", "Re = 4.1", "Re = 11.6", "Re = 32.2"])
axs[1].set_ylim(-.14, 0)
axs[1].set_xlim(0, 4.1)
axs[1].set_xlabel(r"t (s)")
axs[1].set_ylabel(r"$v_z$ (m/s)")
f.suptitle("Settling particle in box compared to Ten Cate et al.")
f.savefig(basedir + '/TenCateCases.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution

f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.4)
column = 2


line1 = plt.Line2D([0, 1], [0, 0], linestyle=(0, ()), color="C0")
marker1 = plt.Line2D([0], [0], linestyle="", marker="o", fillstyle='left', color="C0")
line2 = plt.Line2D([0, 1], [0, 0], linestyle=(0, (5,1)), color="C1")
marker2 = plt.Line2D([0], [0], linestyle="", marker="o", fillstyle='top', color="C1")
line3 = plt.Line2D([0, 1], [0, 0], linestyle=(0, (5,3)),  color="C2")
marker3 = plt.Line2D([0], [0], linestyle="", marker="o", fillstyle='right', color="C2")
line4 = plt.Line2D([0, 1], [0, 0], linestyle=(0, (5,6)),color="C3")
marker4 = plt.Line2D([0], [0], linestyle="", marker="o", fillstyle='bottom', color="C3")



h = axs.plot(TenCate1[:,0], TenCate1[:,column]/1.5e-2 - 0.5,zorder=4, linestyle=(0, ()), color = "C0")
h = axs.plot(TenCate2[:,0] , TenCate2[:,column]/1.5e-2 - 0.5,zorder=3, linestyle=(0, (5,1)), color = "C1")
h = axs.plot(TenCate3[:,0] , TenCate3[:,column]/1.5e-2 - 0.5,zorder=2, linestyle=(0, (5,3)), color = "C2")
h = axs.plot(TenCate4[:,0] , TenCate4[:,column]/1.5e-2 - 0.5,zorder=1, linestyle=(0, (5,6)), color = "C3")
h = axs.plot(TenCate1expP[:,0], TenCate1expP[:,1] * (8 / TenCate1expP[0,1]),"o", fillstyle='left', color = "C0")
h = axs.plot(TenCate2expP[:,0], TenCate2expP[:,1] * (8 / TenCate2expP[0,1]),"o", fillstyle='top', color =  "C1")
h = axs.plot(TenCate3expP[:,0], TenCate3expP[:,1] * (8 / TenCate3expP[0,1]),"o", fillstyle='right',  color = "C2") 
h = axs.plot(TenCate4expP[:,0], TenCate4expP[:,1] * (8 / TenCate4expP[0,1]),"o", fillstyle='bottom',  color = "C3")

axs.legend([marker1, marker2, marker3, marker4, line1, line2, line3, line4], ["","","","","Re = 1.5", "Re = 4.1", "Re = 11.6", "Re = 32.2"], columnspacing=-1.5, handletextpad=.9, ncol=2)
axs.set_xlabel(r"t (s)")
axs.set_ylabel(r"$pos$ (z/D$_P$)")
axs.set_ylim(0, 8.2)
axs.set_xlim(0, 4.2)
axs.set_title("Particle position")
f.savefig(basedir + '/TenCateCasesPos.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution



f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.4)


column = 5


h = axs.plot(TenCate1[:,0], TenCate1[:,column],zorder=4, linestyle=(0, ()), color = "C0")
h = axs.plot(TenCate2[:,0] , TenCate2[:,column],zorder=3, linestyle=(0, (5,1)), color = "C1")
h = axs.plot(TenCate3[:,0] , TenCate3[:,column],zorder=2, linestyle=(0, (5,3)), color = "C2")
h = axs.plot(TenCate4[:,0] , TenCate4[:,column],zorder=1, linestyle=(0, (5,6)), color = "C3")
h = axs.plot(TenCate1expV[:,0], TenCate1expV[:,1] ,"o", fillstyle='left', color = "C0")
h = axs.plot(TenCate2expV[:,0], TenCate2expV[:,1] ,"o", fillstyle='top', color =  "C1")
h = axs.plot(TenCate3expV[:,0], TenCate3expV[:,1] ,"o", fillstyle='right',  color = "C2") 
h = axs.plot(TenCate4expV[:,0], TenCate4expV[:,1] ,"o", fillstyle='bottom',  color = "C3")
axs.set_title("Particle velocity")


axs.legend([marker1, marker2, marker3, marker4, line1, line2, line3, line4], ["","","","","Re = 1.5", "Re = 4.1", "Re = 11.6", "Re = 32.2"], columnspacing=-1.5, handletextpad=.9, ncol=2)

axs.set_xlim(0, 4.2)
axs.set_xlabel(r"t (s)")
axs.set_ylabel(r"$v_z$ (m/s)")
f.savefig(basedir + '/TenCateCasesVel.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution
