
import numpy as np
import matplotlib.pyplot as plt
import os

basedir = os.path.dirname(os.path.realpath(__file__)) 

Relist = ["0.031623", "0.100000", 
"0.316228", "1.000000", 
"3.162280", "10.000000", 
"31.622801", "100.000000",
"316.227997","1000.000000",
"3162.280029", "10000.000000",
"31622.800781", "100000.000000"]
resultsdrag = np.zeros([len(Relist),2])

for i in range(len(Relist)):
    Drag = np.genfromtxt(basedir + "/rawdata/" + "Overal_Drag_Re_"+  Relist[i] + ".txt")
    resultsdrag[i,0] = float(Relist[i])
    resultsdrag[i,1] = np.average(Drag[int(0.5*Drag[:,2].size):,2])


ReAnalitic = np.logspace(-2, 7, 1000)
SchillerNauman = np.zeros_like(ReAnalitic)
for i in range(ReAnalitic.size):
    SchillerNauman[i] = 24 / ReAnalitic[i] * (1 + 0.15 * pow(ReAnalitic[i],0.687))
    if SchillerNauman[i] < 0.44:
        SchillerNauman[i] = 0.44
Reswitch = 24/.44
CreapingDragRe = np.linspace(1e-2, Reswitch, 1000)
CreapingDrag = 24/CreapingDragRe
TurbRe = np.linspace(Reswitch, 1e7, 1000)
TurbDrag = 0.44 * np.ones_like(TurbRe)



f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.4, hspace=.1)


h = axs.loglog(resultsdrag[:,0], resultsdrag[:, 1], "o", fillstyle = "left",zorder=4)
h = axs.loglog(ReAnalitic, SchillerNauman, zorder=2)
h = axs.loglog(CreapingDragRe, CreapingDrag, linestyle=(0, (5,1)),zorder=1 )
h = axs.loglog(TurbRe, TurbDrag, linestyle=(0, (5,3)), zorder=1)
axs.legend(["IBM (20 D$_P$ / $\Delta$x)", "Schiller-Naumann", "C$_D$ = 24 / Re", "C$_D$ = 0.44"])
axs.set_xlabel(r"Re")
axs.set_ylabel(r"C$_D$")
axs.set_ylim(.3, 2.4e3)
axs.set_xlim(.01, 3e5)
axs.set_title("Drag coefficient for flow on a sphere")

f.savefig(basedir + '/DragOnSphereDiffRe.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution
