
import numpy as np
import matplotlib.pyplot as plt
import math
import matplotlib.ticker as ticker
from PIL import Image
import os

basedir = os.path.dirname(os.path.realpath(__file__)) + "/rawdata/"
LFRM5 = np.genfromtxt(basedir + "res5/Overal_Drag_Collision.txt")
LFRM10 = np.genfromtxt(basedir + "res10/Overal_Drag_Collision.txt")
LFRM15 = np.genfromtxt(basedir + "res15/Overal_Drag_Collision.txt")
LFRM20 = np.genfromtxt(basedir + "res20/Overal_Drag_Collision.txt")
LFRM25 = np.genfromtxt(basedir + "res25/Overal_Drag_Collision.txt")
LFRM30 = np.genfromtxt(basedir + "res30/Overal_Drag_Collision.txt")
LFRM35 = np.genfromtxt(basedir + "res35/Overal_Drag_Collision.txt")
LFRM40 = np.genfromtxt(basedir + "res40/Overal_Drag_Collision.txt")



f, axs = plt.subplots(1,1, figsize=(5,5))
f.subplots_adjust(wspace=.4, hspace=.1)

column = 4
timeoffset = 2.5


h = axs.plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column])
# h = axs[0].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column],LFRM40[:,0] * 1e3 - 2.6, LFRM40[:,column])
axs.legend(["res = 5 $R_p / \Delta x$","res = 10 $R_p / \Delta x$"
           ,"res = 20 $R_p / \Delta x$","res = 25 $R_p / \Delta x$"
             ,"res = 30 $R_p / \Delta x$"
           ,"res = 35 $R_p / \Delta x$","res = 40 $R_p / \Delta x$",
            "res = 50 $R_p / \Delta x$"])
axs.set_xlabel(r"t (ms)")
axs.set_ylabel(r"$v_x$ (m/s)")
axs.set_xlim(-1, 5.5)
axs.set_ylim(-0.4, 0)
axins = axs.inset_axes(
    [0.3, 0.2, 0.6, 0.35],
    ylim=(-.37, -.35), xlim=(-0.1,4))
h = axins.plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column])
axs.indicate_inset_zoom(axins, edgecolor="black")
axs.set_title("x-velocity at different resolutions")

f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/GridStudyVelocityXCompare.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution



f, axs = plt.subplots(1,2, figsize=(9,4))
f.subplots_adjust(wspace=.4, hspace=.1)

column = 5
timeoffset = 2.5

h = axs[0].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column])
# h = axs[0].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column],LFRM40[:,0] * 1e3 - 2.6, LFRM40[:,column])
axs[0].legend(["res = 5 $R_p / \Delta x$","res = 10 $R_p / \Delta x$"
           ,"res = 15 $R_p / \Delta x$","res = 20 $R_p / \Delta x$"
            ,"res = 25 $R_p / \Delta x$","res = 30 $R_p / \Delta x$"
           ,"res = 35 $R_p / \Delta x$","res = 40 $R_p / \Delta x$",
            "res = 50 $R_p / \Delta x$"])
axs[0].set_xlabel(r"t (ms)")
axs[0].set_ylabel(r"$v_y$ (m/s)")
axs[0].set_xlim(-1, 6)

h = axs[1].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column])
# h = axs[1].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column],LFRM40[:,0] * 1e3 - 2.6, LFRM40[:,column])
axs[1].legend(["res = 5 $R_p / \Delta x$","res = 10 $R_p / \Delta x$"
           ,"res = 15 $R_p / \Delta x$","res = 20 $R_p / \Delta x$"
            ,"res = 25 $R_p / \Delta x$","res = 30 $R_p / \Delta x$"
           ,"res = 35 $R_p / \Delta x$","res = 40 $R_p / \Delta x$",
            "res = 50 $R_p / \Delta x$"])
# axs[1].set_ylim(-0.54, -0.44)
# axs[1].set_xlim(0.325, 0.4)
axs[1].set_xlabel(r"t (ms)")
axs[1].set_ylabel(r"$v_y$ (m/s)")
axs[1].set_xlim(-1, 6)


f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/GridStudyVelocityYCompare.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution





f, axs = plt.subplots(1,1, figsize=(5,5))
f.subplots_adjust(wspace=.4, hspace=.1)

column = 6
timeoffset = 2.6


h = axs.plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column])
# h = axs[0].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column],LFRM40[:,0] * 1e3 - 2.6, LFRM40[:,column])
axs.legend(["res = 5 $R_p / \Delta x$","res = 10 $R_p / \Delta x$"
           ,"res = 20 $R_p / \Delta x$","res = 25 $R_p / \Delta x$"
             ,"res = 30 $R_p / \Delta x$"
           ,"res = 35 $R_p / \Delta x$","res = 40 $R_p / \Delta x$",
            "res = 50 $R_p / \Delta x$"])
axs.set_xlabel(r"t (ms)")
axs.set_ylabel(r"$v_z$ (m/s)")
axs.set_xlim(-1, 5.5)
# axs.set_ylim(-0.4, 0)
axins = axs.inset_axes(
    [0.3, 0.55, 0.6, 0.3],
    ylim=(.27, .325), xlim=(-0.1,4))
h = axins.plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column])
axs.indicate_inset_zoom(axins, edgecolor="black")
axs.set_title("z-velocity at different resolutions")

f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/GridStudyVelocityZCompare.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution



f, axs = plt.subplots(1,2, figsize=(9,4))
f.subplots_adjust(wspace=.4, hspace=.1)

column = 19
timeoffset = 2.6

h = axs[0].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column])
# h = axs[0].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column],LFRM40[:,0] * 1e3 - 2.6, LFRM40[:,column])
axs[0].legend(["res = 5 $R_p / \Delta x$","res = 10 $R_p / \Delta x$"
           ,"res = 15 $R_p / \Delta x$","res = 20 $R_p / \Delta x$"
            ,"res = 25 $R_p / \Delta x$","res = 30 $R_p / \Delta x$"
           ,"res = 35 $R_p / \Delta x$","res = 40 $R_p / \Delta x$",
            "res = 50 $R_p / \Delta x$"])
axs[0].set_xlabel(r"t (ms)")
axs[0].set_ylabel(r"$v_x$ (m/s)")
axs[0].set_xlim(-1, 6)

h = axs[1].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column])
# h = axs[1].plot(LFRM5[:,0] * 1e3 - 2.6, LFRM5[:,column],LFRM10[:,0] * 1e3 - 2.6, LFRM10[:,column],LFRM15[:,0] * 1e3 - 2.6, LFRM15[:,column],LFRM20[:,0] * 1e3 - 2.6, LFRM20[:,column],LFRM25[:,0] * 1e3 - 2.6, LFRM25[:,column],LFRM30[:,0] * 1e3 - 2.6, LFRM30[:,column],LFRM35[:,0] * 1e3 - 2.6, LFRM35[:,column],LFRM40[:,0] * 1e3 - 2.6, LFRM40[:,column])
axs[1].legend(["res = 5 $R_p / \Delta x$","res = 10 $R_p / \Delta x$"
           ,"res = 15 $R_p / \Delta x$","res = 20 $R_p / \Delta x$"
            ,"res = 25 $R_p / \Delta x$","res = 30 $R_p / \Delta x$"
           ,"res = 35 $R_p / \Delta x$","res = 40 $R_p / \Delta x$",
            "res = 50 $R_p / \Delta x$"])
# axs[1].set_ylim(-0.54, -0.44)
# axs[1].set_xlim(0.325, 0.4)
axs[1].set_xlabel(r"t (ms)")
axs[1].set_ylabel(r"$v_x$ (m/s)")
axs[1].set_xlim(-1, 3)
axs[1].set_ylim(0.9, 2.1)

f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/GridStudyNumInterfaceCompare.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution


g = globals()
resolutions = np.array([5,10,15,20,25,30, 35, 40])
begintime =  np.zeros_like(resolutions).astype(float)
endtime =  np.zeros_like(resolutions).astype(float)
bridgelength1 =  np.zeros_like(resolutions).astype(float)
bridgelength2 =  np.zeros_like(resolutions).astype(float)

for i in range(len(resolutions)):

    varname = 'LFRM{}'.format(resolutions[i])
    # print(resolutions[i])
    # print(i)
    llist = (g[varname])
    PointsWithSingleInterface = llist[llist[:,19]==1]
    begin = PointsWithSingleInterface[0,0]
    end = PointsWithSingleInterface[-1,0]
    beginlength = PointsWithSingleInterface[0,1:4] -  PointsWithSingleInterface[0,10:13]
    endlength = PointsWithSingleInterface[-1,1:4] -  PointsWithSingleInterface[-1,10:13] 

    bridgelength1[i] = math.sqrt(endlength[0]  * endlength[0]  + endlength[1]  * endlength[1] + endlength[2]  * endlength[2] ) - 1.5e-3
    bridgelength2[i] =  math.sqrt(endlength[0]  * endlength[0]  + endlength[1]  * endlength[1] + endlength[2]  * endlength[2] ) -  math.sqrt(beginlength[0]  * beginlength[0]  + beginlength[1]  * beginlength[1] + beginlength[2]  * beginlength[2] )




    # print(PointsWithSingleInterface[0,0])
    begintime[i] = begin
    endtime[i] = end

bridgetime = (endtime-begintime)
errorBridge = (bridgelength1[0:-1] - bridgelength1[-1]) / bridgelength1[-1]
errorTime = (bridgetime[0:-1] - bridgetime[-1]) / bridgetime[-1]



f, axs = plt.subplots(1,2, figsize=(9,4))
f.subplots_adjust(wspace=.45, hspace=.1)
h = axs[0].plot(resolutions, bridgetime  * 1e3, "o", fillstyle='left')
h = axs[0].plot(0, 0, "o", fillstyle='right')

axs[0].set_xlabel(r"Resolution (D$_p$ / $\Delta$x)")
axs[0].set_ylabel(r"Rupture time (ms)")
axs[0].set_ylim(0.7, 2.1)
secax = axs[0].twinx()
h = secax.plot(resolutions, bridgelength1  * 1e3,"o",color = "C1", fillstyle='right')
secax.set_xlabel(r"Resolution")
secax.set_ylabel(r"Bride length, L$_B$ (mm)")
secax.tick_params(axis = "y", labelcolor = "C1")
secax.set_ylim(0.6, 2.2)
axs[0].set_title("Liquid bridge properties ")
axs[0].legend(["Rupture time", "Bridge length"])

path_to_image = os.path.dirname(os.path.realpath(__file__)) + "/BridgelengthSketch.png"
image = Image.open(path_to_image)
ax_image = f.add_axes([0.15, 0.15, 0.3, 0.3])
ax_image.imshow(image)
ax_image.axis('off'
)

h = axs[1].loglog(resolutions[0:-1], abs(errorTime) * 100, "o", fillstyle='left')
h = axs[1].loglog( resolutions[0:-1], abs(errorBridge) * 100, "o", fillstyle='right')
h = axs[1].loglog( [10, 20], [20, 5], "-")

axs[1].set_xlabel(r"Resolution (D$_p$ / $\Delta$x)")
axs[1].set_ylabel(r"Error (%)")
axs[1].legend(["Rupture time", "Bridge length", "2nd order"])
axs[1].grid(True, which="both", ls="-")
axs[1].grid(which="minor", color="0.9")
axs[1].set_yticks([1,10,100])
axs[1].set_xticks([5,10,20, 50])
axs[1].set_title("Grid Converence")
axs[1].xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs[1].xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))

f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/GridStudyConvergence3.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution


f, axs = plt.subplots(1,2, figsize=(9,4))
f.subplots_adjust(wspace=.45, hspace=.1)
h = axs[0].plot(resolutions, bridgetime  * 1e3, "o", fillstyle='left')
h = axs[0].plot(0, 0, "o", fillstyle='right')

axs[0].set_xlabel(r"Resolution (D$_p$ / $\Delta$x)")
axs[0].set_ylabel(r"Rupture time (ms)", color = "C0")
axs[0].set_ylim(0.7, 2.1)
axs[0].legend(["Rupture time", "Bridge length"])
axs[0].tick_params(axis = "y", labelcolor = "C0")

secax = axs[0].twinx()
h = secax.plot(resolutions, bridgelength1 / 1.5e-3  ,"o",color = "C1", fillstyle='right')
secax.set_xlabel(r"Resolution")
secax.set_ylabel(r"Bride length, L$_B$ / D$_p$", color = "C1")
secax.tick_params(axis = "y", labelcolor = "C1")
secax.set_ylim(0.6/1.5, 2.2/1.5)
axs[0].set_title("Liquid bridge properties ")

path_to_image = os.path.dirname(os.path.realpath(__file__)) + "/BridgelengthSketch3.png"
image = Image.open(path_to_image)
ax_image = f.add_axes([0.15, 0.15, 0.3, 0.3])
ax_image.imshow(image)
ax_image.axis('off'
)

h = axs[1].loglog(resolutions[0:-1], abs(errorTime) * 100, "o", fillstyle='left')
h = axs[1].loglog( resolutions[0:-1], abs(errorBridge) * 100, "o", fillstyle='right')
h = axs[1].loglog( [10, 20], [20, 5], "-")

axs[1].set_xlabel(r"Resolution (D$_p$ / $\Delta$x)")
axs[1].set_ylabel(r"Error (%)")
axs[1].legend(["Rupture time", "Bridge length", "2nd order"])
axs[1].grid(True, which="both", ls="-")
axs[1].grid(which="minor", color="0.9")
axs[1].set_yticks([1,10,100])
axs[1].set_xticks([5,10,20, 50])
axs[1].set_title("Grid Converence")
axs[1].xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs[1].xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))

f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/GridStudyConvergence4.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution


f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.45, hspace=.1)
h = axs.plot(resolutions, bridgetime  * 1e3, "o", fillstyle='left')
h = axs.plot(0, 0, "o", fillstyle='right')
axs.tick_params(axis = "y", labelcolor = "C0")

axs.set_xlabel(r"Resolution (D$_p$ / $\Delta$x)")
axs.set_ylabel(r"Rupture time (ms)", color = "C0")
axs.set_ylim(0.7, 2.1)
axs.set_xlim(0, 42)

axs.legend(["Rupture time", "Bridge length"])
secax = axs.twinx()
h = secax.plot(resolutions, bridgelength1 / 1.5e-3  ,"o",color = "C1", fillstyle='right')
secax.set_xlabel(r"Resolution")
secax.set_ylabel(r"Bride length, L$_B$ / D$_p$", color = "C1")
secax.tick_params(axis = "y", labelcolor = "C1")
secax.set_ylim(0.6/1.5, 2.2/1.5)
axs.set_title("Liquid bridge proportions")

path_to_image = os.path.dirname(os.path.realpath(__file__)) + "/BridgelengthSketch3.png"
image = Image.open(path_to_image)
ax_image = f.add_axes([0.33, 0.08, 0.5, 0.5])
ax_image.imshow(image)
ax_image.axis('off'
)
f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/GridStudyConvergence4a.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution


f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.45, hspace=.1)


h = axs.loglog(resolutions[0:-1], abs(errorTime) * 100, "o", fillstyle='left')
h = axs.loglog( resolutions[0:-1], abs(errorBridge) * 100, "o", fillstyle='right')
h = axs.loglog( [10, 20], [20, 5], "-")

axs.set_xlabel(r"Resolution (D$_p$ / $\Delta$x)")
axs.set_ylabel(r"Error (%)")
axs.legend(["Rupture time", "Bridge length", "2nd order"])
axs.grid(True, which="both", ls="-")
axs.grid(which="minor", color="0.9")
axs.set_yticks([1,10,100])
axs.set_xticks([5,10,20, 50])
axs.set_title("Grid size converence")
axs.xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))
axs.xaxis.set_major_formatter(ticker.StrMethodFormatter("{x:.0f}"))

f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/GridStudyConvergence4b.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution


