
import numpy as np
import matplotlib.pyplot as plt
import math
from mpl_toolkits.axes_grid1.inset_locator import inset_axes
import os
from PIL import Image

basedir = os.path.dirname(os.path.realpath(__file__))  + "/rawdata"
Particle = np.genfromtxt(basedir + "/Overal_Drag_Collision.txt")
Droplet = np.genfromtxt(basedir + "/EggShape.txt")

velocity = -0.7
diameter = 1.5e-3
distance =  20e-3 + 6.8 * diameter/2
rhos = 1120
rhol = 1.293e-3
g = -9.81
CD = 0.5
Re = 104
CD = 24/Re * (1+0.15 * pow(Re, 0.687))
radius = diameter/2
mp = 4/3 * radius * radius * radius * math.pi * rhos
Fg = mp * g
Fd = 1/2 * rhol * CD * velocity * velocity * radius * math.pi
vterm = math.sqrt(4 * abs(g) * diameter * (rhos - rhol) / (3 * CD * rhol))  

distance = -Particle[-1,3]+Particle[0,3]
v0 = -math.sqrt(velocity * velocity + (2 * g * distance))
s0 = 0

timeA = np.linspace(0, 0.06, 20)
velocityA = v0 + g * timeA
distanceA = s0 - v0 * timeA - g * timeA * timeA * 0.5

column = 3
timeoffset = 0

f, axs = plt.subplots(1,2, figsize=(9.2,4))
f.subplots_adjust(wspace=.4, hspace=.1)
h = axs[0].plot(Particle[:,0]*1e3, 1e3* -1 * (Particle[:,column]-Particle[0,column]),zorder=5, linestyle=(0, (5,0)))
h = axs[0].plot([0 ,60], [distance*1e3, distance*1e3],zorder=3, linestyle=(0,(3,3)))
h = axs[0].plot(1e3*timeA, 1e3*distanceA,"o" , fillstyle='none',zorder=4)
axs[0].set_xlabel(r"t (ms)")
axs[0].set_ylabel(r"distance (mm)")
axs[0].set_xlim(0, 62)
axs[0].set_ylim(0, 25)
axs[0].legend(["Simulation", "distance = 24.4 mm", "Theory"])

column = 6

h = axs[1].plot(Particle[:,0]*1e3, Particle[:,column],zorder=5, linestyle=(0, (5,0)))
h = axs[1].plot([0,60], [velocity, velocity] ,zorder=3, linestyle=(0,(3,3)))
h = axs[1].plot(1e3*timeA, velocityA,"o", fillstyle='none',zorder=4)
axs[1].set_xlabel(r"t (ms)")
axs[1].set_ylabel(r"velocity (m/s)")
axs[1].set_xlim(0, 62)
# axs[1].set_ylim(-.72, 0)
axs[1].legend(["Simulation", "v = -0.7 m/s", "Theory"])

f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/VelocityAndPositionFallingParticle.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution

column = 3

f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.4, hspace=.1)
h = axs.plot(Particle[:,0]*1e3, 1e3* -1 * (Particle[:,column]-Particle[0,column]),zorder=5, linestyle=(0, (5,0)))
h = axs.plot([0 ,60], [distance*1e3, distance*1e3],zorder=3, linestyle=(0,(3,3)))
h = axs.plot(1e3*timeA, 1e3*distanceA,"o" , fillstyle='none',zorder=4)
axs.set_xlabel(r"t (ms)")
axs.set_ylabel(r"distance (mm)")
axs.set_xlim(0, 62)
axs.set_ylim(0, 25)
axs.legend(["Simulation", "distance = 24.4 mm", "Theory"], loc='best',   borderaxespad=1)
f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/PositionFallingParticle.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution

column = 6

f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.4, hspace=.1)
h = axs.plot(Particle[:,0]*1e3, Particle[:,column],zorder=5, linestyle=(0, (5,0)))
h = axs.plot([0,60], [velocity, velocity] ,zorder=3, linestyle=(0,(3,3)))
h = axs.plot(1e3*timeA, velocityA,"o", fillstyle='none',zorder=4)
axs.set_xlabel(r"t (ms)")
axs.set_ylabel(r"velocity (m/s)")
axs.set_xlim(0, 62)
axs.legend(["Simulation", "v = -0.7 m/s", "Theory"], loc='best',   borderaxespad=1)

f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/VelocityFallingParticle.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution




Dropletnew = np.vstack(([0, -radius-150e-6, -radius-150e-6, -radius-150e-6, radius+150e-6, radius+150e-6, radius+150e-6, 0, 0, 0], Droplet))  # Stack the zero row on top
Dropletnew[:,0] *= 1e3 

Middle = Dropletnew[:,7:10]
ThicknessLowerSide = Middle - Dropletnew[:,1:4] - radius
ThicknessHigherSide = Dropletnew[:,4:7] - Middle - radius


timeoffset = 0



f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.4, hspace=.1)

h = axs.plot([0,  Dropletnew[-1,0]], [150, 150], ":", Dropletnew[:,0], ThicknessLowerSide[:,2] * 1e6, Dropletnew[:,0], ThicknessHigherSide[:,2] * 1e6, Dropletnew[:,0], ThicknessHigherSide[:,0] * 0.25e6 + ThicknessLowerSide[:,0] * 0.25e6 + ThicknessHigherSide[:,1] * 0.25e6 + ThicknessLowerSide[:,1] * 0.25e6)
axs.legend(["h$_{initial}$", "h$_{bottom}$","h$_{top}$", "h$_{side}$"])
axs.set_xlabel(r"t (ms)")
axs.set_ylabel(r"thickness $(\mu m)$")
axs.set_title("Liquid distribution on falling wet particle")


path_to_image = os.path.dirname(os.path.realpath(__file__)) + "/EggshapeSketch.png"
image = Image.open(path_to_image)
ax_image = f.add_axes([0.51, 0.24, 0.4, 0.5])
ax_image.imshow(image)
ax_image.axis('off'
)

axs.set_xlim(0, 60)
f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/EggshapeWithSketch.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution


f, axs = plt.subplots(1,1, figsize=(4,4))
f.subplots_adjust(wspace=.4, hspace=.1)
h = axs.plot([0,  Dropletnew[-1,0]], [150, 150], ":", Dropletnew[:,0], ThicknessLowerSide[:,2] * 1e6, Dropletnew[:,0], ThicknessHigherSide[:,2] * 1e6, Dropletnew[:,0], ThicknessHigherSide[:,0] * 0.25e6 + ThicknessLowerSide[:,0] * 0.25e6 + ThicknessHigherSide[:,1] * 0.25e6 + ThicknessLowerSide[:,1] * 0.25e6)
axs.legend(["h$_{initial}$", "h$_{bottom}$","h$_{top}$", "h$_{side}$"])
axs.set_xlabel(r"t (ms)")
axs.set_ylabel(r"thickness $(\mu m)$")
axs.set_title("Liquid distribution on falling wet particle")
f.savefig(os.path.dirname(os.path.realpath(__file__)) + '/Eggshape.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution

