import numpy as np
import matplotlib.pyplot as plt
import os


thisdir = os.path.dirname(os.path.realpath(__file__)) 


expdir    = thisdir + "/literature/bunke/Results_Versuch_"
simdir    = thisdir + "/rawdata/withgravity_muwet/bunke"
simdirdry = thisdir + "/rawdata/withgravity_mudry/bunke"

exp120vel = np.genfromtxt(expdir + "70_vel.csv", delimiter=";")
exp120vel[:,0] -= 0.013529412
exp145vel = np.genfromtxt(expdir + "155_vel.csv", delimiter=";")
exp145vel[:,0] -= 0.015098039
exp165vel = np.genfromtxt(expdir + "56_vel.csv", delimiter=";")
exp165vel[:,0] -= 0.012352941
exp177vel = np.genfromtxt(expdir + "42_vel.csv", delimiter=";")
exp177vel[:,0] -= 0.01254902


sim120 = np.genfromtxt(simdir + "120/Overal_Drag_Collision.txt")
sim120[:,0] -= 3.05e-3
sim145 = np.genfromtxt(simdir + "145_2/Overal_Drag_Collision.txt")
sim145[:,0] -= 2.651e-3
sim165 = np.genfromtxt(simdir + "165_3/Overal_Drag_Collision.txt")
sim165[:,0] -= 2.6e-3
sim177 = np.genfromtxt(simdir + "177/Overal_Drag_Collision.txt")
sim177[:,0] -= 2.4e-3

sim120dry  = np.genfromtxt(simdirdry + "120/Overal_Drag_Collision.txt")
sim120dry[:,0] -= 3.05e-3
sim145dry = np.genfromtxt(simdirdry + "145/Overal_Drag_Collision.txt")
sim145dry[:,0] -= 2.651e-3
sim165dry = np.genfromtxt(simdirdry + "165/Overal_Drag_Collision.txt")
sim165dry[:,0] -= 2.6e-3
sim177dry = np.genfromtxt(simdirdry + "177/Overal_Drag_Collision.txt")
sim177dry[:,0] -= 2.4e-3


dataexp = exp120vel
datasim = sim120
datasimdry = sim120dry

f, axs = plt.subplots(1,2, figsize=(10,4.5))
f.subplots_adjust(wspace=.4, hspace=.1)
h = axs[0].plot(dataexp[:,0]*1e3, dataexp[:,4], "o", fillstyle='left', color = "C0")
h = axs[0].plot(dataexp[:,0]*1e3, dataexp[:,8], "o", fillstyle='right', color = "C1")
h = axs[0].plot(datasim[:,0]*1e3, datasim[:,6], color = "C0")
h = axs[0].plot(datasim[:,0]*1e3, datasim[:,15], color = "C1")
h = axs[0].plot(datasimdry[:,0]*1e3, datasimdry[:,6], color = "C0", linestyle=(0, (5, 5)))
h = axs[0].plot(datasimdry[:,0]*1e3, datasimdry[:,15], color = "C1", linestyle=(0, (5, 5)))

axs[0].legend(["Exp P1 ", "Exp P2", "Sim $\mu_{wet}$ P1", "Sim $\mu_{wet}$ P2", "Sim $\mu_{dry}$ P1", "Sim $\mu_{dry}$ P2"], loc = "center left")
axs[0].set_xlabel(r"t (ms)")
axs[0].set_ylabel(r"v$_x$ (m/s)")
axs[0].set_ylim(-0.8, 0.6)
axs[0].set_xlim(-3.1 ,4.5)



ax2 = axs[1].twinx()
h = axs[1].plot(dataexp[:,0]*1e3, dataexp[:,2], "o", fillstyle='left', color = "C0")
h = axs[1].plot(dataexp[:,0]*1e3, dataexp[:,6], "o", fillstyle='right', color = "C1")
h = axs[1].plot(datasim[:,0]*1e3, datasim[:,4], color = "C0")
h = axs[1].plot(datasim[:,0]*1e3, datasim[:,13], color = "C1")
h = axs[1].plot(datasimdry[:,0]*1e3, datasimdry[:,4], color = "C0", linestyle=(0, (5, 5)))
h = axs[1].plot(datasimdry[:,0]*1e3, datasimdry[:,13], color = "C1", linestyle=(0, (5, 5)))


axs[1].legend(["Exp P1 ", "Exp P2", "Sim $\mu_{wet}$ P1", "Sim $\mu_{wet}$ P2", "Sim $\mu_{dry}$ P1", "Sim $\mu_{dry}$ P2"], loc = "center right")
axs[1].set_xlabel(r"t (ms)")
axs[1].set_ylabel(r"v$_x$ (m/s)")
axs[1].set_ylim(-0.7, 0.7)
axs[1].set_xlim(-3.1 ,4.5)
f.savefig(thisdir + '/velocities120_2.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution


dataexp = exp145vel
datasim = sim145
datasimdry = sim145dry

f, axs = plt.subplots(1,2, figsize=(10,4.5))
f.subplots_adjust(wspace=.4, hspace=.1)
h = axs[0].plot(dataexp[:,0]*1e3, dataexp[:,4], "o", fillstyle='left', color = "C0")
h = axs[0].plot(dataexp[:,0]*1e3, dataexp[:,8], "o", fillstyle='right', color = "C1")
h = axs[0].plot(datasim[:,0]*1e3, datasim[:,6], color = "C0")
h = axs[0].plot(datasim[:,0]*1e3, datasim[:,15], color = "C1")
h = axs[0].plot(datasimdry[:,0]*1e3, datasimdry[:,6], color = "C0", linestyle=(0, (5, 5)))
h = axs[0].plot(datasimdry[:,0]*1e3, datasimdry[:,15], color = "C1", linestyle=(0, (5, 5)))

axs[0].legend(["Exp P1 ", "Exp P2", "Sim $\mu_{wet}$ P1", "Sim $\mu_{wet}$ P2", "Sim $\mu_{dry}$ P1", "Sim $\mu_{dry}$ P2"], loc = "center left")
axs[0].set_xlabel(r"t (ms)")
axs[0].set_ylabel(r"v$_x$ (m/s)")
axs[0].set_ylim(-0.8, 0.6)
axs[0].set_xlim(-3.1 ,4.5)



ax2 = axs[1].twinx()
h = axs[1].plot(dataexp[:,0]*1e3, dataexp[:,2], "o", fillstyle='left', color = "C0")
h = axs[1].plot(dataexp[:,0]*1e3, dataexp[:,6], "o", fillstyle='right', color = "C1")
h = axs[1].plot(datasim[:,0]*1e3, datasim[:,4], color = "C0")
h = axs[1].plot(datasim[:,0]*1e3, datasim[:,13], color = "C1")
h = axs[1].plot(datasimdry[:,0]*1e3, datasimdry[:,4], color = "C0", linestyle=(0, (5, 5)))
h = axs[1].plot(datasimdry[:,0]*1e3, datasimdry[:,13], color = "C1", linestyle=(0, (5, 5)))


axs[1].legend(["Exp P1 ", "Exp P2", "Sim $\mu_{wet}$ P1", "Sim $\mu_{wet}$ P2", "Sim $\mu_{dry}$ P1", "Sim $\mu_{dry}$ P2"], loc = "center right")
axs[1].set_xlabel(r"t (ms)")
axs[1].set_ylabel(r"v$_x$ (m/s)")
axs[1].set_ylim(-0.7, 0.7)
axs[1].set_xlim(-3.1 ,4.5)
f.savefig(thisdir + '/velocities145_2.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution



dataexp = exp165vel
datasim = sim165
datasimdry = sim165dry

f, axs = plt.subplots(1,2, figsize=(10,4.5))
f.subplots_adjust(wspace=.4, hspace=.1)
h = axs[0].plot(dataexp[:,0]*1e3, dataexp[:,4], "o", fillstyle='left', color = "C0")
h = axs[0].plot(dataexp[:,0]*1e3, dataexp[:,8], "o", fillstyle='right', color = "C1")
h = axs[0].plot(datasim[:,0]*1e3, datasim[:,6], color = "C0")
h = axs[0].plot(datasim[:,0]*1e3, datasim[:,15], color = "C1")
h = axs[0].plot(datasimdry[:,0]*1e3, datasimdry[:,6], color = "C0", linestyle=(0, (5, 5)))
h = axs[0].plot(datasimdry[:,0]*1e3, datasimdry[:,15], color = "C1", linestyle=(0, (5, 5)))

axs[0].legend(["Exp P1 ", "Exp P2", "Sim $\mu_{wet}$ P1", "Sim $\mu_{wet}$ P2", "Sim $\mu_{dry}$ P1", "Sim $\mu_{dry}$ P2"], loc = "center right")
axs[0].set_xlabel(r"t (ms)")
axs[0].set_ylabel(r"v$_x$ (m/s)")
axs[0].set_ylim(-0.8, 0.6)
axs[0].set_xlim(-3.1 ,4.5)



ax2 = axs[1].twinx()
h = axs[1].plot(dataexp[:,0]*1e3, dataexp[:,2], "o", fillstyle='left', color = "C0")
h = axs[1].plot(dataexp[:,0]*1e3, dataexp[:,6], "o", fillstyle='right', color = "C1")
h = axs[1].plot(datasim[:,0]*1e3, datasim[:,4], color = "C0")
h = axs[1].plot(datasim[:,0]*1e3, datasim[:,13], color = "C1")
h = axs[1].plot(datasimdry[:,0]*1e3, datasimdry[:,4], color = "C0", linestyle=(0, (5, 5)))
h = axs[1].plot(datasimdry[:,0]*1e3, datasimdry[:,13], color = "C1", linestyle=(0, (5, 5)))


axs[1].legend(["Exp P1 ", "Exp P2", "Sim $\mu_{wet}$ P1", "Sim $\mu_{wet}$ P2", "Sim $\mu_{dry}$ P1", "Sim $\mu_{dry}$ P2"], loc = "upper left")
axs[1].set_xlabel(r"t (ms)")
axs[1].set_ylabel(r"v$_x$ (m/s)")
axs[1].set_ylim(-0.5, 0.9)
axs[1].set_xlim(-3.1 ,4.5)
f.savefig(thisdir + '/velocities165_2.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution


dataexp = exp177vel
datasim = sim177
datasimdry = sim177dry

f, axs = plt.subplots(1,2, figsize=(10,4.5))
f.subplots_adjust(wspace=.4, hspace=.1)
h = axs[0].plot(dataexp[:,0]*1e3, dataexp[:,4], "o", fillstyle='left', color = "C0")
h = axs[0].plot(dataexp[:,0]*1e3, dataexp[:,8], "o", fillstyle='right', color = "C1")
h = axs[0].plot(datasim[:,0]*1e3, datasim[:,6], color = "C0")
h = axs[0].plot(datasim[:,0]*1e3, datasim[:,15], color = "C1")
h = axs[0].plot(datasimdry[:,0]*1e3, datasimdry[:,6], color = "C0", linestyle=(0, (5, 5)))
h = axs[0].plot(datasimdry[:,0]*1e3, datasimdry[:,15], color = "C1", linestyle=(0, (5, 5)))

axs[0].legend(["Exp P1 ", "Exp P2", "Sim $\mu_{wet}$ P1", "Sim $\mu_{wet}$ P2", "Sim $\mu_{dry}$ P1", "Sim $\mu_{dry}$ P2"], loc = "center right")
axs[0].set_xlabel(r"t (ms)")
axs[0].set_ylabel(r"v$_x$ (m/s)")
axs[0].set_ylim(-0.8, 0.6)
axs[0].set_xlim(-3.1 ,4.5)



ax2 = axs[1].twinx()
h = axs[1].plot(dataexp[:,0]*1e3, dataexp[:,2], "o", fillstyle='left', color = "C0")
h = axs[1].plot(dataexp[:,0]*1e3, dataexp[:,6], "o", fillstyle='right', color = "C1")
h = axs[1].plot(datasim[:,0]*1e3, datasim[:,4], color = "C0")
h = axs[1].plot(datasim[:,0]*1e3, datasim[:,13], color = "C1")
h = axs[1].plot(datasimdry[:,0]*1e3, datasimdry[:,4], color = "C0", linestyle=(0, (5, 5)))
h = axs[1].plot(datasimdry[:,0]*1e3, datasimdry[:,13], color = "C1", linestyle=(0, (5, 5)))

axins = axs[1].inset_axes(
    [0.1, 0.02, 0.8, 0.4],
    ylim=(-0.08, 0.08), xlim=(-0.5, 4.5))
h = axins.plot(dataexp[:,0]*1e3, dataexp[:,2], "o", fillstyle='left', color = "C0")
h = axins.plot(dataexp[:,0]*1e3, dataexp[:,6], "o", fillstyle='right', color = "C1")
h = axins.plot(datasim[:,0]*1e3, datasim[:,4], color = "C0")
h = axins.plot(datasim[:,0]*1e3, datasim[:,13], color = "C1")
h = axins.plot(datasimdry[:,0]*1e3, datasimdry[:,4], color = "C0", linestyle=(0, (5, 5)))
h = axins.plot(datasimdry[:,0]*1e3, datasimdry[:,13], color = "C1", linestyle=(0, (5, 5)))
axins.xaxis.set_major_locator(plt.NullLocator())
axins.yaxis.set_major_locator(plt.NullLocator())

axs[1].indicate_inset_zoom(axins, edgecolor="black")


axs[1].legend(["Exp P1 ", "Exp P2", "Sim $\mu_{wet}$ P1", "Sim $\mu_{wet}$ P2", "Sim $\mu_{dry}$ P1", "Sim $\mu_{dry}$ P2"], loc = "upper right")
axs[1].set_xlabel(r"t (ms)")
axs[1].set_ylabel(r"v$_x$ (m/s)")
axs[1].set_ylim(-0.7, 0.7)
axs[1].set_xlim(-3.1 ,4.5)
f.savefig(thisdir + '/velocities177_2.png', dpi=900, bbox_inches = 'tight')  # Increase dpi for higher resolution
