# -*- coding: utf-8 -*-
"""
Created on Fri Apr 17 14:52:45 2020

@author: TUD278427
"""
#%%
import numpy as np
from matplotlib import pyplot as plt
from matplotlib.colors import LogNorm

#%%
plt.figure('paper_fig')
plt.clf()

params = {'mathtext.default': 'regular' }          
plt.rcParams.update(params)

# Figure a
data = np.load('fig3a.npz', allow_pickle = True)
x1_Vp = data['x1_Vp']
y1_Isd = data['y1_Isd']
x2_Vp = data['x2_Vp']
y2_dIsddVp = data['y2_dIsddVp']

ax = plt.subplot(221)
ax.plot(x1_Vp, y1_Isd,'.-')
ax.set_ylabel('$I_{SD}$ (nA)', color = 'C0')
ax2 = ax.twinx()
ax2.plot(x2_Vp, y2_dIsddVp, 'C3.-')
ax2.set_ylabel('$dI_{SD}/dV_{P}$ (nA/mV)', color='C3')
ax.set_xlabel('$V_{P}$ (mV)')

#%%
# Figure c
data = np.load('fig3c.npz', allow_pickle = True)
x_f = data['x_f']
y_Se = data['y_Se']

ax3 = plt.subplot(222)
plt.plot(x_f, y_Se, '.')
ax3.set_yscale('log')
ax3.set_xscale('log')
ax3.set_xlim(0.1, 45)
ax3.set_ylim(1e-14, 1e-11)
fd = np.array([ -0.91624996, -12.26906333])
plt.loglog(x_f[1:], 10**(np.log10(x_f[1:])*fd[0]+fd[1]), 'black')
ax3.set_xlabel('f (Hz)')
ax3.set_ylabel('$S_{E}$ $(eV^2/Hz)$')
ax3.text(0.9, 2e-12,'$S_{E} \propto 1/f^{0.92}$')

#%%
# Figure c
data = np.load('fig3b.npz', allow_pickle = True)
x_Vp = data['x_Vp']
y_f = data['y_f']
z_S = data['z_S']

ax4 = plt.subplot(223)
plt.pcolormesh(x_Vp, y_f, z_S, norm=LogNorm(vmin=1e-16, vmax=1e-11))
plt.yscale('log')
plt.xlabel('$V_{P}$ (mV)')
plt.ylim((0.1,1e2))
plt.ylabel('f (Hz)')
c = plt.colorbar()
c.ax.set_ylabel('$S$ $(V^2/Hz)$')

#%%
# Figure d
data = np.load('fig3d.npz', allow_pickle = True)
x_deviceindex = data['x_deviceindex']
y_Se = data['y_Se']

ax5 = plt.subplot(224)
Ses1 = [y_Se[0]]
Ses2 = list(y_Se[1:])
plt.plot(range(len(Ses1)), Ses1, '.C3')
plt.plot(range(len(Ses1),len(Ses1) + len(Ses2)), Ses2, '.C0')
ax5.set_xlabel('device, dot')
ax5.set_xticks([0,1,2,3,4,5])
ax5.set_xticklabels(x_deviceindex)
ax5.set_ylabel('$\sqrt{S_{E}}$ @ 1 Hz ($\mu eV/\sqrt{Hz}$)')
plt.hlines(np.mean(y_Se), 0, 5, linestyles  = 'dashed', linewidth=1)
ax5.text(1, 0.65, '$\overline{\sqrt{S_{E}}}$ = ' + f'{np.mean(y_Se):.2f}' +' $\mu eV/\sqrt{Hz}$')

#%% Final layout and saving
plt.tight_layout()
ax2_p = ax2.get_position()
ax2_p.x1 = ax4.get_position().x1
ax2.set_position(ax2_p)
plt.savefig(r'D:\manuscripts\ge_60nm\fig4.pdf')