#!/bin/sh

#SBATCH -J ""
#SBATCH --partition=genoa
#SBATCH --time=120:00:00
#SBATCH --nodes=1
#SBATCH --ntasks=108
#SBATCH --tasks-per-node=108
#SBATCH --output JobStatistics_%j.log
#SBATCH --mail-type=BEGIN,END
#SBATCH --mail-user=
#SBATCH --nodes=1
#SBATCH --exclusive

module load EESSI/2023.06
module load OpenFOAM/v2312-foss-2023a
source /cvmfs/software.eessi.io/versions/2023.06/software/linux/x86_64/amd/zen2/software/OpenFOAM/v2312-foss-2023a/OpenFOAM-v2312/etc/bashrc

. ./preProcess.sh

module list

# rm -rf processor*/*00

# rm -rf postProcess*

#rm -rf log.*    # Remove old log files if they exist

#rm -rf *.log 

# rm -rf *.out 

#rm -rf processor*

rm -rf ./0

# rm -rf ./100

cp -r ./0.orig ./0

#rm -rf ./constant/polyMesh

blockMesh  > blockMesh.log 2>&1

snappyHexMesh -overwrite > snappyHexMesh.log 2>&1

topoSet    > topoSet.log 2>&

checkMesh    > checkMesh.log 2>&1

decomposePar -force > decompose.log 2>&1

mpirun -n 108 pimpleFoam -parallel > solver.log 2>&1

reconstructPar -latestTime  > reconstructPar.log 2>&1

# rm -rf processor*
