This data repository contains the data shown in our paper 'Optimal entanglement distribution policies in homogeneous repeater chains with cutoffs' ([arXiv:2207.06533](https://arxiv.org/abs/2207.06533)).
In this work, we find entanglement distribution policies that generate end-to-end entanglement as fast as possible (on average). We formulate the problem as a Markov decision process and solve it using value iteration and policy iteration.

All the data can be generated using the code from [this GitHub repository](https://github.com/AlvaroGI/optimal-homogeneous-chain). For more information about how to read the data in Python and how to use it, see [the same GitHub repository](https://github.com/AlvaroGI/optimal-homogeneous-chain).


The data is structured as follows:

	- `data_policyiter/`: each (pickle) file contains the optimal policy (and the expected delivery time) found by our policy iteration algorithm for a specific set of parameters. Each file has filename `nX_pXX_psXXX_tcXXXX_tolXXXXX`, where
		- X is the number of nodes;
		- XX is the probability of successful entanglement generation;
		- XXX is the probability of successful entanglement swap;
		- XXXX is the cutoff time;
		- XXXXX is the tolerance used in our policy iteration algorithm.


	- `data_valueiter/`: contains data related to our value iteration algorithm:
		- `model/`: these files describe the Markov decision process and are necessary to run value iteration, but do not contain any data that is directly shown in our manuscript.
			- `MDPmodel_nX_tcXX_equations.pkl`: Bellman equations for a homogeneous repeater chain with X nodes and cutoff XX.
			- `MDPmodel_nX_tcXX_linkLabels.npy`: link labels for a homogeneous repeater chain with X nodes and cutoff XX.
			- `MDPmodel_nX_tcXX_states.npy`: list of states in a homogeneous repeater chain with X nodes and cutoff XX.
		- `solution/`: each (pickle) file contains the optimal policy (and the expected delivery time) found by our value iteration algorithm for a specific set of parameters. Each file has filename `MDPsol_nX_pXX_psXXX_tcXXXX_tolXXXXX_randomseedY`, where
		- X is the number of nodes;
		- XX is the probability of successful entanglement generation;
		- XXX is the probability of successful entanglement swap;
		- XXXX is the cutoff time;
		- XXXXX is the tolerance used in our policy iteration algorithm.
		- Y is the random seed.


	- `data_swapasap/`: each (pickle) file contains the information about the swap-asap policy (e.g., expected delivery time) for a specific set of parameters. Each file has filename `swapasap_nX_pXX_psXXX_tcXXXX_tolXXXXX`, where
		- X is the number of nodes;
		- XX is the probability of successful entanglement generation;
		- XXX is the probability of successful entanglement swap;
		- XXXX is the cutoff time;
		- XXXXX is the tolerance used in our policy iteration algorithm.


	- `data_sim/`: each (pickle) file contains the expected delivery times obtained after simulating some policy on a repeater chain many times. Each file has filename `Y_nX_pXX_psXXX_tcXXXX_samplesZ_randseedZZ_tolXXXXX.pickle`, where
		- Y is the policy (optimal, swap-asap, or wait);
		- X is the number of nodes;
		- XX is the probability of successful entanglement generation;
		- XXX is the probability of successful entanglement swap;
		- XXXX is the cutoff time;
		- Z is the number of samples;
		- ZZ is the random seed;
		- XXXXX is the tolerance used in our policy iteration algorithm (only used if Y is 'optimal').

