% Plotting the results figures

%% Plot parameters

par.color1      = [0.137 0.137 0.137];
par.color2      = [0     0.447 0.741];
par.color3      = [0.850 0.325 0.098];
par.color4      = [0.984 0.551 0.348];
par.color5      = [0.715 0.934 0.961];
par.x00         = 10;
par.y00         = 10;
par.width       = 600;
par.height      = 200;
par.fontsize    = 16;
par.fontname    = 'Times';
par.markersize  = 120;
par.markerTypes = ['*', 'o', '^', '+', 'x', 's'];
par.linewidth   = 2.5;

%% Fig. 3. RMS of jerk for 30 seconds of quiet sitting

figure;
set(gcf,'Position',[par.x00, par.y00, par.width, 2*par.height]);

for idx=1:height(datatable)
    % Plot Resultant
    subplot(2,1,1);
    hold on; grid on;
    ax = gca; ax.XMinorGrid = true; ax.YMinorGrid = true;
    ax.FontSize = par.fontsize; ax.FontName = par.fontname;
    
    scatter(datatable.age(idx),datatable.RMSJerkRes(idx), ...
        par.markersize, par.color1, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    
    ylabel('RMS(j) (m/s^3)'); title('Resultant')
    
    % Plot AP/ML components
    subplot(2,1,2);
    hold on; grid on;
    ax = gca; ax.XMinorGrid = true; ax.YMinorGrid = true;
    ax.FontSize = par.fontsize; ax.FontName = par.fontname;
    
    % AP
    scatter(datatable.age(idx),datatable.RMSJerkAP(idx), ...
        par.markersize, par.color2, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    
    % ML
    scatter(datatable.age(idx),datatable.RMSJerkML(idx), ...
        par.markersize, par.color3, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    legend('AP','ML','Location','southoutside','Orientation','horizontal')
    xlabel('Age (months)'); ylabel('RMS(j) (m/s^3)'); title('Individual components')
end

% Adjust positions and turn off x-axis
temp(1) = subplot(2,1,1); temp(2) = subplot(2,1,2);
temp(2).Position(2) = temp(2).Position(2) + (temp(2).Position(4)-temp(1).Position(4));
temp(2).Position(4) = temp(1).Position(4);
temp(1).XAxis.Visible = 'off';
clear temp

%% Fig. 4. RMS of jerk for different 30-second segments

figure;
set(gcf,'Position',[par.x00, par.y00, par.width, 3*par.height]);

for idx=1:height(datatable)
    % Plot Resultant
    temp(1) = subplot(3,1,1);
    hold on; grid on;
    ax = gca; ax.XMinorGrid = true; ax.YMinorGrid = true;
    ax.FontSize = par.fontsize; ax.FontName = par.fontname;
    
    scatter(datatable.age(idx),datatable.RMSJerkRes(idx), ...
        par.markersize, par.color1, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    scatter(datatable.age(idx),datatable.RMSJerkRes2(idx), ...
        par.markersize, par.color4, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    scatter(datatable.age(idx),datatable.RMSJerkRes3(idx), ...
        par.markersize, par.color5, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    
    ylabel('RMS(j) (m/s^3)'); title('Resultant')
    
    % Plot AP component
    temp(2) = subplot(3,1,2);
    hold on; grid on;
    ax = gca; ax.XMinorGrid = true; ax.YMinorGrid = true;
    ax.FontSize = par.fontsize; ax.FontName = par.fontname;
    
    scatter(datatable.age(idx),datatable.RMSJerkAP(idx), ...
        par.markersize, par.color1, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    scatter(datatable.age(idx),datatable.RMSJerkAP2(idx), ...
        par.markersize, par.color4, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    scatter(datatable.age(idx),datatable.RMSJerkAP3(idx), ...
        par.markersize, par.color5, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    
    ylabel('RMS(j) (m/s^3)'); title('AP direction')
    
    % Plot ML component
    temp(3) = subplot(3,1,3);
    hold on; grid on;
    ax = gca; ax.XMinorGrid = true; ax.YMinorGrid = true;
    ax.FontSize = par.fontsize; ax.FontName = par.fontname;
    
    scatter(datatable.age(idx),datatable.RMSJerkML(idx), ...
        par.markersize, par.color1, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    scatter(datatable.age(idx),datatable.RMSJerkML2(idx), ...
        par.markersize, par.color4, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    scatter(datatable.age(idx),datatable.RMSJerkML3(idx), ...
        par.markersize, par.color5, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    
    xlabel('Age (months)'); ylabel('RMS(j) (m/s^3)'); title('ML direction')
end

% Adjust positions and turn off x-axis
temp(3).Position(2) = temp(3).Position(2) + (temp(3).Position(4)-temp(1).Position(4));
temp(3).Position(4) = temp(1).Position(4);
temp(1).XAxis.Visible = 'off'; temp(2).XAxis.Visible = 'off';
clear temp

%% Fig. 5. RMS of jerk compared to RMS of COP velocity

figure;
set(gcf,'Position',[par.x00, par.y00, par.width, 1.5*par.height])

for idx=1:height(datatable)
    hold on; grid on;
    ax = gca; ax.XMinorGrid = true; ax.YMinorGrid = true;
    ax.FontSize = par.fontsize; ax.FontName = par.fontname;
    colororder([par.color1; par.color4]); yyaxis left
    
    % Jerk
    h1 = scatter(datatable.age(idx), datatable.RMSJerkRes(idx), ...
        par.markersize, par.color1, par.markerTypes(idx), 'Linewidth', par.linewidth);
    ylabel('RMS(j)'); yyaxis right
    
    % COP velocity
    h2 = scatter(datatable.age(idx), datatable.RMSCOPRes(idx), ...
        par.markersize, par.color4, par.markerTypes(idx),'Linewidth', par.linewidth);
    ylabel('RMS(v)'); title('Candidate metrics by age')
    
    legend([h1,h2],'IMU','COP','Location','southoutside','Orientation','horizontal')
end

%% Fig. 6. RMS of linear acceleration and RMS of angularvelocity in both the AP and ML directions

figure;
set(gcf,'Position',[par.x00, par.y00, par.width, 2*par.height]);

for idx=1:height(datatable)
    % Acceleration
    subplot(2,1,1);
    hold on; grid on;
    ax = gca; ax.XMinorGrid = true; ax.YMinorGrid = true;
    ax.FontSize = par.fontsize; ax.FontName = par.fontname;
    
    scatter(datatable.age(idx),datatable.RMSaccAP(idx), ...
        par.markersize, par.color1, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    scatter(datatable.age(idx),datatable.RMSaccML(idx), ...
        par.markersize, par.color4, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    
    ylabel('RMS(a) (m/s^2)'); title('Secondary outcome metrics')
    
    % Plot AP/ML components
    subplot(2,1,2);
    hold on; grid on;
    ax = gca; ax.XMinorGrid = true; ax.YMinorGrid = true;
    ax.FontSize = par.fontsize; ax.FontName = par.fontname;
    
    % AP
    scatter(datatable.age(idx),datatable.RMSvelAP(idx), ...
        par.markersize, par.color1, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    scatter(datatable.age(idx),datatable.RMSvelML(idx), ...
        par.markersize, par.color4, par.markerTypes(idx), ...
        'Linewidth', par.linewidth);
    legend('AP','ML','Location','southoutside','Orientation','horizontal')
    xlabel('Age (months)'); ylabel('RMS(v) (rad/s)');
end

% Adjust positions and turn off x-axis
temp(1) = subplot(2,1,1); temp(2) = subplot(2,1,2);
temp(2).Position(2) = temp(2).Position(2) + (temp(2).Position(4)-temp(1).Position(4));
temp(2).Position(4) = temp(1).Position(4);
temp(1).XAxis.Visible = 'off';
clear temp
