***Impact Aware Robotics Archive***
===================================

***General Info***

Authors:
- M.J. Jongeneel
- S. Dingemans

Title: Archive_025_ImpactAwareObjectTracking
Files:
- 230821_Archive_025_ImpactAwareObjectTracking.h5
- README.md

Dynamics & Control Group, Faculty of Mechanical Engineering, Eindhoven University of Technology

Corresponding author: M.J. Jongeneel 

Contact Information: m.j.jongeneel@tue.nl

Eindhoven University of Technology - Faculty of Mechanical Engineering

P.O. Box 513 5600 MB Eindhoven The Netherlands

***General Introduction***
I.AM. dataset as part of the Impact-Aware Robotics Archives Collection. This archive contains recordings of experiments where Box006, Box007, and Box009 are tossed on a running conveyor, with an industrial background, from two different viewpoints. The purpose of these experiments is to validate the impact-aware object tracking algorithm for tossed boxes in logistic environments. The involved contact is between the object and the environment, which in these recordings are Box006, Box007, and Box009  and a conveyor (Conveyor002), respectively. All the recordings in the archive were performed at the Innovation Lab of Vanderlande, located within the TU/e campus. More information about the dataset, the objects, and the environments used, can be found on https://impact-aware-robotics-database.tue.nl/.      

This archive is published accompanying the deliverable ``I.AM. - D1.1 - Publication of I.AM. dataset - v1.0``, see [https://i-am-project.eu/index.php/results/deliverables](https://i-am-project.eu/index.php/results/deliverables) for more info.
This research project has received funding from the European Union’s Horizon 2020 research and innovation program under grant agreement No. 871899.

***Test equipment***

The experiments involve long range tosses of Box006, Box007, and Box009 on a running conveyor (Conveyor002). The box is tossed by the UR10, and impacts and slides over the conveyor. Data was logged using an OptiTrack motion capture system, an Intel Realsense D415 reference camera, and sensors from the UR10 robot. Further details of the equipment are provided as metadata in each recording subfolder of the archive. 

***Description of the data in this archive***

This archive contains a total of 6 subfolders, each corresponding to a specific recording. Each folder follows the naming convention ``Rec_<timestamp>``, where the timestamp corresponds to the start time of the recording, expressed according to ISO 8601. The contents of these subfolders all have the same structure, which is described in the file called "recording_format".