%%%    SIF   %%%
%  Jinne 2022  %
%%%%%%%%%%%%%%%%

clearvars; close all; clc

load('data/SIFdatatablesRAW.mat')

%Save data in array
SIFdata = SIFdataRAW;

%find all reps of trial
indexRef   = find(SIFdata(:,3)==1);
indexBlind = find(SIFdata(:,3)==2);
indexCatch = find(SIFdata(:,3)==3);

%alocate memory
meanxRef   = zeros(3,10);
meanxBlind = zeros(3,10);
meanxCatch = zeros(3,10);

%loop over three stiffness levels
for jj=1:3
    
    %find all index of stiffness
    indexRefst        = indexRef(SIFdata(indexRef,2)==jj);
    indexBlindst      = indexBlind(SIFdata(indexBlind,2)==jj);
    indexCatchst      = indexCatch(SIFdata(indexCatch,2)==jj);
    
    %find all reps from one participant
    for ii=1:10

        indexRefpp   = find(SIFdata(indexRefst,1)==ii);
        indexBlindpp = find(SIFdata(indexBlindst,1)==ii);
        indexCatchpp = find(SIFdata(indexCatchst,1)==ii);

        %fill seperate trials X
        xRefpp   = SIFdata(indexRefst(indexRefpp),6);
        xBlindpp = SIFdata(indexBlindst(indexBlindpp),6);
        xCatchpp = SIFdata(indexCatchst(indexCatchpp),6);

        %Calculate mean positions for each participant
        meanxRef(jj,ii)   = mean(xRefpp);
        meanxBlind(jj,ii) = mean(xBlindpp);
        meanxCatch(jj,ii) = mean(xCatchpp);
        
        clear indexRefpp indexBlindpp indexCatchpp xRefpp xBlindpp xCatchpp
        
    end

    clear indexRefst indexBlindst indexCatchst 
end

%% Make plots
close all

%Mean position over all trials
figure(1)

%Add boxplot
x1 = [1000*meanxRef(1,:); 1000*meanxBlind(1,:); 1000*meanxCatch(1,:)];
x2 = [1000*meanxRef(2,:); 1000*meanxBlind(2,:); 1000*meanxCatch(2,:)];
x3 = [1000*meanxRef(3,:); 1000*meanxBlind(3,:); 1000*meanxCatch(3,:)];

g1 = repmat({'Low'},10,1);
g2 = repmat({'Medium'},10,1);
g3 = repmat({'High'},10,1);
g = [g1; g2; g3];

subplot(1,3,1)
    boxplot(x1',g); hold on
subplot(1,3,2)
    boxplot(x2',g); hold on
subplot(1,3,3)
    boxplot(x3',g); hold on

hAx=gca;
xtk=hAx.XTick;
hold on
    
%Add infividual means 'o' per participant
for jj=1:10
    
    subplot(1,3,1)
    scatter(1, 1000*  meanxRef(1,jj), 'o','LineWidth',2, 'jitter','on', 'jitterAmount',0.2); hold on
    scatter(2, 1000*meanxBlind(1,jj), 'o','LineWidth',2, 'jitter','on', 'jitterAmount',0.2); hold on
    scatter(3, 1000*meanxCatch(1,jj), 'o','LineWidth',2, 'jitter','on', 'jitterAmount',0.2); hold on
    ylim([13 24])
    title({'Mean position of all participants';'Low Stiffness'})
    ylabel('Position [mm]')
    
    subplot(1,3,2)
    scatter(1, 1000*  meanxRef(2,jj), 'o','LineWidth',2, 'jitter','on', 'jitterAmount',0.2); hold on
    scatter(2, 1000*meanxBlind(2,jj), 'o','LineWidth',2, 'jitter','on', 'jitterAmount',0.2); hold on
    scatter(3, 1000*meanxCatch(2,jj), 'o','LineWidth',2, 'jitter','on', 'jitterAmount',0.2); hold on
    ylim([13 24])
    title({'Mean position of all participants';'Medium Stiffness'})
    ylabel('Position [mm]')
    
    subplot(1,3,3)
    scatter(1, 1000*  meanxRef(3,jj), 'o','LineWidth',2, 'jitter','on', 'jitterAmount',0.2); hold on
    scatter(2, 1000*meanxBlind(3,jj), 'o','LineWidth',2, 'jitter','on', 'jitterAmount',0.2); hold on
    scatter(3, 1000*meanxCatch(3,jj), 'o','LineWidth',2, 'jitter','on', 'jitterAmount',0.2); hold on
    ylim([13 24])
    title({'Mean position of all participants';'High Stiffness'})
    ylabel('Position [mm]')
    
    
end



