#!/bin/bash

PARENT="$(dirname "$0")/feature-tests"
echo "Verifying all feature tests!"
VERIFY="ExpectVerify"
FAIL="ExpectFailorError"


for DIR in {"buffers","dataAccessors","kernels","localAccessors","kernels/itemMethodsInjective"}
do 
    echo "Start Verifying $DIR"

    if [ -d "$PARENT/$DIR/$VERIFY" ]; then
        for FILE in $(ls $PARENT/$DIR/$VERIFY | grep -E '\.cpp')
        do
        echo "Start Verifying $DIR/$VERIFY/$FILE"
        vercors -q --silicon-quiet --no-infer-heap-context-into-frame $PARENT/$DIR/$VERIFY/$FILE

        if [[ $? -eq 0 ]]; then
            echo " ✓ Verified $FILE succesfully"
        else
            echo " x Unexpected outcome for $FILE"
            exit 1
        fi
        done
    fi

    if [ -d "$PARENT/$DIR/$FAIL" ]; then
        for FILE in $(ls $PARENT/$DIR/$FAIL | grep -E '\.cpp')
        do
        echo "Start Verifying $DIR/$FAIL/$FILE"
        vercors -q --silicon-quiet --no-infer-heap-context-into-frame $PARENT/$DIR/$FAIL/$FILE

        if [[ $? -ne 0 ]]; then
            echo " ✓ Fail or errored $FILE as expected"
        else
            echo " x Unexpected outcome for $FILE"
            exit 1
        fi
        done
    fi

    echo "Done Verifying $DIR"
done



