#################################################################################
# Pitremove algorithm for LddTill (based on LddTop).				#
#										#
# Ingrid Takken, 28 November 1999						#
#################################################################################


binding

#Input
  Dem = dem.map;             # Input map (Could be replaced with LddTop) 
  MapEdge = mapedge.map;     # Map showing the edge of the map sheet.
  LddPit = lddtill.map;      # The Ldd-map that needs to be corrected. 

#Output
  LddNew = pitrem.map;
  pitscheck = pits.map;


areamap
  Dem;


timer 
  1 8 1;   
  output = endtime; 	# If you would take this out, you would get output maps for each time step.


initial

  Dem = lddcreatedem(Dem,1e31,1e31,1e31,1e31);
  LddTop = lddcreate(Dem,1e31,1e31,1e31,1e31);
  LddNew = LddPit;

# The pit-cells are replaced by topographic direction.
# If the flow direction of the cell where the water will flow to is in direction
# back to the same cell, now the downstream cell is changed in a pit. 
# This procedure is repeated several times.


dynamic

  LddPit = LddNew;

  Pits = boolean(pit(LddPit));
  Pits = if(MapEdge, 0, Pits); # Leave pits at the edge of the map sheet out of consideration
  LddNew = if(Pits, LddTop, LddPit);
   # Identify cells that flow towards former pits:
  DownPit = boolean(if(downstream(LddNew,Pits) eq 1,1,0));
  DownPit = cover(DownPit, 0);
   # Direction of these 'pit - dowstream - cells':
  DownDir = scalar(directional(downstream(LddNew,LddNew)));
   # Flow direction in (former pit-cel):
  FlowDir = scalar(directional(LddNew));
  Toe = boolean(if(abs(DownDir-FlowDir) eq 180, 1,0));
  Toe = cover(Toe, 0);
  LddNew = if(DownPit and Toe, 5, LddNew);
report LddNew = lddrepair(LddNew);
report pitscheck = if(MapEdge, 0, pit(LddNew));
