#################################################################################
# Model to calculate an output map that defines where water will flow in	#
# topographic or tillage direction. 						#
# The model is based on the logistic regression equation described by 		#
# Takken et al., 2001b.								#
#										#
# Ingrid Takken, 8 February 1999						#
#################################################################################


binding

# INPUT
  Fields = fields.map;		# Map with fields (nominal)
  Dem = dem.map;		# DEM 
  TillDir = tilldir2.map;     	# Map with tillage directions, directional 0-180 (-1 voor notill)
  Angle = angle.map;		# Map with the angle between tillage and aspect direction
  RO = roughnes.map;		# Map with degree of oriented roughness in cm

# OUTPUT
  logitRO = logit.map;		# The logit of the probability of flow in topographic direction
  toptill = toportil.map;	# Boolean map with flow direction: 0 = topographic, 1 = tillage 


initial

  dummy1 = boolean(cover(1, Dem));
  dummy0 = boolean(cover(0, Dem));
  dx = celllength();
  dy = celllength();

# Pit removal from the DEM.

  Dem = lddcreatedem(Dem,1e31,1e31,1e31,1e31);
  SlopeTop = slope(Dem);

# LOGISTIC FUNCTION TO PREDICT THE PROBABILITY OF FLOW IN TOPOGRAPHIC DIRECTION

  AspectTop = aspect(Dem);
  Angle = abs(scalar(AspectTop)-scalar(TillDir));
  Angle = scalar(if(Angle gt 180, 360-Angle, Angle));
  Angle = scalar(if(Angle gt 90, 180-Angle, Angle));

report logitRO = -5.9165 + 13.3402*SlopeTop + 0.1020*Angle - 0.4173*RO;

toptill = boolean(if(logitRO gt 0.0, 0, 1));
toptill = if(RO eq 0, 0, toptill); 
toptill = cover(toptill, 0);            # No-till area (forest, pasture) get zero
report toptill = boolean(if(Fields ne 0, toptill)); # Part outside of catchment gets missing values

