#################################################################################
# Tillage-Controlled Runoff Pattern Model (TCRP model)                  	#
# Method 1                                                              	#
#										#
# Model to calculate a runoff pattern (Ldd-map), whereby water will		# 
# flow in the direction of the plough-lines.                             	#
#                                                                       	#
# The model is described in Takken, I., Jetten, V., Govers, G., 		#
# Nachtergaele, N. and Steegen, A., 2001. Geomorphology, 37, in press.  	#
#                                                                       	#
# Ingrid Takken, 24 December 2000                                       	#
#                                                                       	#
#################################################################################

binding

# INPUT
  Dem = dem.map;              # Digital elevation model
  Fields = fields.map;        # Nominal Input map, geen veld met id 0 or 1!!
  TillDir = tilldir.map;      # Input map, scalar 0-180 (-1 voor notill)
  Chan = chan.map;            # Boolean Input map with channels
  LddChan = chanldd.map;      # Ldd for channels

# OUTPUT
  Edge = MapEdge.map;         # Edge of fields map
  LddTill = LddTill1.map;     # Output map
  SlopeTill = SlopeTi1.map;   # Slope in direction of flow
  FlowDir = flowdir1.map;

initial

  Chan = boolean(Chan);
  dummy1 = boolean(cover(1, Dem));
  dx = celllength();
  dy = celllength();


# CALCULATION OF SLOPE, ASPECT AND LDD IN TOPOGRAPHIC DIRECTION

  Dem = lddcreatedem(Dem,1e31,1e31,1e31,1e31);
  LddTop = lddcreate(Dem,1e31,1e31,1e31,1e31);
  Aspect = aspect(Dem);
  SlopeTop = slope(Dem);


# CALCULATION EDGES OF FIELDS AND OF TOTAL MAP-SHEET

 # Randen van kaartblad  (Dem moet een rand groter zijn dan Fields)
    Ldd2 = spatial(ldd(2));
    Ldd4 = spatial(ldd(4));
    Ldd6 = spatial(ldd(6));
    Ldd8 = spatial(ldd(8));
    down2 = boolean(downstream(Ldd2, dummy1));
    down4 = boolean(downstream(Ldd4, dummy1));
    down6 = boolean(downstream(Ldd6, dummy1));
    down8 = boolean(downstream(Ldd8, dummy1));
    rand = down2 and down4 and down6 and down8;
    rand = boolean(if(rand, 0));
    rand = cover(rand,1);
    Fields = if(rand eq 0, Fields);

 # For pitremove algorithm: make a zone on the map edge to select (and keep) pits on the edge
   mask = scalar(if(Fields ne 0, 0, 1));
   mask = cover(mask,1);
   # bereken kaart met hoogste waarde in midden v. fields en
   # laagste waarden langs de rand.
    Spread = spread(nominal(mask),0,1);
    Edge = boolean(if(Spread le (1.5*dx), 1, 0));
 report Edge = boolean(if(boolean(mask) ne Edge, 1, 0));

# MC - different data types of TillDir maps

# TillDir = scalar, mv outside fields, -1 no tillages, 0-180 tillage direction
# TillDirD = directional, mv on all fields etc without tillage
   TillDirD = if(TillDir ne -1, directional(TillDir));
# TillDirS = scalar, mv on all fields etc without tillage
   TillDirS = scalar(TillDirD);


# CALCULATION OF SLOPE IN TILLAGE DIRECTION

    Ldd1 = spatial(ldd(1));
    Ldd2 = spatial(ldd(2));
    Ldd3 = spatial(ldd(3));
    Ldd4 = spatial(ldd(4));
    Ldd6 = spatial(ldd(6));
    Ldd7 = spatial(ldd(7));
    Ldd8 = spatial(ldd(8));
    Ldd9 = spatial(ldd(9));
    Dem1 = downstream(Ldd1, Dem);
    Dem2 = downstream(Ldd2, Dem);
    Dem3 = downstream(Ldd3, Dem);
    Dem4 = downstream(Ldd4, Dem);
    Dem6 = downstream(Ldd6, Dem);
    Dem7 = downstream(Ldd7, Dem);
    Dem8 = downstream(Ldd8, Dem);
    Dem9 = downstream(Ldd9, Dem);

  # dz/dx en dz/dy bepalen volgens Horn (1981).
    dz_dx = ((Dem1+2*Dem4+Dem7)/4 - (Dem3+2*Dem6+Dem9)/4) / (2*dx);
    dz_dy = ((Dem1+2*Dem2+Dem3)/4 - (Dem7+2*Dem8+Dem9)/4) / (2*dx);

  # Let op: TillDir gerekend in clockwise direction met 0 in het noorden,
  #         y-as is dan de aanliggende zijde..

   SlopeTil = scalar((dz_dx)*sin(TillDirD)+(dz_dy)*cos(TillDirD));


# CALCULATION OF DOWNSTREAM TILLAGE DIRECTION

 #  TillDir1 = TillDir; # (behoud de oorspronkelijke kaart)
#   TillDir = scalar(if(scalar(TillDir) ne -1, TillDir)); # Dit geeft missing values voor no direction
   Till = boolean(if(TillDir ne -1, 1, 0)); # wordt gebruikt voor hellingskaart
   TillDirDown = scalar(if(SlopeTil lt 0, TillDirS-180, TillDirS));
   TillDirDown = scalar(if(TillDirDown lt 0, TillDirDown+360 ,TillDirDown));
   SlopeTil = abs(SlopeTil);


# CALCULATION OF FIELD BORDERS AND ANGLE PERPENDICULAR TO BORDER.

  downField = downstream(Ldd1,Fields);
  grens1 = boolean(if(Fields ne downField then 1 else 0));
  grens1 = cover(grens1, 0);
  somx = if(grens1, -0.7071, 0);
  somy = if(grens1, -0.7071, 0);
  downField = downstream(Ldd2,Fields);
  grens2 = boolean(if(Fields ne downField then 1 else 0));
  grens2 = cover(grens2, 0);
  somx = if(grens2, somx, somx);
  somy = if(grens2, somy-1, somy);
  downField = downstream(Ldd3,Fields);
  grens3 = boolean(if(Fields ne downField then 1 else 0));
  grens3 = cover(grens3, 0);
  somx = if(grens3, somx+0.7071, somx);
  somy = if(grens3, somy-0.7071, somy);
  downField = downstream(Ldd4,Fields);
  grens4 = boolean(if(Fields ne downField then 1 else 0));
  grens4 = cover(grens4, 0);
  somx = if(grens4, somx-1, somx);
  somy = if(grens4, somy, somy);
  downField = downstream(Ldd6,Fields);
  grens6 = boolean(if(Fields ne downField then 1 else 0));
  grens6 = cover(grens6, 0);
  somx = if(grens6, somx+1, somx);
  somy = if(grens6, somy, somy);
  downField = downstream(Ldd7,Fields);
  grens7 = boolean(if(Fields ne downField then 1 else 0));
  grens7 = cover(grens7, 0);
  somx = if(grens7, somx-0.7071, somx);
  somy = if(grens7, somy+0.7071, somy);
  downField = downstream(Ldd8,Fields);
  grens8= boolean(if(Fields ne downField then 1 else 0));
  grens8 = cover(grens8, 0);
  somx = if(grens8, somx, somx);
  somy = if(grens8, somy+1, somy);
  downField = downstream(Ldd9,Fields);
  grens9= boolean(if(Fields ne downField then 1 else 0));
  grens9 = cover(grens9, 0);
  somx = if(grens9, somx+0.7071, somx);
  somy = if(grens9, somy+0.7071, somy);
  pgrens = grens2 or grens4 or grens6 or grens8;


# CALCULATION DIRECTION PERPENDICULAR TO FIELD BORDER (out of field)

 # De vier richtingen van de assen:
  Angle = directional(if(somx eq 0 and somy gt 0, 90, -1)); 
  Angle = if(somx eq 0 and somy lt 0, 270, Angle);
  Angle = if(somy eq 0 and somx gt 0, 0, Angle);
  Angle = if(somy eq 0 and somx lt 0, 180, Angle);
 # De vier kwadranten:
  Angle = directional(if(somy gt 0 and somx gt 0, scalar(atan(somy/somx)), scalar(Angle)));
  Angle = directional(if(somy gt 0 and somx lt 0, 180+scalar(atan(somy/somx)), scalar(Angle)));
  Angle = directional(if(somy lt 0 and somx lt 0, 180+scalar(atan(somy/somx)), scalar(Angle)));
  Angle = directional(if(somy lt 0 and somx gt 0, 360+scalar(atan(somy/somx)), scalar(Angle)));
  Angle = if(pgrens, Angle);

 # Angle omzetten naar tilldir-assenstelsel.
  Angle = directional(90-scalar(Angle));
  Angle = directional(if(scalar(Angle) lt 0, scalar(Angle)+360, scalar(Angle)));


# CALCULATE TWO POSSIBLE FLOW DIRECTIONS AT BORDERS.

  grenzen = ordinal(if(pgrens, Fields)); # elk veld een eigen grens nr. 
  mask = scalar(if(dummy1, 9999));

   dir1 = directional(if(downstream(Ldd1, grenzen) eq grenzen,225));
   dif1 = scalar(abs(scalar(dir1)-scalar(Angle)));
   dif1 = scalar(if(dif1 gt 180, 360-dif1, dif1));
   # Dif mag geen nul zijn, dit gebeurt nl alleen waar er een smalle channel (of weg) diagonaal binnen veld ligt.
   dif1 = if(dif1 lt 36, 9999, dif1);
   dif1 = cover(dif1, mask); # Hoek tussen mogelijke ldd richting en Angle (richting loodrecht op p-grens)
   dir2 = directional(if(downstream(Ldd2, grenzen) eq grenzen,180));
   dif2 = scalar(abs(scalar(dir2)-scalar(Angle)));
   dif2 = scalar(if(dif2 gt 180, 360-dif2, dif2)); 
   dif2 = cover(dif2, mask);
   dir3 = directional(if(downstream(Ldd3, grenzen) eq grenzen,135));
   dif3 = scalar(abs(scalar(dir3)-scalar(Angle)));
   dif3 = scalar(if(dif3 gt 180, 360-dif3, dif3)); 
   dif3 = if(dif3 lt 36, 9999, dif3);
   dif3 = cover(dif3, mask);
   dir4 = directional(if(downstream(Ldd4, grenzen) eq grenzen,270));
   dif4 = scalar(abs(scalar(dir4)-scalar(Angle)));
   dif4 = scalar(if(dif4 gt 180, 360-dif4, dif4)); 
   dif4 = cover(dif4, mask);
   dir6 = directional(if(downstream(Ldd6, grenzen) eq grenzen,90));
   dif6 = scalar(abs(scalar(dir6)-scalar(Angle)));
   dif6 = scalar(if(dif6 gt 180, 360-dif6, dif6)); 
   dif6 = cover(dif6, mask);
   dir7 = directional(if(downstream(Ldd7, grenzen) eq grenzen,315));
   dif7 = scalar(abs(scalar(dir7)-scalar(Angle)));
   dif7 = scalar(if(dif7 gt 180, 360-dif7, dif7)); 
   dif7 = if(dif7 lt 36, 9999, dif7);
   dif7 = cover(dif7, mask);
   dir8 = directional(if(downstream(Ldd8, grenzen) eq grenzen,0));
   dif8 = scalar(abs(scalar(dir8)-scalar(Angle)));
   dif8 = scalar(if(dif8 gt 180, 360-dif8, dif8)); 
   dif8 = cover(dif8, mask);
   dir9 = directional(if(downstream(Ldd9, grenzen) eq grenzen,45));
   dif9 = scalar(abs(scalar(dir9)-scalar(Angle)));
   dif9 = scalar(if(dif9 gt 180, 360-dif9, dif9)); 
   dif9 = if(dif9 lt 36, 9999, dif9);
   dif9 = cover(dif9, mask);
   minim = min(dif1, dif2, dif3, dif4, dif6, dif7, dif8, dif9);
   minim = if(pgrens, minim);
   min1 = ldd(if(dif1 eq minim, 1));
   min2 = ldd(if(dif2 eq minim, 2));
   poss1 = cover(min2, min1);
   min3 = ldd(if(dif3 eq minim, 3));
   poss1 = cover(min3, poss1);
   min4 = ldd(if(dif4 eq minim, 4));
   poss1 = cover(min4, poss1);
   min6 = ldd(if(dif6 eq minim, 6));
   poss1 = cover(min6, poss1);
   min7 = ldd(if(dif7 eq minim, 7));
   poss1 = cover(min7, poss1);
   min8 = ldd(if(dif8 eq minim, 8));
   poss1 = cover(min8, poss1);
   min9 = ldd(if(dif9 eq minim, 9));
   poss1 = cover(min9, poss1);
   minim = if(poss1 eq 1, min(dif2, dif3, dif4, dif6, dif7, dif8, dif9), 9999);
   minim = if(poss1 eq 2, min(dif1, dif3, dif4, dif6, dif7, dif8, dif9), minim);
   minim = if(poss1 eq 3, min(dif1, dif2, dif4, dif6, dif7, dif8, dif9), minim);
   minim = if(poss1 eq 4, min(dif1, dif2, dif3, dif6, dif7, dif8, dif9), minim);
   minim = if(poss1 eq 6, min(dif1, dif2, dif3, dif4, dif7, dif8, dif9), minim);
   minim = if(poss1 eq 7, min(dif1, dif2, dif3, dif4, dif6, dif8, dif9), minim);
   minim = if(poss1 eq 8, min(dif1, dif2, dif3, dif4, dif6, dif7, dif9), minim);
   minim = if(poss1 eq 9, min(dif1, dif2, dif3, dif4, dif6, dif7, dif8), minim);
   minim2 = minim;
   min1 = ldd(if(dif1 eq minim and poss1 ne 1, 1));
   min2 = ldd(if(dif2 eq minim and poss1 ne 2, 2));
   poss2 = cover(min2, min1);
   min3 = ldd(if(dif3 eq minim and poss1 ne 3, 3));
   poss2 = cover(min3, poss2);
   min4 = ldd(if(dif4 eq minim and poss1 ne 4, 4));
   poss2 = cover(min4, poss2);
   min6 = ldd(if(dif6 eq minim and poss1 ne 6, 6));
   poss2 = cover(min6, poss2);
   min7 = ldd(if(dif7 eq minim and poss1 ne 7, 7));
   poss2 = cover(min7, poss2);
   min8 = ldd(if(dif8 eq minim and poss1 ne 8, 8));
   poss2 = cover(min8, poss2);
   min9 = ldd(if(dif9 eq minim and poss1 ne 9, 9));
   poss2= cover(min9, poss2);
   # Als er geen tweede mogelijkheid is..
   poss2= if(minim eq 9999, poss1, poss2);


# SCHEIDING WENDAKKERS (headlands) VAN PARALLEL-PGRENZEN

# Bepalen of grens langs wendakker loopt of niet.
   # Hoek tussen Angle (richting loodrecht op grens) en TillDir.
   dif1 = scalar(abs(scalar(directional(Angle))-scalar(TillDirDown)));
   dif1 = scalar(if(dif1 gt 180, 360-dif1, dif1));
   evenw = boolean(if(dif1 gt 60 and dif1 lt 120, 1, 0));
   wa = boolean(if(evenw eq 1, 0, 1));


# CALCULATION OF LDD FOR PARCEL BORDERS

# Ldd voor pgrenzen op basis van hoek tussen mogelijke richting en TillDirDown.
   # Hoek tussen mogelijke str richting 1 (poss1) en TillDirDown.
   dif1 = scalar(abs(scalar(directional(poss1))-scalar(TillDirDown)));
   dif1 = scalar(if(dif1 gt 180, 360-dif1, dif1));
   # Hoek tussen mogelijke str richting 2 (poss2) en TillDirDown.
   dif2 = scalar(abs(scalar(directional(poss2))-scalar(TillDirDown)));
   dif2 = scalar(if(dif2 gt 180, 360-dif2, dif2));
   Lddgrens = ldd(if(dif1 lt dif2, poss1, poss2));

# Ldd voor wendakker op basis van hoek tussen mogelijke richting en GrensDirDown.
   # Richting p-grens is Angle-90. 
   GrensDir = scalar(directional(scalar(Angle)+90));
   SlopeGrens = scalar((dz_dx)*sin(GrensDir)+(dz_dy)*cos(GrensDir));
   GrensDirDown = scalar(if(SlopeGrens lt 0, GrensDir-180, GrensDir));
   GrensDirDown = scalar(if(GrensDirDown lt 0, GrensDirDown+360 ,GrensDirDown));
   # Hoek tussen mogelijke richting 1 en GrensDirDown. 
   dif1 = scalar(abs(scalar(directional(poss1))-scalar(GrensDirDown)));
   dif1 = scalar(if(dif1 gt 180, 360-dif1, dif1));
   # Hoek tussen mogelijke richting 2 (poss2) en GrensDirDown.
   dif2 = scalar(abs(scalar(directional(poss2))-scalar(GrensDirDown)));
   dif2 = scalar(if(dif2 gt 180, 360-dif2, dif2));
   Lddgrens = ldd(if(wa and dif1 lt dif2, poss1, Lddgrens));
   Lddgrens = ldd(if(wa and dif2 lt dif1, poss2, Lddgrens));

   opposite = scalar(directional(Lddgrens))-180;
   opposite = scalar(if(opposite lt 0, opposite+360, opposite));
   toestroom = boolean(if(downstream(Lddgrens,scalar(directional(Lddgrens))) eq opposite,1,0));
   toestroom = cover(toestroom, 0);
   hoger = boolean(if(downstream(Lddgrens, Dem) gt Dem,1,0));
   hoger = cover(hoger,0);
   Lddgrens = if(toestroom and hoger, 5, Lddgrens);

   # Alleen pgrens-stroming langs bewerkte velden!
   Till = boolean(if(scalar(TillDir) ne -1, 1, 0));
   Lddgrens = if(Till, Lddgrens);

   # Nodig om toestroom op vlakke delen te herkennen (geen 'hoger');
   Lddgrens = lddrepair(Lddgrens);

   SlopeGrens = scalar((dz_dx)*sin(GrensDirDown)+(dz_dy)*cos(GrensDirDown));
   SlopeGrens = if(wa, SlopeGrens, SlopeTil);
   SlopeGrens = if(Till, SlopeGrens);


# CALCULATION OF TILLAGE LDD.
    LddTill = ldd(directional(TillDirDown));

# FIND PITS.
    TillDirUp = ldd(directional(TillDirDown-180));    
    toestroom = boolean(if(downstream(LddTill, ldd(directional(TillDirDown))) eq TillDirUp,1,0));
    toestroom = cover(toestroom, 0);
    hoger = boolean(if(downstream(LddTill, Dem) gt Dem,1,0));
    hoger = cover(hoger,0);
    LddTill = if(toestroom and hoger, 5, LddTill);
# report Temp0 = LddTill;

# SUPERIMPOSE PARCEL BORDER LDD.
    LddTill = cover(Lddgrens, LddTill);
# report Temp1 = LddTill;

# SUPERIMPOSE LDD FOR TOPOGRAPHIC ZONES (forests, pastures).
    LddTill = cover(LddTill, LddTop);
# report Temp2 = LddTill;

# SUPERIMPOSE CHANNEL DIRECTIONS.
    LddTill= cover(LddChan, LddTill);

# FIND PITS AND CIRCULAR FLOW.
    LddTill = lddrepair(LddTill);
    Pits = boolean(pit(LddTill));
# report Temp3 = LddTill;

# IF PIT THEN TOP-DIRECTION. 
    LddTill = if(Pits and not Edge, LddTop, LddTill);
    LddTill = lddrepair(LddTill);
# report Temp4 = LddTill;


# SLOPE CALCULATION (1)

  SlopeTill = scalar(if(TillDir ne -1, SlopeTil, SlopeTop));
  DirChan = directional(LddChan);
  SlopeChan = scalar((dz_dx)*sin(DirChan)+(dz_dy)*cos(DirChan));
  SlopeTill = cover(SlopeChan, SlopeTill);
  SlopeTill = cover(SlopeGrens, SlopeTill);
  SlopeTill = if(Pits eq 1, SlopeTop, SlopeTill);
  LddTmp = LddTill;   # Nodig voor SLOPE CALCULATION (2).

  FlowDir = if(TillDir ne -1, directional(TillDirDown), Aspect);
  FlowDir = cover(DirChan,FlowDir);
  GrDir = directional(if(wa, GrensDirDown, TillDirDown));
  GrDir = if(SlopeGrens gt -1, GrDir);
  FlowDir = cover(GrDir, FlowDir);
  FlowDir = if(Pits eq 1, Aspect, FlowDir);
  # SlopeTill moet dus overeenkomen met slope in FlowDir.


# CORRECTION FOR CROSSING FLOW LINES.

# Het is mogelijk dat stroomlijnen elkaar diagonaal kruisen.
# Locaties waar dit plaats vindt worden opgezocht en verbeterd. 
 
 # A.
 # Water mag niet over een smalle weg/channel (diagonaal 1 cel breed) stromen.
 # Wanneer zo'n smalle weg in binnen 1 veld ligt met tilldir dwars op
 # de weg kan dit wel gebeuren.
 # In dit geval wordt alleen de stroomrichting op het veld aangepast.
 # (Hiervoor is een wegen of kanalen kaart nodig (Weg)).
 # Probleem van kruisende stroming doet zich alleen voor bij cellen die 
 # oorspronkelijk in lddtill richtingen 1, 3, 7 of 9 hadden.
 # Het zelfde kan zich voordoen langs p-grenzen (headlands). 
 # Bij deze correcties worden de p-grenzen als channels beschouwd. 

#Eerst locties zoeken waar kruising plaatsvindt:
 # Signalering van het probleem.
 risk = boolean(if(LddTill eq 1 or LddTill eq 3 or LddTill eq 7 or LddTill eq 9 then 1 else 0));
 contr1 = ldd(directional(scalar(directional(LddTill))-45));
 contr2 = ldd(directional(scalar(directional(LddTill))+45));
 lddcontr1 = ldd(downstream(contr1,LddTill));
 lddcontr1 = cover(lddcontr1,LddTill);
 lddcontr2 = ldd(downstream(contr2,LddTill));
 lddcontr2 = cover(lddcontr2,LddTill);
 error1 = boolean(if(lddcontr1 eq ldd(directional(scalar(directional(LddTill))+90)) then 1 else 0));
 error2 = boolean(if(lddcontr2 eq ldd(directional(scalar(directional(LddTill))-90)) then 1 else 0));
 error1 = risk and error1 and not error2;
 error2 = risk and error2 and not error1;

# Voor de drie situaties nagaan welke cel (error1 of error2) moet wijzigen.

# A. Channels
# Geen wijziging indien op weg of in channel, behalve als pit.
 grens = boolean(if(Lddgrens ne 5,1,0));
 grens = cover(grens,0);
 Chan = boolean(if(LddChan ne 5,1,0));
 Chan = cover(Chan,0);
 Chan = Chan or grens; # Alle 'channels' die niet mogen wijzigen..

 BuurChan1  = boolean(if(downstream(contr1,Chan) eq 1,1,0));
 BuurChan1 = boolean(if((BuurChan1 eq 1) and not Chan,1,0));
 BuurChan1 = cover(BuurChan1,0); # om geen mv te krijgen langs bekkengrens
 BuurChan2 = boolean(if(downstream(contr2,Chan) eq 1,1,0));   
 BuurChan2 = boolean(if((BuurChan2 eq 1) and not Chan,1,0));
 BuurChan2 = cover(BuurChan2,0);
 BuurChan = BuurChan1 and BuurChan2; # Beide cardinale buren zijn channel

# B. Thalwegen 
 # Thalwegen door een veld, waarbij pits zijn vervangen door top-richting.
 
 Pits = Pits;
 BuurPit1 = downstream(contr1, Pits);
 BuurPit1 = cover(BuurPit1, 0);
 BuurPit2 = downstream(contr2, Pits);
 BuurPit2 = cover(BuurPit2, 0);
 Thalw1 = error1 and BuurPit1;
 Thalw2 = error2 and BuurPit2;
 thalweg = Thalw1 or Thalw2;

# C. Stroming over veldgrens
 # Lokaties waar stroomrichting verandert t.g.v. ander landgebruik (Chan, veldgrens).
 downField = downstream(LddTill,Fields);
 downField = cover(downField,Fields);
 overgrens1 = boolean(if(Fields ne downField,1,0));
 downTillDir = downstream(LddTill,TillDir);
 downTillDir = cover(downTillDir,TillDir);
 overgrens2 = boolean(if(TillDir ne downTillDir,1,0));
 overgrens2 = cover(overgrens2, 0);
 overgrens = overgrens1 or overgrens2;

# Cellen die gewijzigd moeten worden:
 lokatie = BuurChan or thalweg or overgrens;

# Correcties:
 corr1 = boolean(if(lokatie and error1 then 1 else 0));
 corr2 = boolean(if(lokatie and error2 then 1 else 0));
 LddTemp = ldd(if(corr1 then ldd(directional(scalar(directional(LddTill))+45)) else LddTill));
 LddTemp = ldd(if(corr2 then ldd(directional(scalar(directional(LddTemp))-45)) else LddTemp));
 LddTill = (if(not Chan then LddTemp else LddTill));
# report temp6 = LddTill;


# Het is nu nog mogelijk dat er kruising overblijven (gebeurt zelden..)
# bijv. bij stroming van veld1 naar veld1 over veld2 naar veld2
# (bij small geploegd veld binnen een veld)
# Het is moeilijk uit te maken welke str richting prioriteit moet krijgen
# daarom worden beiden errors gewijzigd. 

# Op nieuw kijken of er nog kruisen zijn en corrigeren:
 risk = boolean(if(LddTill eq 1 or LddTill eq 3 or LddTill eq 7 or LddTill eq 9 then 1 else 0));
 contr1 = ldd(directional(scalar(directional(LddTill))-45));
 contr2 = ldd(directional(scalar(directional(LddTill))+45));
 lddcontr1 = ldd(downstream(contr1,LddTill));
 lddcontr1 = cover(lddcontr1,LddTill);
 lddcontr2 = ldd(downstream(contr2,LddTill));
 lddcontr2 = cover(lddcontr2,LddTill);
 error1 = boolean(if(lddcontr1 eq ldd(directional(scalar(directional(LddTill))+90)) then 1 else 0));
 error2 = boolean(if(lddcontr2 eq ldd(directional(scalar(directional(LddTill))-90)) then 1 else 0));
 error1 = risk and error1 and not error2;
 error2 = risk and error2 and not error1;
 LddTemp = ldd(if(error1 then ldd(directional(scalar(directional(LddTill))+45)) else LddTill));
 LddTemp = ldd(if(error2 then ldd(directional(scalar(directional(LddTemp))-45)) else LddTemp));
 LddTill = (if(not Chan then LddTemp else LddTill));


# FIND PITS AND CIRCULAR FLOW.
 report LddTill = lddrepair(LddTill);


# SLOPE CALCULATION (2)

 Dif = boolean(if(LddTill ne LddTmp, 1, 0));
 Dir = directional(LddTill);
 SlopeDir = scalar((dz_dx)*sin(Dir)+(dz_dy)*cos(Dir));
 SlopeTill = scalar(if(Dif, SlopeDir, SlopeTill));
 report SlopeTill = if(SlopeTill lt 0.0010, 0.0010, SlopeTill); # voor Lisem

 report FlowDir = if(Dif, Dir, FlowDir);
