#################################################################################
# Model to combine the topogarphic and the tillage-controlled runoff patterns.	#
# Hereto, the flow directions predicted by the logistic regression equation 	#
# described by Takken et al., 2001b is used (ea. the output of Logit.mod).	#
#										#
# Ingrid Takken, 8 February 1999						#
#################################################################################


binding

# INPUT
  Dem = dem.map;       	      # Dem
  Chan = chan.map;            # Boolean map with channels
  LddTill = LddCor.map;	      # Corrected tillage-controlled ldd map
  SlopeTill = slopecor.map;   # Slope map required for the calculation of SlopeRes
  TopTill = toportil.map;     # Boolean map with flow directions: 0 = topographic, 1 = tillage

# OUTPUT
  LddRes = lddres.map;        # Resulting Ldd map 
  SlopeRes = sloperes.map;    # Slope in direction of flow


initial

  Chan = boolean(Chan);
  dummy1 = boolean(cover(1, Dem));
  dummy0 = boolean(cover(0, Dem));
  dx = celllength();
  dy = celllength();


# REMOVE PITS FROM DEM:

  Dem = lddcreatedem(Dem,1e31,1e31,1e31,1e31);
  LddTop = lddcreate(Dem,1e31,1e31,1e31,1e31);
  SlopeTop = slope(Dem);


# For channels used also LDDTILL:
report TopTill = TopTill or Chan;


# COMBINE LDDTOP AND LDDTILL.

  LddRes = if(TopTill eq 1, LddTill, LddTop);
  SlopeRes = if(TopTill eq 1, SlopeTill, SlopeTop);
  LddTmp = LddRes; # Later nodig voor Slope calculation. 


# CORRECTION FOR CROSSING FLOW LINES.

# Crossing flow lines may come into existence due to the combination of the ldd-maps.
 
 # Find locations with crossing flow lines:
 risk = boolean(if(LddRes eq 1 or LddRes eq 3 or LddRes eq 7 or LddRes eq 9 then 1 else 0));
 contr1 = ldd(directional(scalar(directional(LddRes))-45));
 contr2 = ldd(directional(scalar(directional(LddRes))+45));
 lddcontr1 = ldd(downstream(contr1,LddRes));
 lddcontr1 = cover(lddcontr1,LddRes);
 lddcontr2 = ldd(downstream(contr2,LddRes));
 lddcontr2 = cover(lddcontr2,LddRes);
 error1 = boolean(if(lddcontr1 eq ldd(directional(scalar(directional(LddRes))+90)) then 1 else 0));
 error2 = boolean(if(lddcontr2 eq ldd(directional(scalar(directional(LddRes))-90)) then 1 else 0));
 error1 = risk and error1 and not error2;
 error2 = risk and error2 and not error1;

 # There are two possible reasons for crossing flow lines:
 # 1. Flow from TopLdd to TillLdd or the other way around.
 # 2. Flow from TillLdd to TillLdd crossing flow from TopLdd to TopLdd.
 
 # First correct 1:
 # Localisation:
 Overgang = boolean(if(downstream(LddRes,TopTill) ne TopTill, 1, 0));
 Overgang = cover(Overgang,0);

 # Corrections:
 corr1 = boolean(if(Overgang and error1 then 1 else 0));
 corr2 = boolean(if(Overgang and error2 then 1 else 0));
 LddRes = ldd(if(corr1 then ldd(directional(scalar(directional(LddRes))+45)) else LddRes));
 LddRes = ldd(if(corr2 then ldd(directional(scalar(directional(LddRes))-45)) else LddRes));

 # Then localise 2 (= remaining crossing flow lines):
 risk = boolean(if(LddRes eq 1 or LddRes eq 3 or LddRes eq 7 or LddRes eq 9 then 1 else 0));
 contr1 = ldd(directional(scalar(directional(LddRes))-45));
 contr2 = ldd(directional(scalar(directional(LddRes))+45));
 lddcontr1 = ldd(downstream(contr1,LddRes));
 lddcontr1 = cover(lddcontr1,LddRes);
 lddcontr2 = ldd(downstream(contr2,LddRes));
 lddcontr2 = cover(lddcontr2,LddRes);
 error1 = boolean(if(lddcontr1 eq ldd(directional(scalar(directional(LddRes))+90)) then 1 else 0));
 error2 = boolean(if(lddcontr2 eq ldd(directional(scalar(directional(LddRes))-90)) then 1 else 0));
 error1 = risk and error1 and not error2;
 error2 = risk and error2 and not error1;

 # Correction made on topographic flow line:
 corr1 = boolean(if(not TopTill and error1 then 1 else 0));
 corr2 = boolean(if(not TopTill and error2 then 1 else 0));
 LddRes = ldd(if(corr1 then ldd(directional(scalar(directional(LddRes))+45)) else LddRes));
 LddRes = ldd(if(corr2 then ldd(directional(scalar(directional(LddRes))-45)) else LddRes));


# FIND PITS AND CIRCULAR FLOW.
 report LddRes = lddrepair(LddRes);


# FOR THE CALCULATION OF SLOPE.

    Ldd1 = spatial(ldd(1));
    Ldd2 = spatial(ldd(2));
    Ldd3 = spatial(ldd(3));
    Ldd4 = spatial(ldd(4));
    Ldd6 = spatial(ldd(6));
    Ldd7 = spatial(ldd(7));
    Ldd8 = spatial(ldd(8));
    Ldd9 = spatial(ldd(9));
    Dem1 = downstream(Ldd1, Dem);
    Dem2 = downstream(Ldd2, Dem);
    Dem3 = downstream(Ldd3, Dem);
    Dem4 = downstream(Ldd4, Dem);
    Dem6 = downstream(Ldd6, Dem);
    Dem7 = downstream(Ldd7, Dem);
    Dem8 = downstream(Ldd8, Dem);
    Dem9 = downstream(Ldd9, Dem);

  # dz/dx and dz/dy defined by the method of Horn (1981).
    dz_dx = ((Dem1+2*Dem4+Dem7)/4 - (Dem3+2*Dem6+Dem9)/4) / (2*dx);
    dz_dy = ((Dem1+2*Dem2+Dem3)/4 - (Dem7+2*Dem8+Dem9)/4) / (2*dx);



# SLOPE CALCULATION.

 Dif = boolean(if(LddRes ne LddTmp, 1, 0));
 Dir = directional(LddRes);
 SlopeDir = scalar((dz_dx)*sin(Dir)+(dz_dy)*cos(Dir));
 SlopeRes = scalar(if(Dif, SlopeDir, SlopeRes));
report SlopeRes = if(SlopeRes lt 0.0010, 0.0010, SlopeRes); #voor Lisem

