##############################################################################
# Model to correct crossing flowlines.                                       #
# Model needs to be applied after PitRem.mod / CirkRem.mod                   #
# All cells that cause crossing flow and that were not changed in the        #
# PitRem or CircRem programs are changed (direction turned 45 degrees).      #
#                                                                            #
# Also the slope in the direction of flow, for the final map is calculated.  #
#                                                                            #
# Ingrid Takken, 25 November 1999                                            #
#																				# 
# - Adjusted for new pcraster version (4.3.3) (2022-11) Meindert Commelin		#
#################################################################################


binding

# INPUT
   LddTill = lddtill.map;     # Output of LddTill.mod (required to define which cells,
                              # have been changed by the PitRem and CrikRem models.
   LddKruis = cirkrem.map;    # Ldd that needs to be corrected (CirkRem.map)
   Dem = dem.map;             # 
   SlopeTill = SlopeTil.map;  # Output of LddTill.mod
   FlowDir = flowdir.map;

# OUTPUT
   LddNew = LddCor.map;       # The final corrected LddTill.map
   SlopeCor = slopecor.map;   # The slope in direction of flow for the corrected map
   FlowDirCor = flowdcor.map;


initial

 # Calculate a Changed-map, for cells that have been changed already:
 Changed = boolean(if(LddTill ne LddKruis, 1, 0)); 

 # Find the locations where crossing flow occurs:
 risk = boolean(if(LddKruis eq 1 or LddKruis eq 3 or LddKruis eq 7 or LddKruis eq 9 then 1 else 0));
 contr1 = ldd(directional(scalar(directional(LddKruis))-45));
 contr2 = ldd(directional(scalar(directional(LddKruis))+45));
 lddcontr1 = ldd(downstream(contr1,LddKruis));
 lddcontr1 = cover(lddcontr1,LddKruis);
 lddcontr2 = ldd(downstream(contr2,LddKruis));
 lddcontr2 = cover(lddcontr2,LddKruis);
 error1 = boolean(if(lddcontr1 eq ldd(directional(scalar(directional(LddKruis))+90)) then 1 else 0));
 error2 = boolean(if(lddcontr2 eq ldd(directional(scalar(directional(LddKruis))-90)) then 1 else 0));
 error1 = risk and error1 and not error2;
 error2 = risk and error2 and not error1;

 Kruis = boolean(if(error1 or error2,1,0));

 # Change flow directions of cells that have not been changed yet. 
 Wijzig1 = boolean(if(error1 and not Changed, 1, 0));
 Wijzig2 = boolean(if(error2 and not Changed, 1, 0));

 # CHANGE
 LddNew = ldd(if(Wijzig1 then ldd(directional(scalar(directional(LddKruis))+45)) else LddKruis));
report LddNew = ldd(if(Wijzig2 then ldd(directional(scalar(directional(LddNew))-45)) else LddNew));


# SLOPE CALCULATION.

    dx = celllength();

    Ldd1 = spatial(ldd(1));
    Ldd2 = spatial(ldd(2));
    Ldd3 = spatial(ldd(3));
    Ldd4 = spatial(ldd(4));
    Ldd6 = spatial(ldd(6));
    Ldd7 = spatial(ldd(7));
    Ldd8 = spatial(ldd(8));
    Ldd9 = spatial(ldd(9));

    Dem = lddcreatedem(Dem, 1e35, 1e35, 1e35, 1e35);
    Dem1 = downstream(Ldd1, Dem);
    Dem2 = downstream(Ldd2, Dem);
    Dem3 = downstream(Ldd3, Dem);
    Dem4 = downstream(Ldd4, Dem);
    Dem6 = downstream(Ldd6, Dem);
    Dem7 = downstream(Ldd7, Dem);
    Dem8 = downstream(Ldd8, Dem);
    Dem9 = downstream(Ldd9, Dem);

  # dz/dx en dz/dy bepalen volgens Horn (1981).
    dz_dx = ((Dem1+2*Dem4+Dem7)/4 - (Dem3+2*Dem6+Dem9)/4) / (2*dx);
    dz_dy = ((Dem1+2*Dem2+Dem3)/4 - (Dem7+2*Dem8+Dem9)/4) / (2*dx);

 Dif = boolean(if(LddKruis ne LddTill, 1, 0));
 Dir = directional(LddKruis);
 SlopeDir = scalar((dz_dx)*sin(Dir)+(dz_dy)*cos(Dir));
 SlopeCor = scalar(if(Dif, SlopeDir, SlopeTill));
 report SlopeCor = if(SlopeCor lt 0.0010, 0.0010, SlopeCor); # voor Lisem

 report FlowDirCor = if(Dif, Dir, FlowDir);
