#################################################################################
# Model to find crossing flowlines. This model just defines the locations where #
# crossing flow lines occur. The model does not correct any flowlines.		#
#										#
# Ingrid Takken, December 1999							#
#################################################################################


binding

# INPUT
  LddKruis = LddCor.map;     # Ldd input map

# OUTPUT
  Kruis = kruis.map;         # Output map with the locations of crossing flow lines


initial

 # Find locations where crossing flow lines occur.
 risk = boolean(if(LddKruis eq 1 or LddKruis eq 3 or LddKruis eq 7 or LddKruis eq 9 then 1 else 0));
 contr1 = ldd(directional(scalar(directional(LddKruis))-45));
 contr2 = ldd(directional(scalar(directional(LddKruis))+45));
 lddcontr1 = ldd(downstream(contr1,LddKruis));
 lddcontr1 = cover(lddcontr1,LddKruis);
 lddcontr2 = ldd(downstream(contr2,LddKruis));
 lddcontr2 = cover(lddcontr2,LddKruis);
 error1 = boolean(if(lddcontr1 eq ldd(directional(scalar(directional(LddKruis))+90)) then 1 else 0));
 error2 = boolean(if(lddcontr2 eq ldd(directional(scalar(directional(LddKruis))-90)) then 1 else 0));
 error1 = risk and error1 and not error2;
 error2 = risk and error2 and not error1;

 Kruis = nominal(if(error1,1,0));
report Kruis = nominal(if(error2,2,Kruis)); 
