##############################################################################
# Model to give some general information of a map:                           #
# It calculates the number of rows and columns and it gives                  #
# the minimum and maximum x and y co-ordinates.				     #
# Although the output is actually non-spatial it is given in the form of     #
# output maps.			   					     #
#                                                                            #
# Ingrid Takken, November 1999                                               #
##############################################################################


binding

 Map =  input.map;     # The map of which the info is required


initial

 clone = boolean(cover(1,Map));
 lddrow = ldd(if(clone eq 1 then 8 else 8));
 lddrow = lddrepair(lddrow);
 rows = ordinal(accuflux(lddrow, scalar(clone)));
report rows = areamaximum(rows, clone);
 lddcol = ldd(if(clone eq 1 then 6 else 6));
 lddcol = lddrepair(lddcol);
 cols = ordinal(accuflux(lddcol, scalar(clone)));
report  cols = areamaximum(cols, clone);
 xcor = xcoordinate(clone);
 ycor = ycoordinate(clone);
report  xmin = areaminimum(xcor,clone);
report  xmax = areamaximum(xcor,clone);
report  ymin = areaminimum(ycor,clone);
report  ymax = areamaximum(ycor,clone);
