#################################################################################
# Model to take out circular flow from a Ldd map. 				#
# Model should be applied after PitRem.mod. 					#
# 										#
# Ingrid Takken, 28 November 1999						#
#																				# 
# - Adjusted for new pcraster version (4.3.3) (2022-11) Meindert Commelin		#
#################################################################################


binding

#INPUT
  Dem = dem.map;
  MapEdge = mapedge.map;
  LddPit = pitrem.map;        # Ldd-map that needs to be corrected

#OUTPUT
  LddNew = cirkrem.map; 
  pitscheck = pits.map;


areamap
  Dem;


timer 
  1 8 1;   
  output = endtime; 


initial

  Dem = lddcreatedem(Dem,1e31,1e31,1e31,1e31);
  LddTop = lddcreate(Dem,1e31,1e31,1e31,1e31); # Could also be given as input map..

    Ldd1 = spatial(ldd(1));
    Ldd2 = spatial(ldd(2));
    Ldd3 = spatial(ldd(3));
    Ldd4 = spatial(ldd(4));
    Ldd6 = spatial(ldd(6));
    Ldd7 = spatial(ldd(7));
    Ldd8 = spatial(ldd(8));
    Ldd9 = spatial(ldd(9));


# For pits that are left in the ldd map after application of the PitRem-model
# the replacement of the flow direction to topographic direction did not help.
# This means that the pit is caused due to circular flow.


  Pits = pit(LddPit); # Nominal!!!
 # Pits at the edge of the map sheet are left out of consideration:
  Pits = if(MapEdge, 0, Pits);
  LddNew = if(Pits ne 0, LddTop, LddPit);
  Cirkel = scalar(Pits); # every pit has its own number!
  # Pit is replaced by topographic direction; now you can "walk" round the circle 
  # using 'upstream' starting at the former pit cell. 
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);
  Cirkel = if(upstream(LddNew,Cirkel) ne 0, upstream(LddNew,Cirkel),Cirkel);
  Cirkel = cover(Cirkel, 0);

# Search for all neighbour cells of the circle and find the lowest cell.
# The neighbour cell does not need to be lower than the circle, but it should not be higher.

  BuurCirk = if(downstream(Ldd1,Cirkel) ne 0, downstream(Ldd1,Cirkel), 0);
  BuurCirk = cover(BuurCirk,0);
  BuurCirk = if(downstream(Ldd2,Cirkel) ne 0, downstream(Ldd2,Cirkel), BuurCirk);
  BuurCirk = cover(BuurCirk,0);
  BuurCirk = if(downstream(Ldd3,Cirkel) ne 0, downstream(Ldd3,Cirkel), BuurCirk);
  BuurCirk = cover(BuurCirk,0);
  BuurCirk = if(downstream(Ldd4,Cirkel) ne 0, downstream(Ldd4,Cirkel), BuurCirk);
  BuurCirk = cover(BuurCirk,0);
  BuurCirk = if(downstream(Ldd6,Cirkel) ne 0, downstream(Ldd6,Cirkel), BuurCirk);
  BuurCirk = cover(BuurCirk,0);
  BuurCirk = if(downstream(Ldd7,Cirkel) ne 0, downstream(Ldd7,Cirkel), BuurCirk);
  BuurCirk = cover(BuurCirk,0);
  BuurCirk = if(downstream(Ldd8,Cirkel) ne 0, downstream(Ldd8,Cirkel), BuurCirk);
  BuurCirk = cover(BuurCirk,0);
  BuurCirk = if(downstream(Ldd9,Cirkel) ne 0, downstream(Ldd9,Cirkel), BuurCirk);
  BuurCirk = cover(BuurCirk,0);
  # Only the neighbour-cells, not the circle cells..
  BuurCirk = if(Cirkel ne 0, 0, BuurCirk);

## Or maybe replace this by something like??:
# Spread = spread(boolean(Cirkel),0,1);
# BuurenCirkel = boolean(if(Spread lt 8, 1, 0));
# BuurCirknr = areamaximum(Circel,BuurenCirkel);
# BuurCirk = if(Cirkel ne 0, 0, BuurCirknr);

  LaagDem = areaminimum(Dem,nominal(BuurCirk)); # Gives the lowest elevation on the circle

 # Now, you have the neighbour cells and the elevation of the lowest neighbour.
 # Search for the location of the lowest neighbour:

  LaagBuur = boolean(if((BuurCirk ne 0) and (Dem eq LaagDem), 1, 0));

 # For all circle cells that border on the lowest neighbour cell replace
 # LddPit with LddTop.

  ChangeLdd = boolean(if(Cirkel ne 0 and downstream(Ldd1,LaagBuur) ne 0, 1, 0));
  ChangeLdd = cover(ChangeLdd,0);
  ChangeLdd = boolean(if(Cirkel ne 0 and downstream(Ldd2,LaagBuur) ne 0, 1, ChangeLdd));
  ChangeLdd = cover(ChangeLdd,0);
  ChangeLdd = boolean(if(Cirkel ne 0 and downstream(Ldd3,LaagBuur) ne 0, 1, ChangeLdd));
  ChangeLdd = cover(ChangeLdd,0);
  ChangeLdd = boolean(if(Cirkel ne 0 and downstream(Ldd4,LaagBuur) ne 0, 1, ChangeLdd));
  ChangeLdd = cover(ChangeLdd,0);
  ChangeLdd = boolean(if(Cirkel ne 0 and downstream(Ldd6,LaagBuur) ne 0, 1, ChangeLdd));
  ChangeLdd = cover(ChangeLdd,0);
  ChangeLdd = boolean(if(Cirkel ne 0 and downstream(Ldd7,LaagBuur) ne 0, 1, ChangeLdd));
  ChangeLdd = cover(ChangeLdd,0);
  ChangeLdd = boolean(if(Cirkel ne 0 and downstream(Ldd8,LaagBuur) ne 0, 1, ChangeLdd));
  ChangeLdd = cover(ChangeLdd,0);
  ChangeLdd = boolean(if(Cirkel ne 0 and downstream(Ldd9,LaagBuur) ne 0, 1, ChangeLdd));
  ChangeLdd = cover(ChangeLdd,0);

  LddNew = if(ChangeLdd, LddTop, LddNew);
  LddNew = lddrepair(LddNew);
#report cirkr1a = LddNew;


#######################################################################   
# Now the PitRem.mod is repeated...
#######################################################################

dynamic

  LddPit = LddNew;

  Pitsb = boolean(pit(LddPit));
  Pitsb = if(MapEdge, 0, Pitsb); 
  LddNew = if(Pitsb, LddTop, LddPit);
   # Identify cells that flow towards former pits:
  DownPit = boolean(if(downstream(LddNew,Pitsb) eq 1,1,0));
  DownPit = cover(DownPit, 0);
   # Direction of these downstream cells:
  DownDir = scalar(directional(downstream(LddNew,LddNew)));
   # Flow direction in (former pit-cel):
  FlowDir = scalar(directional(LddNew));
  Toe = boolean(if(abs(DownDir-FlowDir) eq 180, 1,0));
  Toe = cover(Toe, 0);
  LddNew = if(DownPit and Toe, 5, LddNew);
report LddNew = lddrepair(LddNew);
report pitscheck = if(MapEdge, 0, pit(LddNew));