#########################################################################
# Model to calculate:							#
#   - the catchment area						#
#   - the upstream (or 'contributing') area				#
#   - the unit contributing area (according to Desmet and Govers, 1996) #
#									#
# Ingrid Takken, December 2000						#
#########################################################################


binding

# INPUT
 Ldd = LddRes.map;		# The runoff pattern
 Outlet = outlet.map;		# Boolean map with the outlet
 FlowDir = flowdcor.map;    	# Directional map with flow directions, 
				# i.e. the aspect map for a topographic runoff pattern
 Slope = slopecor.map;		# Map with the slope in flow direction

# OUTPUT
 Catch = catch.map;
 ContArea = contarea.map;
 UnitCA = unitca.map;


initial

# CALCULATION OF THE CATCHMENT AREA
report Catch = catchment(Ldd,Outlet);


# CALCULATION OF THE CONTRIBUTING AREA
 AreaCell = celllength()*celllength();
 ContArea = accuflux(Ldd,AreaCell);
report ContArea = if(Catch, ContArea);


# CALCULATION OF THE UNIT CONTRIBUTING AREA
 Fract = 1 / max(abs(sin(FlowDir)),abs(cos(FlowDir)));
       # Max can get a value between 0.707 and 1
       # Fract thus gets values between 1 and 1.4
 ContourLenght = Fract*celllength();
report UnitCA = ContArea / ContourLenght;

