% ODE Temperature Solve
function test_ode_Heat()
clear all;
close all;
clc;
Nx = 50;
Ny = 50;

[x,Dx] = chebdif(Nx,1);
[y,Dy] = chebdif(Ny,1);
Q_channel = 50e-3; %L/min
Q_channel = Q_channel/1000/60; % m3/s
rho = 998; % kg/m^3
m_channel = Q_channel*rho;
m_hot_rate = m_channel;
m_cold_rate = m_channel;
u_channel = 0.8/100; %m/s
X = 10e-2; % length in x-direction
Y = 10e-2; % length in y-direction
x = (x+1)*X/(2);
y = (y+1)*Y/(2);

%Dx = Dx*(2)/X;
%Dy = Dy*(2)/Y;
Cp = 4184; % J/kg/K
tau_hot = X/u_channel;
tau_cold = Y/u_channel;


mCp = m_hot_rate*tau_hot*Cp;
mCpXY = mCp*X*Y;
% # energy balance

A = 10*10*(1/100)^2;
kA = 2.35; % estimate heat transfer coefficient * exchange area
Twall = 22;
hA = 0.63;
%hA = 0;
%x = linspace(0,X,100);
%y = linspace(0,Y,100);



Tc_in = 20;
Th_in = 40;

T_C = Tc_in*ones(length(x),length(y));
T_H = Tc_in*ones(length(x),length(y));

T_C(1,:) = Tc_in;
T_H(:,1) = Th_in;

Tguess = [[T_H];[T_C]];

Tguess = reshape(Tguess,2*Nx*Ny,1);

T = fsolve(@myHeatSolve,Tguess,[],Dx,Dy,kA,hA,mCp,X,Y,Twall,Tc_in,Th_in,Nx,Ny); 

T_H = T(1:Nx*Ny);
T_C = T(Nx*Ny+1:2*Nx*Ny);

T_H = reshape(T_H,Nx,Ny);
T_C = reshape(T_C,Nx,Ny);

[Xgrid Ygrid] = meshgrid(x,y);

pcolor(Xgrid',Ygrid',T_H);
colorbar
shading interp

figure (2)

pcolor(Xgrid',Ygrid',T_C);
colorbar
shading interp

TC_avg_out = mean(T_C(1,:))
TH_avg_out = mean(T_H(:,1))

deltaT = T_H-T_C;

mean_deltaT = mean(mean(deltaT))

function F = myHeatSolve(Tval,Dx,Dy,kA,hA,mCp,X,Y,Twall,Tc_in,Th_in,Nx,Ny)

T_H = Tval(1:Nx*Ny);
T_C = Tval(Nx*Ny+1:2*Nx*Ny);

T_H = reshape(T_H,Nx,Ny);
T_C = reshape(T_C,Nx,Ny);


LHS_Cold = Dx*T_C;
RHS_Cold = 2*kA/(mCp*Y)*(T_H-T_C)+2*hA/(mCp*Y)*(Twall-T_H);
LHS_Hot = (Dy*T_H')';
RHS_Hot = -2*kA/(mCp*X)*(T_H-T_C)+2*hA/(mCp*X)*(Twall-T_H);

F_Hot = LHS_Hot-RHS_Hot;
F_Cold = LHS_Cold-RHS_Cold;

F_Cold(Nx,:) = T_C(Nx,:)-Tc_in;
F_Hot(:,Ny) = T_H(:,Ny)-Th_in;

F = [[F_Hot];[F_Cold]];

F = reshape(F,2*Nx*Ny,1);








