close all
clear all
clc

%% Analysis of RED experiments (IV etc).
% Anne Benneker, August 2016

%% Reading data
filename = ['RED_results.xlsx'];

Isotherm_high = xlsread(filename,4);
RivHotSeaCold = xlsread(filename,2);
RivColdSeaHot = xlsread(filename,3);
Isotherm_low = xlsread(filename,1);

%% Gross Power Density

for ii = 1:3
IsoHigh_CD(:,ii) = Isotherm_high(:,(ii-1)*14+4);
IsoLow_CD(:,ii) = Isotherm_low(:,(ii-1)*14+4);
RivHot_CD(:,ii) = RivHotSeaCold(:,(ii-1)*14+4);
RivCold_CD(:,ii) = RivColdSeaHot(:,(ii-1)*14+4);

IsoHigh_GPD(:,ii) = Isotherm_high(:,(ii-1)*14+12);
IsoLow_GPD(:,ii) = Isotherm_low(:,(ii-1)*14+12);
RivHot_GPD(:,ii) = RivHotSeaCold(:,(ii-1)*14+12);
RivCold_GPD(:,ii) = RivColdSeaHot(:,(ii-1)*14+12);
end

IsoHigh_CD_ave = mean(IsoHigh_CD,2);
IsoHigh_CD_std = nanstd(IsoHigh_CD,0,2);
IsoHigh_GPD_ave = mean(IsoHigh_GPD,2);
IsoHigh_GPD_std = nanstd(IsoHigh_GPD,0,2);

IsoLow_CD_ave = mean(IsoLow_CD,2);
IsoLow_CD_std = nanstd(IsoLow_CD,0,2);
IsoLow_GPD_ave = mean(IsoLow_GPD,2);
IsoLow_GPD_std = nanstd(IsoLow_GPD,0,2);

RivHot_CD_ave = mean(RivHot_CD,2);
RivHot_CD_std = nanstd(RivHot_CD,0,2);
RivHot_GPD_ave = mean(RivHot_GPD,2);
RivHot_GPD_std = nanstd(RivHot_GPD,0,2);

RivCold_CD_ave = mean(RivCold_CD,2);
RivCold_CD_std = nanstd(RivCold_CD,0,2);
RivCold_GPD_ave = mean(RivCold_GPD,2);
RivCold_GPD_std = nanstd(RivCold_GPD,0,2);

% Plots
colormap lines
map = colormap;
symbols = {'*','x','.','o','s'};

nn = 1;
figure(nn)
hold on
H(1) = shadedErrorBar(IsoLow_CD_ave(:,1),IsoLow_GPD_ave,IsoLow_GPD_std, {'color',map(1,:),'marker',symbols{3},'LineStyle','-'})
H(2) = shadedErrorBar(RivCold_CD_ave(:,1),RivCold_GPD_ave,RivCold_GPD_std, {'color',map(2,:),'marker',symbols{3},'LineStyle','-'})
H(3) = shadedErrorBar(RivHot_CD_ave(:,1),RivHot_GPD_ave,RivHot_GPD_std, {'color',map(3,:),'marker',symbols{3},'LineStyle','-'})
H(4) = shadedErrorBar(IsoHigh_CD_ave(:,1),IsoHigh_GPD_ave,IsoHigh_GPD_std, {'color',map(4,:),'marker',symbols{3},'LineStyle','-'})
legend([H(1).mainLine,H(2).mainLine,H(3).mainLine,H(4).mainLine],['T_1 = T_2 = 20 \degree C'],['T_1 = 20 \degree C, T_2 = 40 \degree C'],['T_1 = 40 \degree C, T_2 = 20 \degree C'],['T_1 = T_2 = 40 \degree C'], 'Location', 'South')
legend boxoff
box on
XaxisLabel = xlabel('Current density (A/m^2)');
YaxisLabel = ylabel('Gross Power Density (W/m^2)');
matlab2tikz('RED_GPD.tex')

nn = nn+1;

%% Net power density