close all
clear all
clc

%% Analysis of RED experiments (IV etc).
% Anne Benneker, August 2016

%% Reading data
filename = ['RED_results.xlsx'];

Isotherm_high = xlsread(filename,4);
RivHotSeaCold = xlsread(filename,2);
RivColdSeaHot = xlsread(filename,3);
Isotherm_low = xlsread(filename,1);

%% Gross Power Density

for ii = 1:3
IsoHigh_CD(:,ii) = Isotherm_high(:,(ii-1)*14+4);
IsoLow_CD(:,ii) = Isotherm_low(:,(ii-1)*14+4);
RivHot_CD(:,ii) = RivHotSeaCold(:,(ii-1)*14+4);
RivCold_CD(:,ii) = RivColdSeaHot(:,(ii-1)*14+4);

IsoHigh_GPD(:,ii) = Isotherm_high(:,(ii-1)*14+11);
IsoLow_GPD(:,ii) = Isotherm_low(:,(ii-1)*14+11);
RivHot_GPD(:,ii) = RivHotSeaCold(:,(ii-1)*14+11);
RivCold_GPD(:,ii) = RivColdSeaHot(:,(ii-1)*14+11);

IsoHigh_I(:,ii) = Isotherm_high(:,(ii-1)*14+3);
IsoLow_I(:,ii) = Isotherm_low(:,(ii-1)*14+3);
RivHot_I(:,ii) = RivHotSeaCold(:,(ii-1)*14+3);
RivCold_I(:,ii) = RivColdSeaHot(:,(ii-1)*14+3);

IsoHigh_V(:,ii) = Isotherm_high(:,(ii-1)*14+2);
IsoLow_V(:,ii) = Isotherm_low(:,(ii-1)*14+2);
RivHot_V(:,ii) = RivHotSeaCold(:,(ii-1)*14+2);
RivCold_V(:,ii) = RivColdSeaHot(:,(ii-1)*14+2);

IsoHigh_NPD(:,ii) = Isotherm_high(:,(ii-1)*14+14);
IsoLow_NPD(:,ii) = Isotherm_low(:,(ii-1)*14+14);
RivHot_NPD(:,ii) = RivHotSeaCold(:,(ii-1)*14+14);
RivCold_NPD(:,ii) = RivColdSeaHot(:,(ii-1)*14+14);
end

IsoHigh_CD_ave = mean(IsoHigh_CD,2);
IsoHigh_CD_std = nanstd(IsoHigh_CD,0,2);
IsoHigh_GPD_ave = mean(IsoHigh_GPD,2);
IsoHigh_GPD_std = nanstd(IsoHigh_GPD,0,2);
IsoHigh_NPD_ave = mean(IsoHigh_NPD,2);
IsoHigh_NPD_std = nanstd(IsoHigh_NPD,0,2);
IsoHigh_I_ave = mean(IsoHigh_I,2);
IsoHigh_I_std = nanstd(IsoHigh_I,0,2);
IsoHigh_V_ave = mean(IsoHigh_V,2);
IsoHigh_V_std = nanstd(IsoHigh_V,0,2);
[IsoHigh_GPD_max, IsoHigh_index] = max(IsoHigh_GPD_ave);
IsoHigh_NPD_max = max(IsoHigh_NPD_ave);

IsoLow_CD_ave = mean(IsoLow_CD,2);
IsoLow_CD_std = nanstd(IsoLow_CD,0,2);
IsoLow_GPD_ave = mean(IsoLow_GPD,2);
IsoLow_GPD_std = nanstd(IsoLow_GPD,0,2);
IsoLow_NPD_ave = mean(IsoLow_NPD,2);
IsoLow_NPD_std = nanstd(IsoLow_NPD,0,2);
IsoLow_I_ave = mean(IsoLow_I,2);
IsoLow_I_std = nanstd(IsoLow_I,0,2);
IsoLow_V_ave = mean(IsoLow_V,2);
IsoLow_V_std = nanstd(IsoLow_V,0,2);
[IsoLow_GPD_max, IsoLow_index] = max(IsoLow_GPD_ave);
IsoLow_NPD_max = max(IsoLow_NPD_ave);

RivHot_CD_ave = mean(RivHot_CD,2);
RivHot_CD_std = nanstd(RivHot_CD,0,2);
RivHot_GPD_ave = mean(RivHot_GPD,2);
RivHot_GPD_std = nanstd(RivHot_GPD,0,2);
RivHot_NPD_ave = mean(RivHot_NPD,2);
RivHot_NPD_std = nanstd(RivHot_NPD,0,2);
RivHot_I_ave = mean(RivHot_I,2);
RivHot_I_std = nanstd(RivHot_I,0,2);
RivHot_V_ave = mean(RivHot_V,2);
RivHot_V_std = nanstd(RivHot_V,0,2);
[RivHot_GPD_max, RivHot_index] = max(RivHot_GPD_ave);
RivHot_NPD_max = max(RivHot_NPD_ave);

RivCold_CD_ave = mean(RivCold_CD,2);
RivCold_CD_std = nanstd(RivCold_CD,0,2);
RivCold_GPD_ave = mean(RivCold_GPD,2);
RivCold_GPD_std = nanstd(RivCold_GPD,0,2);
RivCold_NPD_ave = mean(RivCold_NPD,2);
RivCold_NPD_std = nanstd(RivCold_NPD,0,2);
RivCold_I_ave = mean(RivCold_I,2);
RivCold_I_std = nanstd(RivCold_I,0,2);
RivCold_V_ave = mean(RivCold_V,2);
RivCold_V_std = nanstd(RivCold_V,0,2);
[RivCold_GPD_max,RivCold_index] = max(RivCold_GPD_ave);
RivCold_NPD_max = max(RivCold_NPD_ave);

%% Propagation of Errors for power 
IsoHigh_PD_relError = sqrt((IsoHigh_I_std./IsoHigh_I_ave).^2 + (IsoHigh_V_std./IsoHigh_V_ave).^2);
IsoLow_PD_relError = sqrt((IsoLow_I_std./IsoLow_I_ave).^2 + (IsoLow_V_std./IsoLow_V_ave).^2);
RivHot_PD_relError = sqrt((RivHot_I_std./RivHot_I_ave).^2 + (RivHot_V_std./RivHot_V_ave).^2);
RivCold_PD_relError = sqrt((RivCold_I_std./RivCold_I_ave).^2 + (RivCold_V_std./RivCold_V_ave).^2);

IsoHigh_PD_Error = IsoHigh_PD_relError.*IsoHigh_GPD_ave;
IsoLow_PD_Error = IsoLow_PD_relError.*IsoLow_GPD_ave;
RivHot_PD_Error = RivHot_PD_relError.*RivHot_GPD_ave;
RivCold_PD_Error = RivCold_PD_relError.*RivCold_GPD_ave;

IsoHigh_NPD_relError = sqrt(IsoHigh_PD_relError.^2+0.01^2+0.01^2);
IsoLow_NPD_relError = sqrt(IsoLow_PD_relError.^2+0.01^2+0.01^2);
RivHot_NPD_relError = sqrt(RivHot_PD_relError.^2+0.01^2+0.01^2);
RivCold_NPD_relError = sqrt(RivCold_PD_relError.^2+0.01^2+0.01^2);

IsoHigh_NPD_Error = IsoHigh_NPD_relError.*IsoHigh_NPD_ave;
IsoLow_NPD_Error = IsoLow_NPD_relError.*IsoLow_NPD_ave;
RivHot_NPD_Error = RivHot_NPD_relError.*RivHot_NPD_ave;
RivCold_NPD_Error = RivCold_NPD_relError.*RivCold_NPD_ave;

IsoHigh_Error_GPD_max = IsoHigh_PD_Error(IsoHigh_index);
IsoLow_Error_GPD_max = IsoLow_PD_Error(IsoLow_index);
RivHot_Error_GPD_max = RivHot_PD_Error(RivHot_index);
RivCold_Error_GPD_max = RivCold_PD_Error(RivCold_index);

IsoHigh_Error_NPD_max = IsoHigh_NPD_Error(IsoHigh_index);
IsoLow_Error_NPD_max = IsoLow_NPD_Error(IsoLow_index);
RivHot_Error_NPD_max = RivHot_NPD_Error(RivHot_index);
RivCold_Error_NPD_max = RivCold_NPD_Error(RivCold_index);

%%
close all
% Plots
% colormap lines
% map = colormap;
map = [242 95 92; 255 224 102;80 81 79; 112 193 179; 36 123 160]./255; 
symbols = {'*','x','.','o','s'};

nn = 1;
figure(nn)
hold on
H(1) = shadedErrorBar(IsoLow_CD_ave(3:19,1),IsoLow_GPD_ave(3:19),IsoLow_PD_Error(3:19), {'color',map(4,:),'marker',symbols{3},'LineStyle','-'},1)
H(2) = shadedErrorBar(RivCold_CD_ave(1:17,1),RivCold_GPD_ave(1:17),RivCold_PD_Error(1:17), {'color',map(2,:),'marker',symbols{3},'LineStyle','-'},1)
H(3) = shadedErrorBar(RivHot_CD_ave(3:19,1),RivHot_GPD_ave(3:19),RivHot_PD_Error(3:19), {'color',map(3,:),'marker',symbols{3},'LineStyle','-'},1)
H(4) = shadedErrorBar(IsoHigh_CD_ave(1:17,1),IsoHigh_GPD_ave(1:17),IsoHigh_PD_Error(1:17), {'color',map(1,:),'marker',symbols{3},'LineStyle','-'},1)
legend([H(1).mainLine,H(2).mainLine,H(3).mainLine,H(4).mainLine],['T_D = T_C = 20 \degree C'],['T_D = 20 \degree C, T_C = 40 \degree C'],['T_D = 40 \degree C, T_C = 20 \degree C'],['T_D = T_C = 40 \degree C'], 'Location', 'South')
legend boxoff
box on
XaxisLabel = xlabel('Current density (A/m^2)');
YaxisLabel = ylabel('Gross Power Density (W/m^2)');
matlab2tikz('RED_GPD.tex')
print('-dpng','I:\My Documents\Experiments\Temperature gradients\Plaatjes png\RED_GPD')

nn = nn+1;

figure(nn)
hold on
bar([IsoLow_GPD_max IsoLow_NPD_max; RivCold_GPD_max RivCold_NPD_max; RivHot_GPD_max RivHot_NPD_max; IsoHigh_GPD_max IsoHigh_NPD_max]);
legend('Gross Power Density','Net Power Density', 'Location','NorthWest')
legend boxoff
YaxisLabel = ylabel('Power density (W/m^2)');
ax = gca;
ax.XTick = [1 2 3 4];
ax.XTickLabel = ({'Cold Isotherm','Hot Concentrate','Hot Diluate', 'Hot Isotherm'});
%error bars for GPD
eb1 = errorbar(IsoLow_GPD_max, IsoLow_Error_GPD_max,'.k')
set(eb1(1), 'xdata', .85);
eb2 = errorbar(RivCold_GPD_max, RivCold_Error_GPD_max,'.k')
set(eb2(1), 'xdata', 1.85);
eb3 = errorbar(RivHot_GPD_max,RivHot_Error_GPD_max,'.k')
set(eb3(1), 'xdata', 2.85);
eb4 = errorbar(IsoHigh_GPD_max,IsoHigh_Error_GPD_max,'.k')
set(eb4(1), 'xdata', 3.85);
% error bars for NPD
eb1 = errorbar(IsoLow_NPD_max, IsoLow_Error_NPD_max,'.k')
set(eb1(1), 'xdata', 1.15);
eb2 = errorbar(RivCold_NPD_max, RivCold_Error_NPD_max,'.k')
set(eb2(1), 'xdata', 2.15);
eb3 = errorbar(RivHot_NPD_max,RivHot_Error_NPD_max,'.k')
set(eb3(1), 'xdata', 3.15);
eb4 = errorbar(IsoHigh_NPD_max,IsoHigh_Error_NPD_max,'.k')
set(eb4(1), 'xdata', 4.15);

matlab2tikz('max_GPD_NPD.tex')
print('-dpng','H:\My Documents\Experiments\Temperature gradients\Plaatjes png\max_GPD_NPD')


% errorbar([IsoLow_GPD_max IsoLow_NPD_max; RivCold_GPD_max RivCold_NPD_max; RivHot_GPD_max RivHot_NPD_max; IsoHigh_GPD_max IsoHigh_NPD_max],[IsoLow_Error_GPD_max IsoLow_Error_GPD_max;RivCold_Error_GPD_max RivCold_Error_GPD_max;RivHot_Error_GPD_max RivHot_Error_GPD_max;IsoHigh_Error_GPD_max IsoHigh_Error_GPD_max]);
nn = nn+1;

% figure(nn)
% 
% % plot(IsoLow_CD_ave(:,1),IsoLow_GPD_ave)
% errorbar(IsoLow_CD_ave(3:36),IsoLow_GPD_ave(3:36),IsoLow_PD_Error(3:36))
% % errorbar(RivCold_CD_ave(:,1),RivCold_GPD_ave,RivCold_PD_Error, {'color',map(2,:),'marker',symbols{3},'LineStyle','-'})
% % errorbar(RivHot_CD_ave(:,1),RivHot_GPD_ave,RivHot_PD_Error, {'color',map(3,:),'marker',symbols{3},'LineStyle','-'})
% % errorbar(IsoHigh_CD_ave(:,1),IsoHigh_GPD_ave,IsoHigh_PD_Error, {'color',map(4,:),'marker',symbols{3},'LineStyle','-'})


% figure(nn)
% hold on
% J(1) = shadedErrorBar(IsoLow_I_ave(:,1),IsoLow_V_ave,IsoLow_V_std, {'color',map(1,:),'marker',symbols{3},'LineStyle','-'})
% J(2) = shadedErrorBar(RivCold_I_ave(:,1),RivCold_V_ave,RivCold_V_std, {'color',map(2,:),'marker',symbols{3},'LineStyle','-'})
% J(3) = shadedErrorBar(RivHot_I_ave(:,1),RivHot_V_ave,RivHot_V_std, {'color',map(3,:),'marker',symbols{3},'LineStyle','-'})
% J(4) = shadedErrorBar(IsoHigh_I_ave(:,1),IsoHigh_V_ave,IsoHigh_V_std, {'color',map(4,:),'marker',symbols{3},'LineStyle','-'})
% legend([J(1).mainLine,J(2).mainLine,J(3).mainLine,J(4).mainLine],['T_1 = T_2 = 20 \degree C'],['T_1 = 20 \degree C, T_2 = 40 \degree C'],['T_1 = 40 \degree C, T_2 = 20 \degree C'],['T_1 = T_2 = 40 \degree C'], 'Location', 'best')
% legend boxoff
% 
% XaxisLabel = xlabel('Potential (V)');
% YaxisLabel = ylabel('Current (A)');
% 
% nn = nn+1;

