% ODE Temperature Solve
function test_ode_Heat()

[x,Dx] = chebdif(20,1);
[y,Dy] = chebdif(20,1);
Q_channel = 50e-3; %L/min
Q_channel = Q_channel/1000/60; % m3/s
rho = 998; % kg/m^3
m_channel = Q_channel*rho;
m_hot_rate = m_channel;
m_cold_rate = m_channel;
u_channel = 0.8/100; %m/s
X = 10e-2; % length in x-direction
Y = 10e-2; % length in y-direction
x = (x+1)*X/(2);
y = (y+1)*Y/(2);

Dx = Dx*(2)/X;
Dy = Dy*(2)/Y;
Cp = 4184; % J/kg/K
tau_hot = X/u_channel;
tau_cold = Y/u_channel;


mCp = m_hot_rate*tau_hot*Cp;
mCpXY = mCp*X*Y;
% # energy balance

A = 10*10*(1/100)^2;
KA = 15; % estimate heat transfer coefficient * exchange area
K = KA/A;
Twall = 22;
hA = 2.55;

%x = linspace(0,X,100);
%y = linspace(0,Y,100);



TC_in = 20;
TH_in = 40;

T_C = TC_in*ones(length(x),length(y));
T_H = TH_in*ones(length(x),length(y));

T_C(1,:) = TC_in;
T_H(:,1) = TH_in;

Twall = 22;

%[l,T] = ode15s(@myHeatBalance,[0 X],[TC_in TH_in],[],KA,mCp,X,Y,hA,Twall)

function G = myBalance(T,KA,mCp,X,Y,hA,Twall)



function F = myHeatBalance(l,T,KA,mCp,X,Y,hA,Twall)

% need to make it vs. x in Tc and y in Th and map the solutions, slightly
% different solving concept...

dT(1) = (KA)/(mCp*X*Y)*(T(2)-T(1))+hA/(mCp*X*Y)*(Twall-T(1));
dT(2) = -(KA)/(mCp*X*Y)*(T(2)-T(1))+hA/(mCp*X*Y)*(Twall-T(2));

F = dT';
