clear all;
close all;
clc;

theta = [0.2249 0.2289 0.2335 0.2387];
twoSigma = [46.76 60.18 75.20 91.44];


T = [15 25 35 45]+273.15;
C = [1e-5 0.1 0.5 1 2 3 4 5 6 7 8 10 15 20 25 30 50 75 100 200 500 1000]/1e4; % M

theta = repmat(theta,length(C),1);
twoSigma = repmat(twoSigma,length(C),1);

C = repmat(C,length(T),1);
C = C';

% KCl
Lambda0_T = [121.07 149.85 180.42 212.41]; 
B = [217 154 150 158];
D = [76 32 16 6];

Lambda0_T = repmat(Lambda0_T,length(C),1);
B = repmat(B,length(C),1);
D = repmat(D,length(C),1);


Lambda_T_KCl = (Lambda0_T+B.*C+D.*C.*log(C)).*(1-theta.*sqrt(C))-twoSigma.*sqrt(C); % S cm^2/mol
kappa_T_KCl = Lambda_T_KCl.*C/10; % S/m
figure(1)
hold on
for i=1:length(T)
    plot(C(:,1),kappa_T_KCl(:,i),'o--')
end
xlabel('Concentration, [M]')
ylabel('KCl Conductivity, [S/m]')
legend(num2str(T))
hold off
    
% NaCl
Lambda0_T = [101.18 126.45 153.75 182.65]; 
B = [210 107 137 159];
D = [73 3 2 0];

Lambda0_T = repmat(Lambda0_T,length(C),1);
B = repmat(B,length(C),1);
D = repmat(D,length(C),1);

Lambda_T_NaCl = (Lambda0_T+B.*C+D.*C.*log(C)).*(1-theta.*sqrt(C))-twoSigma.*sqrt(C); % S cm^2/mol
kappa_T_NaCl = Lambda_T_NaCl.*C/10; % S/m

figure(2)
hold on
for i=1:length(T)
    plot(C(:,1),kappa_T_NaCl(:,i),'o--')
end
xlabel('Concentration, [M]')
ylabel('NaCl Conductivity, [S/m]')
legend(num2str(T))
hold off

C_river = 0.017;

C_sea = 0.513;

C_interpGrid = C;
T_interpGrid = repmat(T,22,1);
kappaRiver_atT = zeros(1,4);
for i = 1:length(T)
    kappaRiver_atT(i) = interp1(C(:,1),kappa_T_NaCl(:,i),C_river,'spline'); 
end
kappaRiver_at_20deg = interp1(T,kappaRiver_atT,293.15,'spline');
kappaRiver_at_40deg = interp1(T,kappaRiver_atT,273.15+35.6,'spline');
kappaRiver_at_25deg = interp1(T,kappaRiver_atT,273.15+25,'spline');
kappaRiver_at_30deg = interp1(T,kappaRiver_atT,273.15+30,'spline');
kappaSea_atT = zeros(1,4);
for i = 1:length(T)
    kappaSea_atT(i) = interp1(C(:,1),kappa_T_NaCl(:,i),C_sea,'linear','extrap'); 
end
kappaSea_at_20deg = interp1(T,kappaSea_atT,293.15,'linear');
kappaSea_at_40deg = interp1(T,kappaSea_atT,273.15+35.6,'linear');
kappaSea_at_30deg = interp1(T,kappaSea_atT,273.15+30,'linear');
kappaSea_at_25deg = interp1(T,kappaSea_atT,273.15+25,'linear');

Resistivity_River_20 = 1/kappaRiver_at_20deg;
Resistivity_River_40 = 1/kappaRiver_at_40deg;
Resistivity_Sea_20 = 1/kappaSea_at_20deg;
Resistivity_Sea_40 = 1/kappaSea_at_40deg;


A = (10e-2*10e-2);
l = 260e-6;

R_River_20 = Resistivity_River_20*l/A
R_River_40 = Resistivity_River_40*l/A
R_Sea_20 = Resistivity_Sea_20*l/A
R_Sea_40 = Resistivity_Sea_40*l/A

R_Sea_Change = (R_Sea_40-R_Sea_20)/R_Sea_20*100
R_River_Change = (R_River_40-R_River_20)/R_River_20*100

N_cell = 4;

R_CMX_20 = 2.75*(10e-2)*(10e-2);
R_AMX_20 = 2.5*(10e-2)*(10e-2);

R_CMX_30 = 2*(10e-2)*(10e-2);
R_AMX_30 = 2*(10e-2)*(10e-2);

Res_Membrane_20 = N_cell*(R_CMX_20+R_AMX_20)
Res_Membrane_30 = N_cell*(R_CMX_30+R_AMX_30)
Res_Liq_20 = N_cell*(R_River_20+R_Sea_20)
%Res_Liq_30 = N_cell*(R_River_30+R_Sea_30);
Res_Liq_40 = N_cell*(R_River_40+R_Sea_40)

R_20 = Res_Liq_20+Res_Membrane_20
R_30 = Res_Liq_40+Res_Membrane_30

PercentChange = (R_30-R_20)/R_20*100

