% Temperature Profile Cross-flow Membrane Stack
% clear all;
close all;
% clc;

% Color map definition
level = 100; n = ceil(level/2);
cmap1 = [linspace(0, 1, n); linspace(0, 1, n); linspace(1, 1, n)]';
cmap2 = [linspace(1, 1, n); linspace(1, 0, n); linspace(1, 0, n)]';
cmap = [cmap1; cmap2(2:end, :)];

drawArrow = @(x,y,varargin) quiver( x(1),y(1),x(2)-x(1),y(2)-y(1),0, varargin{:} )     

% 2D approximation
Q_channel = 50e-3; %L/min
Q_channel = Q_channel/1000/60; % m3/s
rho = 998; % kg/m^3
m_channel = Q_channel*rho;
m_hot_rate = m_channel;
m_cold_rate = m_channel;
u_channel = 0.8/100; %m/s
X = 10e-2; % length in x-direction
Y = 10e-2; % length in y-direction
Cp = 4184; % J/kg/K
tau_hot = X/u_channel;
tau_cold = Y/u_channel;

% # energy balance



T_hot_in = 40;
T_cold_in = 20;
A = 10*10*(1/100)^2;
UA = 6.5; % estimate heat transfer coefficient * exchange area
UA_mCp = UA/(m_channel*Cp);
U = UA/A;

x = linspace(0,X,100);
y = linspace(0,Y,100);

p = UA*x/(m_hot_rate*Cp*tau_hot*X*Y);
q = UA*y/(m_cold_rate*Cp*tau_cold*X*Y);
F = zeros(length(p),length(q));
f = zeros(length(p),length(q));
for i = 1:length(p)-1
    p_now = p(i+1);
    for j = 1:length(q)
        q_now = q(j);
        sum_F_term = 0;
        for k=1:100
            sum_F_term = sum_F_term+(q_now/p_now)^((k-1)/2)*besseli(k-1,2*sqrt(p_now*q_now));
        end
        sum_f_term = sum_F_term - besseli(0,2*sqrt(p_now*q_now));
        F(i+1,j) = exp(-p_now-q_now)*sum_F_term;
        f(i+1,j) = exp(-p_now-q_now)*sum_f_term;
    end
end

F(1,:) = 1;
f(:,1) = 0;
for j=2:length(q)
    x_interp = q(2:4);
    y_interp = f(2:4,j);
    f_now = interp1(x_interp,y_interp',q(1),'linear','extrap');
    f(1,j) = f_now;
end

T_cold = T_hot_in+(T_cold_in-T_hot_in)*F;
T_hot = T_hot_in+(T_cold_in-T_hot_in)*f;
dim_T_cold = (T_cold-T_cold_in)/(T_hot_in-T_cold_in);
dim_T_hot =(T_hot-T_cold_in)/(T_hot_in-T_cold_in);
figure(1)
hold on
pcolor(y,x,dim_T_cold)
colormap(cmap);
caxis([0 1]);
% colorbar
shading interp
ax = gca;
ax.XTick = [0 0.1];
ax.YTick = [0 0.1];
x1 = [0.05 0.05];
y1 = [0.01 0.03];
drawArrow(x1,y1,'linewidth',2,'color','k','MaxHeadSize',0.8);
% xlabel('y')
% ylabel('x')
% title('Cold Temperature Profile')
cleanfigure('minimumPointsDistance',1e9);
matlab2tikz('floatFormat','%.4f','ColdTemp.tex')
print('-dpng','H:\My Documents\Experiments\Temperature gradients\Plaatjes png\ColdTemp')

figure(2)
hold on
pcolor(y,x,dim_T_hot)
colormap(cmap);
caxis([0 1]);
shading interp
% colorbar
ax = gca;
ax.XTick = [0 0.1];
ax.YTick = [0 0.1];
x1 = [0.01 0.03];
y1 = [0.05 0.05];
drawArrow(x1,y1,'linewidth',2,'color','k','MaxHeadSize',0.8);
% xlabel('y, hot fluid path')
% ylabel('x, cold fluid path')
% title('Hot Temperature Profile')
cleanfigure('minimumPointsDistance',1e9);
matlab2tikz('floatFormat','%.4f','HotTemp.tex')
print('-dpng','H:\My Documents\Experiments\Temperature gradients\Plaatjes png\HotTemp')


average_hot_out = mean(T_hot(:,length(q)))
average_cold_out = mean(T_cold(length(p),:))

difference_T = dim_T_hot-dim_T_cold;
mean_difference_T = mean(mean(T_hot-T_cold))
figure(3)
hold on
pcolor(y,x,difference_T)
colormap(cmap);
caxis([0 1]);
colorbar
shading interp
ax = gca;
ax.XTick = [0 0.1];
ax.YTick = [0 0.1];
xlabel('hot fluid path \rightarrow')
ylabel('cold fluid path \rightarrow')
% xlabh = get(gca,'XLabel');
% set(xlabh,'Position',get(xlabh,'Position') - [0.1 .1 0])
% xlabel('y, hot fluid path')
% ylabel('x, cold fluid path')
% title('Temperature Difference for EDRED')
cleanfigure('minimumPointsDistance',1e9);
matlab2tikz('floatFormat','%.4f','TempDiff.tex')
print('-dpng','H:\My Documents\Experiments\Temperature gradients\Plaatjes png\TempDiff')

EnergyCheck = m_hot_rate*Cp*tau_hot*(T_hot_in-average_hot_out);
EnergyCheck2 = m_cold_rate*Cp*tau_cold*(average_cold_out-T_cold_in);
Difference = EnergyCheck-EnergyCheck2
RelError = abs(Difference)/EnergyCheck*100
disp(['Loss of Energy is ', num2str(RelError),'%'])

