function [A,B,D,H,h,W,R,w_barge,Hy1,Hy2,vehicle1,B_bin] = createABD(tau_12,tau_13,tau_23,nc,c_barge,w_barge,w_TEU,w_13,w_23,w_demand)
% This function assembles the A B and D matrix, so the sytsem update is
% x(k+1)= Ax(k) + Bu(k) +d(k) +B_bin [d1(k);d2(k)]
% subject to H[x;u;y(k)] <= h
% objective R*u(k)+W*x(k)+x(Tp)*W + w_barge*sum(d1+d2)

%% Create A
A=zeros((10+4*(tau_13)+6*(tau_12)+4*(tau_23)));
container1=1; %this is for equations for containers on location 1
A(1,1)=1; A(1,1+tau_13)=1; A(1,1+tau_13+tau_12)=1; % stack 1 container
A(3:1+tau_13,2:tau_13)=eye(tau_13-1); % memory of containers on their way u_31
A(1+tau_13+2:1+tau_13+tau_12,1+tau_13+1:tau_13+tau_12)=eye(tau_12-1); % memory of containers on their way u_21

container2=1+tau_13+tau_12+1; %this is start of whats needed for equations for containers on location 2
A(container2,container2)=1;
A(container2,container2+tau_23)=1;
A(container2,container2+tau_23+tau_12)=1;
A(container2+2:container2+tau_23,container2+1:container2+tau_23-1)=eye(tau_23-1);
A(container2+tau_23+2:container2+tau_23+tau_12,container2+tau_23+1:container2+tau_23+tau_12-1)=eye(tau_12-1);

container3=container2+tau_23+tau_12+1; %this is start of whats needed for equations for containers on location 2
A(container3,container3)=1;
A(container3,container3+tau_23)=1;
A(container3,container3+tau_23+tau_13)=1;
A(container3+2:container3+tau_23,container3+1:container3+tau_23-1)=eye(tau_23-1);
A(container3+tau_23+2:container3+tau_23+tau_13,container3+tau_23+1:container3+tau_23+tau_13-1)=eye(tau_13-1);

container4=container3+tau_23+tau_13+1; %for demand locations
A(container4,container4)=1; % destination 4
A(container4+1,container4+1)=1; %destination 5

vehicle1=container4+2; % for parking 1
A(vehicle1,vehicle1)=1;
A(vehicle1,vehicle1+tau_13)=1;
A(vehicle1+2:vehicle1+tau_13,vehicle1+1:vehicle1+tau_13-1)=eye(tau_13-1);

vehicle2=vehicle1+tau_13+1; % for parking 2
A(vehicle2,vehicle2)=1;
A(vehicle2,vehicle2+tau_23)=1;
A(vehicle2+2:vehicle2+tau_23,vehicle2+1:vehicle2+tau_23-1)=eye(tau_23-1);

vehicle3=vehicle2+tau_23+1; % for parking 3
A(vehicle3,vehicle3)=1;
A(vehicle3,vehicle3+tau_13)=1;
A(vehicle3,vehicle3+tau_13+tau_23)=1;
A(vehicle3+2:vehicle3+tau_13,vehicle3+1:vehicle3+tau_13-1)=eye(tau_13-1);
A(vehicle3+2+tau_13:vehicle3+tau_13+tau_23,vehicle3+1+tau_13:vehicle3+tau_13+tau_23-1)=eye(tau_23-1);

barge1=vehicle3+tau_13+tau_23+1; % for barges at terminal 1
A(barge1,barge1)=1;
A(barge1,barge1+tau_12)=1;
A(barge1+2:barge1+tau_12,barge1+1:barge1+tau_12-1)=eye(tau_12-1);

barge2=barge1+tau_12+1; % for barges at terminal 2
A(barge2,barge2)=1;
A(barge2,barge2+tau_12)=1;
A(barge2+2:barge2+tau_12,barge2+1:barge2+tau_12-1)=eye(tau_12-1);

oldbarge1=barge2+tau_12+1; % for the storage of the old barge settings
A(oldbarge1,barge1)=1; % remeber current setting
A(oldbarge1+1:oldbarge1+tau_12-1,oldbarge1:oldbarge1+tau_12-2)=eye(tau_12-1); % terminal 1
oldbarge2=oldbarge1+tau_12; % for the storage of the old barge settings
A(oldbarge2,barge2)=1; % remeber current setting
A(oldbarge2+1:oldbarge2+tau_12-1,oldbarge2:oldbarge2+tau_12-2)=eye(tau_12-1); % terminal 2


%% Create B
n_u=16; % number of inputs
B=zeros(size(A,1),n_u);

B(container1,1)=-1; B(container1,2)=1; % demand satisfaction from 1
B(container1,3)=-1; B(container1,4)=-1; % transport from 1
B(container3+tau_23+1,3)=1; B(container2+tau_23+1,4)=1; % save to memory for arrival node

B(container2,6)=-1; B(container2,7)=-1; % transport from 2
B(container3+1,6)=1; B(container1+tau_13+1,7)=1; % save to memory for arrival node

B(container3,9)=-1; B(container3,10)=-1; % transport from 3
B(container2+1,9)=1; B(container1+1,10)=1; % save to memory for arrival node
B(container3,11)=-1; B(container3,12)=1; % demand satisfied from 3

B(container4,2)=-1; B(container4,1)=-1; %destination 4
B(container4+1,11)=-1; B(container4+1,12)=-1; %destination 5

B(vehicle1,13)=-1; % vehicles leaving from 1
B(vehicle3+1,13)=1; % save to memory for arrival node

B(vehicle2,14)=-1; % vehicles leaving from 2
B(vehicle3+tau_13+1,14)=1; % save to memory for arrival node

B(vehicle3,15)=-1; B(vehicle3,16)=-1; % vehicles leaving from 2
B(vehicle1+1,15)=1; B(vehicle2+1,16)=1; % save to memory for arrival node

% without z
 B(:,8)=[];B(:,5)=[];

%% Create B_bin
B_bin=zeros(size(A,2),2);
B_bin(barge1,1)=-1; % barge leaves terminal 1
B_bin(barge2,2)=-1; % barge leaves terminal 2
B_bin(barge1+1,2)=1; % samve departure from 2 to memory
B_bin(barge2+1,1)=1; % samve departure from 1 to memory

%% Create D
D=zeros(size(A,1),2); % demand at two locations
D(container4,2)=1; % demand4 is second in demand vector
D(container4+1,1)=1; % demand5 is first in demand vector

%% Create H

H=zeros(2+size(A,2)+size(B,2),size(A,2)+size(B,2)+2); % the 6 is number of constraints and the 2 is the binary variables
h=zeros(size(H,1),1);
H(1,size(A,2)+4)=1; H(1,size(A,2)+size(B,2)+1)=-c_barge; h(1)=0; %barge capacity departing from 1
H(2,size(A,2)+6)=1; H(2,size(A,2)+size(B,2)+2)=-c_barge; h(2)=0; %barge capacity departing from 1
H(3,size(A,2)+3)=1; H(3,size(A,2)+11)=-1; %u13-v13 <=0
H(4,size(A,2)+5)=1; H(4,size(A,2)+12)=-1; %u23-v23 <=0
H(5,size(A,2)+7)=1; H(5,size(A,2)+14)=-1; %u32-v32 <=0
H(6,size(A,2)+8)=1; H(6,size(A,2)+13)=-1; %u31-v31 <=0

%% Creates Hy1 and Hy2
% y1(k) <= x_1^barge(k)
% y1(k)-Hy1*x(k)<= 0
% if barge has to depart, it should already be at node
Hy1=zeros(1,size(A,2));
Hy1(1,barge1)=1;
Hy2=zeros(1,size(A,2));
Hy2(1,barge2)=1;

%% Creates obective function
% w_barge=; % cost of sending barge
% w_TEU=; % cost per TEU for shipping either 1->2 or 2->1
% w_13=; % cost of driving truck on 1-3 arch
% w_23=; % cost of driving truck on 2-3 arch
% w_demand=; % cost per TEU per timestep for unsatisfied demand
% objective R*u(k)+W*x(k)+x(Tp)*W + w_barge*sum(d1+d2)

R=[0 0 0 w_TEU 0 w_TEU 0 0 0 0 w_13 w_23 w_13 w_23];
W=zeros(1,size(A,2));
W(1,container4)=w_demand; W(1,container4+1)=w_demand;


%% Increase to two commodities - only for containers
Aold=A; Bold=B;
A=[kron(A(1:vehicle1-1,1:vehicle1-1),eye(nc)) , kron(A(1:vehicle1-1,vehicle1:end),ones(nc,1)) ;...
    kron(A(vehicle1:end,1:vehicle1-1),ones(1,nc)) , A(vehicle1:end,vehicle1:end)]; 
B=[kron(B(1:vehicle1-1,1:10),eye(nc)) , kron(B(1:vehicle1-1,11:end),ones(nc,1)) ;...
    kron(B(vehicle1:end,1:10),ones(1,nc)) , B(vehicle1:end,11:end)];
D=[kron(D(1:vehicle1-1,:),eye(nc)); kron(D(vehicle1:end,:),ones(1,nc))];
B_bin=[kron(B_bin(1:vehicle1-1,:),ones(nc,1)) ; B_bin(vehicle1:end,:)];

Hb=[kron(H(1:2,1:vehicle1-1),ones(1,nc)), H(1:2,vehicle1:size(Aold,2)), ...
    kron(H(1:2,size(Aold,2)+1:size(Aold,2)+10),ones(1,nc)), ...
    H(1:2,size(Aold,2)+11:size(Aold,2)+size(Bold,2)),  H(1:2,end-1:end) ];
H_sim=[kron(H(3:6,1:vehicle1-1),ones(1,nc)), H(3:6,vehicle1:size(Aold,2)), ...
    kron(H(3:6,size(Aold,2)+1:size(Aold,2)+10),ones(1,nc)), ...
    H(3:6,size(Aold,2)+11:size(Aold,2)+size(Bold,2)),  H(3:6,end-1:end) ];

H_demand=zeros(4,size(Hb,2));
H_demand(1,size(A,2)+2+2)=1; % u_41 has to be zero for commodity 2
H_demand(2,size(A,2)+1)=1; % u_14 has to be zero for commodity 1
H_demand(3,size(A,2)+8*2+2)=1;
H_demand(4,size(A,2)+9*2+1)=1;

H=[Hb;H_sim;H_demand]; % I put the rest of the constraints in the yalmip language (this is the barge capcity

h=zeros(size(H,1),1);

Hy1=[ kron(Hy1(1:vehicle1-1),ones(1,nc)), Hy1(vehicle1:size(Aold,2))]; % Hyx(k) not on xuy
Hy2=[ kron(Hy2(1:vehicle1-1),ones(1,nc)), Hy2(vehicle1:size(Aold,2))]; % Hyx(k) not on xuy
R=[kron(R(1:10),ones(1,nc)), R(11:end)]; % Ru(k)
W=[kron(W(1:vehicle1-1),ones(1,nc)) , W(vehicle1:end)]; %Wx(k)


end

