%% Realistic scenario
% simulation parameters
k_max=480; 

%% build system
tau_12=24; tau_13=9; tau_23=4; %traveltimes. It is assumed both directions take equally long
c_barge=100; % capcity of barge
nc=2; % number of commodities
% 
w_barge=210; % cost of sending barge
w_TEU=13.18; % cost per TEU for shipping either 1->2 or 2->1
w_13=73.19; % cost of driving truck on 1-3 arch
w_23=33.93; % cost of driving truck on 2-3 arch
w_demand=1000; % cost per TEU per timestep for unsatisfied demand

% warning('choose a demand profile')
%  load('Demand_profile_Unbalanced') 
%  load('Demand_profile_Peaks')
%  load('Demand_profile_Peaks2')
%  load('Demand_profile_Peaks4')
%  load('Demand_profile_Peaks6')
load('Demand_profile_Unbalanced6feasible');

[A,B,D,H,h,W,R,w_barge,Hy1,Hy2,vehicle1,B_bin] = createABD(tau_12,tau_13,tau_23,nc,c_barge,w_barge,w_TEU,w_13,w_23,w_demand);

%% Initial conditions
x(:,1)=zeros(size(A,2),1);
x(Hy2==1)=1; % one barge starts at port 2
x((vehicle1-1)*nc+1+tau_13+1)=36; %all vehicles parked at node 2


%% Initialization of framework for "guessing" interesting discrete decisions
h_cooling=tau_12; % minimum number of timesteps inbetween barge departures. d1=1 is posible    