%{
Created in 2023
@author: Jana Marie Spaeth, Konstantina Kolovou Kouri
%}

clear
M = readmatrix("scope.csv");
t = (M(4:end, 1) - M(4,1))*1000;
V_Ch1 = M(4:end, 2);
V_Ch2 = M(4:end, 3);
V_Ch3 = M(4:end, 4);
V_Ch4 = M(4:end, 5);
V_math = M(4:end, 6);

figure()
tiledlayout(2,1)
set(gcf,'color','w');
set(gcf,'position',[10,10,800,500])

ax1 = nexttile();
plot(t,(V_Ch1-V_Ch2),t,(V_Ch2-V_Ch4)/0.994,t,V_Ch3/10,'g', 'LineWidth', 1)
ylabel('Current [mA]')
legend('Stimulator Current', 'Electrode Current', 'Corrective Current')
%ax1.TitleHorizontalAlignment = 'left'; 
grid('on')
ax = gca; 
ax.FontSize = 14; 

ax2 = nexttile();
plot(t,V_Ch2, 'LineWidth', 1)
ylabel('Voltage [V]')
legend('Electrode Voltage')
%ax2.TitleHorizontalAlignment = 'left'; 
xlabel('Time [ms]')

grid('on')
ax = gca; 
ax.FontSize = 14;



