function CI = within_subject_ci(X)

Xn = X - repmat(mean(X,2,'omitnan'),1,size(X,2)); % correction so that the mean of the rows (participants) equals 0 (adding the grand mean is omitted since we are only interested in the width of the confidence interval)

[~,~,ci] = ttest(Xn); % calculate 95% confidence intervals, assuming a normal distribution

CI = (diff(ci,1)/2) * sqrt(size(X,2)/(size(X,2)-1)); % correction factor as described in Morey (2008)
% CI is half of the confidence interval, so it should be plotted from mean-CI to mean+CI 

% Based on:
% Morey, R. D. (2008). Confidence intervals from normalized data: A correction to Cousineau (2005). Tutorials in Quantitative Methods for Psychology, 4, 61-64. https://doi.org/10.20982/tqmp.04.2.p061
