Name:        djehuty
Version:     25.3
Release:     1%{?dist}
Summary:     Data repository system by 4TU.ResearchData and Nikhef
Source0:     %{name}-%{version}.tar.gz
License:     AGPL-3.0-or-later
Group:       System Environment/Daemons
BuildRoot:   %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildArch:   noarch
Vendor:      Roel Janssen <r.r.e.janssen@tudelft.nl>
Url:         https://github.com/4TUResearchData/djehuty
BuildRequires: systemd-rpm-macros
# RHEL8 defaults to Python 3.6
%if 0%{?rhel} == 8
%global python3_pkgversion 39
%else
# Only RHEL8 does not have a package for the 'build' module.
BuildRequires: python%{python3_pkgversion}-build
%endif
BuildRequires: python%{python3_pkgversion}-devel
BuildRequires: python%{python3_pkgversion}-setuptools
BuildRequires: python%{python3_pkgversion}-pip
%if 0%{?fedora} >= 40
BuildRequires: texlive-libertine
BuildRequires: python%{python3_pkgversion}-wheel
%else
BuildRequires: python%{python3_pkgversion}-setuptools-wheel
BuildRequires: python%{python3_pkgversion}-pip-wheel
%endif
BuildRequires: texlive
BuildRequires: texlive-tex4ht
BuildRequires: texlive-appendix
BuildRequires: texlive-titlesec
BuildRequires: texlive-float
BuildRequires: make
Requires: git
Requires: python%{python3_pkgversion}-requests
Requires: python%{python3_pkgversion}-jinja2
Requires: python%{python3_pkgversion}-rdflib
Requires: python%{python3_pkgversion}-pygit2
Requires: python%{python3_pkgversion}-werkzeug
Requires: python%{python3_pkgversion}-defusedxml
Requires: python%{python3_pkgversion}-pillow

%undefine __brp_mangle_shebangs

%description
This package provides the data repository system by
4TU.ResearchData and Nikhef.

%prep
%autosetup -p1 -n %{name}-%{version}
# RHEL8 does not provide the 'build' module for Python.  Fortunately, it's
# only required on build-time, not run-time, so we take a shortcut here.
%if 0%{?rhel} == 8
pip3.9 install build
%endif

%build
%{configure}
make


%install
make install DESTDIR=%{buildroot}
mkdir -p %{buildroot}%{_unitdir}
cp etc/%{name}.service %{buildroot}%{_unitdir}/
mkdir -p %{buildroot}/etc/%{name}
cp etc/%{name}/%{name}-example-config.xml %{buildroot}/etc/%{name}/

%clean
rm -rf %{buildroot}

%files
%license LICENSE
%defattr(-,root,root)
%doc README.md
%{python3_sitelib}/%{name}/
%{python3_sitelib}/%{name}-25.3*
%{_unitdir}/%{name}.service
%dir /etc/%{name}
%{_sysconfdir}/%{name}/%{name}-example-config.xml
%{_bindir}/%{name}
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/%{name}.css
%{_datadir}/%{name}/%{name}.pdf
%{_datadir}/%{name}/%{name}2.html
%{_datadir}/%{name}/%{name}3.html
%{_datadir}/%{name}/%{name}4.html
%{_datadir}/%{name}/%{name}5.html
%{_datadir}/%{name}/%{name}6.html
%{_datadir}/%{name}/%{name}7.html
%dir %{_datadir}/%{name}/figures
%{_datadir}/%{name}/figures/account-.png
%{_datadir}/%{name}/figures/author-.png
%{_datadir}/%{name}/figures/category-.png
%{_datadir}/%{name}/figures/collaborators-.png
%{_datadir}/%{name}/figures/collection-.png
%{_datadir}/%{name}/figures/collection-container-.png
%{_datadir}/%{name}/figures/dataset-.png
%{_datadir}/%{name}/figures/dataset-container-.png
%{_datadir}/%{name}/figures/favicon.png
%{_datadir}/%{name}/figures/file-.png
%{_datadir}/%{name}/figures/funding-.png
%{_datadir}/%{name}/figures/institutiongroup-.png
%{_datadir}/%{name}/figures/privatelink-.png
%{_datadir}/%{name}/figures/rdf-list-abbrev-.png
%{_datadir}/%{name}/figures/references-graph-.png
%{_datadir}/%{name}/figures/typed-literals-notation-.png
%{_datadir}/%{name}/figures/typed-notation-.png
%dir %{_datadir}/%{name}/fonts
%{_datadir}/%{name}/fonts/FiraMono-Regular.ttf
%{_datadir}/%{name}/fonts/SourceSansPro-Bold.ttf
%{_datadir}/%{name}/fonts/SourceSansPro-Italic.ttf
%{_datadir}/%{name}/fonts/SourceSansPro-Regular.ttf
%{_datadir}/%{name}/index.html

%post
%systemd_post %{name}.service

%preun
%systemd_preun %{name}.service

%postun
%systemd_postun_with_restart %{name}.service

%changelog
* Fri Jan 31 2025 Roel Janssen <r.r.e.janssen@tudelft.nl> 25.1-1
- Initial RPM creation.
- See https://djehuty.4tu.nl/#news-section for the full release notes.
