# -*- coding: utf-8 -*-
"""
Created on Mon Feb 10 23:05:17 2025

@author: jrronne
"""

# Import necessary libraries
import pandas as pd
import seaborn as sns
import numpy as np
import matplotlib.pyplot as plt
import statsmodels.formula.api as smf  
import math


plt.rcParams.update({'font.size': 18})
plt.rcParams['text.usetex'] = True

plt.rc('font', family='serif')

def binomial_p_value(k,n):
    n_k=math.comb(n, k)
    p=n_k*(1/3)**k*(1-1/3)**(n-k)
    return(p)

# Load workload data
subjective_data = pd.read_csv('workload.csv')

# 5/6 items are included (Performance, subjective one here, is not needed)
included_item = ['Mental demand', 'Physical demand', 'Temporal demand', 'Effort', 'Frustration level']
subjective_data = subjective_data[subjective_data['Item'].isin(included_item)]


# =============================================================================
# Un weighted ratings
# =============================================================================

# Number of workload decrease per item per transition
pivot_table = pd.pivot_table(subjective_data, index='Item', columns='Trans', values='delta_subj', aggfunc=lambda x: (x < 0).sum())
print(pivot_table)

# Number of workload increase per item per transition
pivot_table = pd.pivot_table(subjective_data, index='Item', columns='Trans', values='delta_subj', aggfunc=lambda x: (x > 0).sum())
print(pivot_table)

# Number of workload with no variation per item per transition
pivot_table = pd.pivot_table(subjective_data, index='Item', columns='Trans', values='delta_subj', aggfunc=lambda x: (x == 0).sum())
print(pivot_table)


# =============================================================================
# Weigthed ratings
# =============================================================================
data_WR_no_agredated = []

# Median over participants
for trans in subjective_data['Trans'].unique():
    for item in subjective_data['Item'].unique():
        df = subjective_data[(subjective_data['Item'] == item) & (subjective_data['Trans'] == trans)]
        
        median = df['delta_subj_N'].median()
        std = df['delta_subj_N'].std()
        delta_x = np.max(df['delta_x'].unique())
        
        data_WR_no_agredated.append([trans, item, median, delta_x])
        
data_WR_no_agredated = pd.DataFrame(data = data_WR_no_agredated, columns = ['Trans', 'Item', 'median', 'delta_x'])
        

data_WR_agredated = []

# Mean over items
for trans in data_WR_no_agredated['Trans'].unique():

        df = data_WR_no_agredated[data_WR_no_agredated['Trans'] == trans]
        
        mean = df['median'].mean()
        std = df['median'].std()
        delta_x = np.max(df['delta_x'].unique())
        
        data_WR_agredated.append([trans, mean, delta_x, std])
        
data_WR_agredated = pd.DataFrame(data = data_WR_agredated, columns = ['Trans', 'mean', 'delta_x', 'std'])


#%% Make figure Delta R vs Delta x

plt.figure(figsize=(8, 6))  # Set the figure size
ax = sns.scatterplot(data_WR_agredated, x = 'delta_x', y = 'mean', color = 'grey')

# fig, ax = plt.subplots(1, 1)

model = smf.ols('mean ~ delta_x - 1 ', data=data_WR_agredated).fit()
print(model.summary())
a = model.params.iloc[0]
p = round(model.pvalues.iloc[0], 3)
r2 = round(model.rsquared, 2)
x = data_WR_agredated['delta_x'].to_numpy()
y = data_WR_agredated['mean'].to_numpy()


y_predict = a*x
ax.plot(x, y_predict, label = f'$R^2={r2}-p={p}$', color = 'black')

labels = ['AC', 'AB', 'AD', 'CD', 'BC', 'BD']
for ii,(X,Y) in enumerate(zip(x,y)):
    ax.text(X+0.01, Y+0.01, labels[ii])

ax.set_ylim(0.004348376910054491, 1.8)
ax.set_xlim(0.06774999999999999, 0.5)
ax.set_xlabel('$\Delta x~(m)$')
ax.set_ylabel('$\Delta R$')
plt.tight_layout()
ax.legend(bbox_to_anchor=(1.1, 1.05))

# plt.savefig(f'regression_delta_subj_delta_x.pdf')
# plt.savefig(f'regression_delta_subj_delta_x.svg')

