# -*- coding: utf-8 -*-
"""
Created on Mon Feb 10 21:12:19 2025

@author: jrronne
"""

# Import necessary libraries
import pandas as pd
import seaborn as sns
import statsmodels.api as sm
from statsmodels.formula.api import ols
import matplotlib.pyplot as plt

import statsmodels.formula.api as smf  

# Load performance data
performance_data = pd.read_csv('performance_metric.csv', sep=',')



#%% Design effect on performance?

# Define statistical model
# We use a linear model to analyze the relationship between configuration and performance
model = ols('d_tot_d_0 ~ config', data=performance_data).fit()

# Perform analysis of variance
# We use analysis of variance to evaluate the statistical significance of the relationship between configuration and performance
anova_results = sm.stats.anova_lm(model)
print(anova_results)

# Create a LaTeX-style plot
# We use seaborn's boxplot function to visualize the distribution of cinematic performance by configuration

plt.rcParams.update({
    'text.usetex': True,
    'font.family': 'serif',})

plt.figure(figsize=(8, 6))  # Set figure size

sns.boxplot(performance_data, x="config", y='d_tot_d_0', order=['A', 'B', 'C', 'D'])
plt.xlabel("Configuration", fontsize=14)  # Set x-axis label
plt.ylabel("Performance metric", fontsize=14)  # Set y-axis label
plt.xticks(fontsize=12)  # Set x-axis tick font size
plt.yticks(fontsize=12)  # Set y-axis tick font size
plt.tight_layout()  # Adjust layout so that labels fit within figure
# plt.savefig("Performance_metric_by_config.pdf")  # Save plot to file



#%% Learning effect en performance?

model_trial_effect = ols('d_tot_d_0 ~ trial', data=performance_data).fit()

# Perform analysis of variance
# We use analysis of variance to evaluate the statistical significance of the relationship between configuration and cinematic performance

model = smf.ols('d_tot_d_0 ~ trial', data=performance_data).fit()

# Display the results
print(model.summary())

plt.figure(figsize=(8, 6))  # Set the figure size
sns.regplot(x="trial", y='d_tot_d_0',ci=None, data=performance_data, color='grey')  # Plot the regression line

# Add regression information to the legend
coeff = model.params[1]  # Coefficient of the independent variable
intercept = model.params[0]  # Intercept
r2 = model.rsquared  # Coefficient of determination (R²)
# legend_text = f"y = {coeff:.2f}x + {intercept:.2f}\nR² = {r2:.2f}"
# plt.text(0.05, 0.9, legend_text, transform=plt.gca().transAxes, fontsize=12)  # Add the text to the legend

# plt.title("Performance metric", fontsize=18)  # Set the title
plt.xlabel("$N_{Trial}$", fontsize=18)  # Set the x-axis label
plt.ylabel("$d_{F}/d_0$", fontsize=18)  # Set the y-axis label
plt.xticks(fontsize=16)  # Set the font size of the x-axis ticks
plt.yticks(fontsize=16)  # Set the font size of the y-axis ticks
plt.tight_layout()  # Adjust the layout so that the labels fit within the figure
plt.savefig("Performance_metric_by_trials.pdf")  # Save the figure to a file






