# Code and data (Supplementary data) from Personal Preference or Intrinsic Quality? A Study on Bicycle Handling Quality
## Description
This dataset contains post-processed data from an experimental study investigating whether bicycle handling quality is a matter of personal preference or an intrinsic, measurable property of the vehicle. Nineteen cyclists performed a controlled riding task on an instrumented cargo bicycle with four adjustable configurations (A, B, C, D), modified by changing the position of a 3 kg mass on the steering assembly. This alteration affected the steering inertia and handling dynamics while remaining visually concealed from participants.

The experiment took place indoors on a flat surface using a predefined track including straight-line riding, a U-turn, and a slalom. Each participant completed 8 trials, experiencing all pairwise transitions between configurations in a balanced order. They were instructed to maintain a constant speed of 5 km/h and to ride as straight as possible, minimizing deviations of the front wheel contact point.

Performance was objectively measured using three inertial measurement units (IMUs) embedded in smartphones (Nokia 3.4), sampling at 200 Hz.

The performance metric, normalized front wheel path length, was computed using ground plane kinematics and bicycle's parameters.

Workload was assessed using a relative version of the NASA-TLX questionnaire, focusing on five dimensions: Mental Demand, Physical Demand, Temporal Demand, Effort, and Frustration. After every two consecutive trials, participants reported perceived changes and estimated percentage differences, later normalized per participant to reduce inter-subject variability.

Participants were 19 adults (4 female, 15 male) with varying self-assessed cycling expertise (Medium: 6, High: 5, Very High: 7). All provided informed consent. The study was approved by the Human Research Ethics Committee of TU Delft.

The dataset includes performance metrics, workload assessments, trial sequences, and configuration parameters.

## Code
### Performance analysis
The Python code performance_analysis.py allows performing the statistical analysis conducted on the performance indicator and reproducing the figures from the article.

### Workload analysis
The Python code workload_analysis.py allows performing the analyses conducted on the measured workload and reproducing the figures from the article.

## Data
### Performance metric
The file 'performance_metric.csv' contains the trials performed by the participants, including their performance metric, sex, age, height, mass, skill level, average speed, and the configuration used.
Some data are missing due to sensor failure.

### Workload analysis
The file 'workload.csv' contains the trials performed by the participants. Each row represents the workload change reported by a participant for a given questionnaire item. The tested transition (i.e., a comparison between two configurations) as well as the variation in design parameter are also reported. Anthropometric data, sex, skill level, and age are also included in this file.