%Set variables
%Nodal point coefficients for sand and gravel
KS=1;
KG=2.5;

%widths of branches 1 and 2
B1=250;
B2=250;

%Checy values of branches 1 and 2
C1=50;
C2=50;

%length of branches 1 and 2
L1=10000;
L2=10000;

%Some additional variables, see Schielen and Blom (2018)
n=5;
kg=KG;
ks=KS;
B0=315;
Sg0=0.001;
Ss0=0.007;

ms=4.69092*10^(-5);
mg=7.81819*10^(-6);

%definitions of fractions gravel and sand
Fg0=(ms*Sg0)/(mg*Ss0 + ms*Sg0);
Fs0=1-Fg0;

%Discharge
Q0=4000;
Q0n=double(Q0^n);
%equilibrium depth in branch 0
a0=B0^(-1 + n^(-1))*Q0*((mg*ms)/(ms*Sg0 + mg*Ss0))^(1/n);

% evenwichtswaarden bij 1 tak dicht. Volgens methode Astrid
% aanname: S_ig en S_is bepalen de dieptes.
% Als 1 tak dicht dan aanname dat supply van tak 0 naar de open tak gaat. Vervolgens bepaalt dat de evenwichtsdiepte
% Eerst: Q1=0, dus Q2=Q0.

% QQ2=Q0;
% aa2=(QQ2/(B2^(1-1/n)))*( (ms*mg)/(mg*Ss0+ms*Sg0))^(1/n);
% % Dan Q2=0, dus Q1=Q0
% QQ1=Q0;
% aa1=(QQ1/(B1^(1-1/n)))*( (ms*mg)/(mg*Ss0+ms*Sg0))^(1/n);
