function solve_hirano_mixed_sed_1D(h1,h2,fg1,fg2)

for radius_loop=1:2 

if radius_loop == 1 
    radius=2; 
end
if radius_loop == 2 
    radius=20;
end
line_thickness=1.5;
figure;
hold on;
axis([0 20 0 20])
%call 'variables' to find values for ks and kg, the nodal points. 
variables_GRL
%And give the figue a title
title(strcat('k_s=',num2str(KS), ',  k_g=', num2str(KG),', F_{1g}=',num2str(fg1), ', F_{2g}=', num2str(fg2)))

%draw trajectories in phase space
%We only need one quadrant, so angle varies between 0-1/2 pi
%fi determines angle. 
for fi=0.5*pi*(1/20):(0.5*pi)/20:0.5*pi*(19/20)

% s1 and s2 are initial conditions of depths in branches
% make an exception for fi=1/4 pi, because in the case we selected here,
% that case degenerates. So we treat that separatly, for fi just a bit
% smaller and larget than 1/4 pi

if fi==0.25*pi
    %determine initial conditions for depts in branches
    %value just above 0 1/4 pi
    s1=radius*cos(fi+0.01);
    s2=radius*sin(fi+0.01);
    % call ode45 solver. Arguments: @hirano (contains vectorfield of hirano
    % equations, mixed sediment, 1D. See SI, GRL paper, section S3. 
    % other arguments: time, and set of initial conditions. 
    % fg1 and fg2 are fractions of sand and gravel, and are given in the call of
    % this function
    [t,y1]=ode45(@hirano_GRL,[0 230000000000],[s1 s2 fg1 fg2]);
    %same procedure for a value just below 1/4 pi
    s1=radius*cos(fi-0.01);
    s2=radius*sin(fi-0.01);
    [t,y2]=ode45(@hirano_GRL,[0 230000000000],[s1 s2 fg1 fg2]);
    
    % Check if the trajectory approaches the node. If so, color this trajectory red.
    % Else, the trajectory approaches the saddle, color the trajectory blue. 
    if y1(length(y1),1)<3 || y1(length(y1),2)<3 
        kolor='r';
    else
        kolor='b';
    end
    %plot the trajectory in the H1, H2 phase plane (H1 and H2 are the flow
    %depths in the bifurcates, see figure 4 GRL paper.
    figure(1);
    plot(y1(:,1),y1(:,2),'color',kolor, 'LineWidth',line_thickness)
    
    % Check if the trajectory approaches the node. If so, color this trajectory red.
    % Else, the trajectory approaches the saddle, color the trajectory blue.
    if y2(length(y2),1)<3 || y2(length(y2),2)<3 
        kolor='r';
    else
        kolor='b';
    end
    %plot the trajectories
    figure(1);
    plot(y2(:,1),y2(:,2),'color',kolor, 'LineWidth',line_thickness)
else
    %do the same for all other values of fi (so fi not equal to 0.25*pi)
    s1=radius*cos(fi);
    s2=radius*sin(fi);
    [t,y]=ode45(@hirano_GRL,[0 2300000000000],[s1 s2 fg1 fg2]);
    %check of de oplossing naar een gesloten tak gaat. Maak dan de baan rood.
    %Anders blauw.If statement is voor als fi=1/4 pi

    % check again whether the trajectory approaches the node or the saddle.
    % If the trajectory approaches the node, color red. If the trajectory
    % approaches the saddle, color blue.
    if y(length(y),1)<3 || y(length(y),2)<3
        kolor='r';
    else
        kolor='b';
    end
    %plot the trajectories
    figure(1);
    plot(y(:,1),y(:,2),'color',kolor, 'LineWidth',line_thickness)
end 

end
end %if loop

% set the axis and set the labels
axis([0 20 0 20])
axis equal
xlabel('depth in branch 1, H_1')
ylabel('depth in branch 2, H_2')

axis([0 20 0 20])
