function dydt = hirano_GRL(t,y)

% this function determines the vector field. See also Schielen and Blom
% (2018), eq. (19)-(22)

%set all initial variables
variables_GRL

%I need some prelimanry calculations to calculate values I need later 
% for the vector field. Among these are the values with index '0', which 
% are the values for branch zero. See Schielen and Blom (2018) for details.

a0=B0^(-1 + n^(-1))*Q0*((mg*ms)/(ms*Sg0 + mg*Ss0))^(1/n);
Fg0=(ms*Sg0)/(mg*Ss0 + ms*Sg0);
Fs0=1-Fg0;

% This is the definition of the vecor field 
  
dydt = [...
L1.^(-1).*Q0n.*(a0.^((-1).*n).*B0.^(1+(-1).*n).*((-1).*Fg0.*(B1.* ...
  B2.^(-1).*C1.*C2.^(-1).*(L1.*L2.^(-1)).^(-1/2)).^kg.*mg.*((B1.* ...
  B2.^(-1)).^kg.*B2+B1.*(B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.*L2.^(-1)) ...
  .^(-1/2)).^kg.*(y(1).*y(2).^(-1)).^((3/2).*kg)).^(-1).*(y(1).*y(2).^(-1)) ...
  .^((3/2).*kg)+(-1).*Fs0.*(B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.*L2.^( ...
  -1)).^(-1/2)).^ks.*ms.*((B1.*B2.^(-1)).^ks.*B2+B1.*(B1.*B2.^(-1).* ...
  C1.*C2.^(-1).*(L1.*L2.^(-1)).^(-1/2)).^ks.*(y(1).*y(2).^(-1)).^((3/2) ...
  .*ks)).^(-1).*(y(1).*y(2).^(-1)).^((3/2).*ks))+C1.^n.*L1.^((-1/2).*n) ...
  .*y(1).^((1/2).*n).*(B1.*C1.*L1.^(-1/2).*y(1).^(3/2)+B2.*C2.*L2.^( ...
  -1/2).*y(2).^(3/2)).^((-1).*n).*(ms+(mg+(-1).*ms).*y(3)))...
   ;...
   L2.^(-1).*Q0n.*(a0.^((-1).*n).*B0.^(1+(-1).*n).*((-1).*(B1.*B2.^( ...
  -1)).^kg.*Fg0.*mg.*((B1.*B2.^(-1)).^kg.*B2+B1.*(B1.*B2.^(-1).*C1.* ...e
  C2.^(-1).*(L1.*L2.^(-1)).^(-1/2)).^kg.*(y(1).*y(2).^(-1)).^((3/2).*kg) ...
  ).^(-1)+(-1).*(B1.*B2.^(-1)).^ks.*Fs0.*ms.*((B1.*B2.^(-1)).^ks.* ...
  B2+B1.*(B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.*L2.^(-1)).^(-1/2)).^ks.*( ...
  y(1).*y(2).^(-1)).^((3/2).*ks)).^(-1))+C2.^n.*L2.^((-1/2).*n).*y(2).^(( ...
  1/2).*n).*(B1.*C1.*L1.^(-1/2).*y(1).^(3/2)+B2.*C2.*L2.^(-1/2).*y(2).^( ...
  3/2)).^((-1).*n).*(ms+(mg+(-1).*ms).*y(4)))...
   ;...
   L1.^(-1).*((-1).*y(1).^((1/2).*n).*C1.^n.*y(3).*L1.^((-1/2).*n).*( ...
  y(1).^(3/2).*B1.*C1.*L1.^(-1/2)+y(2).^(3/2).*B2.*C2.*L2.^(-1/2)).^(( ...
  -1).*n)+a0.^((-1).*n).*(y(1).*y(2).^(-1)).^((3/2).*kg).*B0.^(1+(-1).* ...
  n).*Fg0.*((B1.*B2.^(-1)).^kg.*B2+(y(1).*y(2).^(-1)).^((3/2).*kg).*B1.* ...
  (B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.*L2.^(-1)).^(-1/2)).^kg).^(-1).*( ...
  B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.*L2.^(-1)).^(-1/2)).^kg).*mg.*Q0n+ ...
  y(3).*L1.^(-1).*(y(1).^((1/2).*n).*C1.^n.*L1.^((-1/2).*n).*(y(1).^(3/2) ...
  .*B1.*C1.*L1.^(-1/2)+y(2).^(3/2).*B2.*C2.*L2.^(-1/2)).^((-1).*n).*( ...
  y(3).*(mg+(-1).*ms)+ms)+a0.^((-1).*n).*B0.^(1+(-1).*n).*((-1).*( ...
  y(1).*y(2).^(-1)).^((3/2).*kg).*Fg0.*((B1.*B2.^(-1)).^kg.*B2+(y(1).* ...
  y(2).^(-1)).^((3/2).*kg).*B1.*(B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.* ...
  L2.^(-1)).^(-1/2)).^kg).^(-1).*(B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.* ...
  L2.^(-1)).^(-1/2)).^kg.*mg+(-1).*(y(1).*y(2).^(-1)).^((3/2).*ks).* ...
  Fs0.*((B1.*B2.^(-1)).^ks.*B2+(y(1).*y(2).^(-1)).^((3/2).*ks).*B1.*( ...
  B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.*L2.^(-1)).^(-1/2)).^ks).^(-1).*( ...
  B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.*L2.^(-1)).^(-1/2)).^ks.*ms)).* ...
  Q0n...
   ;...
   L2.^(-1).*(y(2).^((1/2).*n).*C2.^n.*((-1)+y(4)).*y(4).*(y(1).^(3/2).* ...
  B1.*C1.*L1.^(-1/2)+y(2).^(3/2).*B2.*C2.*L2.^(-1/2)).^((-1).*n).* ...
  L2.^((-1/2).*n).*(mg+(-1).*ms)+a0.^((-1).*n).*B0.^(1+(-1).*n).*(( ...
  -1).*(B1.*B2.^(-1)).^kg.*Fg0.*((-1)+y(4)).*((B1.*B2.^(-1)).^kg.*B2+ ...
  (y(1).*y(2).^(-1)).^((3/2).*kg).*B1.*(B1.*B2.^(-1).*C1.*C2.^(-1).*( ...
  L1.*L2.^(-1)).^(-1/2)).^kg).^(-1).*mg+(-1).*(B1.*B2.^(-1)).^ks.* ...
  y(4).*Fs0.*((B1.*B2.^(-1)).^ks.*B2+(y(1).*y(2).^(-1)).^((3/2).*ks).* ...
  B1.*(B1.*B2.^(-1).*C1.*C2.^(-1).*(L1.*L2.^(-1)).^(-1/2)).^ks).^( ...
  -1).*ms)).*Q0n...
   ];


  