#!/bin/bash
# finite difference modelling using fdelmodc code 
#Author: Faezeh Shirmohammadi (f.shirmohammadi@tudelft.nl)
# March 2024 _TU Delft

# Before using this code, two packages must be installed::
#2D Finite-Difference Wavefield Modelling (https://janth.home.xs4all.nl/Software/Software.html)
#The SU package (https://github.com/JohnWStockwellJr/SeisUnix)

#-----------------------------------------------------------------------------
xrbeg=45.25; xrend=95.25;  xrd=0.5; #receivers positions
xsbeg=30; xsend=110;  xsd=1; #sources positions
#-----------------------s------------------------------------------------------
# FDELMODC
export OMP_NUM_THREADS=4
#-----------------------------------------------------------------------------
(( xs=${xsbeg} ))
while (( xs <= ${xsend} ))
do
echo "modeling shot at x="${xs}

fdelmodc \
 	file_cp=ModelExt_cp.su \ #sources positions
 	file_den=ModelExt_ro.su \
 	file_src=wave.su \
 	file_rcv=shot_${xs}.new.su \
	ischeme=1 dt=0.0002 tmod=1 rec_delay=0.1 \
	xsrc=${xs} zsrc=0 \
	xrcv1=${xrbeg} xrcv2=${xrend} dxrcv=${xrd} \
	zrcv1=0 zrcv2=0 \
	dtrcv=0.002 rec_type_p=0 \
 	ntaper=499 left=4 right=4 top=1 bottom=4 \
	verbose=1
(( xs = ${xs} + ${xsd} ))
done
