#!/bin/bash
#Seismic interferometry by auto-correlation
#Author: Faezeh Shirmohammadi (f.shirmohammadi@tudelft.nl)
# March 2024 _TU Delft

# Before using this code, two packages must be installed::
#2D Finite-Difference Wavefield Modelling (https://janth.home.xs4all.nl/Software/Software.html)
#The SU package (https://github.com/JohnWStockwellJr/SeisUnix)

cd ..
pwd=`pwd`
pwd2=/Users/00_First_data/14_5_Near_Surface/01_Surf/Lateral1/ #output
pwd1=/Users//00_Submit/00_First_data/14_5_Near_Surface/01_Surf/ #input
output=stack.LL.new.su
output2=stack.LL.new.eps
cd $pwd2
rm causal.su corr.su cor1.su noncausal.su

for shots in `ls shot_*mute4.su` ; do
	rm FirstTrace.su corr.su
	fconv verbose=1 file_in1=$shots file_in2=$shots mode=cor1 shift=1 | sugain scale=1  > corr.su
	ns=`surange < corr.su | grep ns | awk '{print $2 }'`
	odd=$(( ns % 2))
	if [[ $odd == 1 ]]; then
  		ns2=$(echo "scale=0; ($ns-1)/2"| bc -l)
  		ns=$(echo "scale=0; $ns-1"| bc -l)
	else
  		ns2=$(echo "scale=0; ($ns)/2"| bc -l)
	fi
	suwind < corr.su itmin=$ns2 itmax=$ns | sushw key=f1,delrt a=0.0,0.0 >> causal.su
done

cp causal.su $pwd1/corr.causal.su

#stacking
susort gx sx  < $pwd1/corr.causal.su | sustack key=gx  > $pwd1/$output

#plot stacking output
cd $pwd1
suwind s=1 j=1 tmax=0.5 f1=0.0 < $pwd1/$output | sushw key=f1,delrt,d2 a=0.0,0.0,0.5 |  supsimage perc=97 f1=0 f2=45.25 hbox=3 wbox=4 label1='Time (s)' label2='Lateral position (m)'     labelsize=16 f2num=45.25 d2num=10 d1num=0.1 >  $pwd1/$output2

