clear all
close all
clc

% Load data on number of bubbles and pressure from respective files
load('N2_He\nBubbles_N2_He.mat')
load('N2_He\pressure_N2_He.mat')
nB_He = nBubbles(1:5:end);
pressure_He = pressure_cam;

load('N2_N2\nBubbles_N2_N2.mat')
load('N2_N2\pressure_N2_N2.mat')
nB_N2 = nBubbles(1:5:end);
pressure_N2 = pressure_cam;

load('N2_H2O+\nBubbles_N2_ambient.mat')
load('N2_H2O+\pressure_N2_ambient.mat')
nB_ambient = nBubbles(1:5:end);
pressure_ambient = pressure_cam;

load('N2_H2O\nBubbles_N2_water.mat')
load('N2_H2O\pressure_N2_water.mat')
nB_water = nBubbles(1:5:end);
pressure_water = pressure_cam;

% Set interval of number of points to be plotted to maintain clear graphs
dx = 30;

% Plot data
plot(pressure_He(1:dx:end),nB_He(1:dx:end),'kx','MarkerSize',6,'LineWidth',2)
hold on
plot(pressure_N2(1:dx:end),nB_N2(1:dx:end),'ks','MarkerSize',6,'LineWidth',2)
plot(pressure_ambient(1:dx:end),nB_ambient(1:dx:end),'ko','MarkerSize',6,'LineWidth',2)
plot(pressure_water(1:dx:end),nB_water(1:dx:end),'kv','MarkerSize',6,'LineWidth',2)

xlabel('Pressure [bar]')
ylabel('No. of bubbles')
set(gca, 'XDir','reverse')

legend('He','N2','H2O+','H2O','Location','NorthWest')
axis([0 70 0 1200]);
yticks([0:200:1200]);
set(gca,'FontSize',14)