# Data underlying the research of Quality prediction of strawberries with RGB image segments

This is the dataset for the journal paper: "`How Sweet Are Your Strawberries?': Predicting Sugariness Using Non-Destructive and Affordable Hardware"

## File Naming Convention:
```
* Images in Segments/: The file name is composed of the date and time of the image, and the strawberry ID to identify the measurement results. 
* Strawberry_Measurements_with_Seg_Connections_mtd1.csv: The file name is composed of the research object, attributes of the object, and indication of additional connections with other types of data; ``mtd1" indicates that the maximum time difference between the collection of image segment and the harvest time is 1 hour (excluding night images).
* Strawberry_Plant_Load_2021.xlsx: The file name is composed of the research object, attributes of the object, and period of data collection.
* Greenhouse_Environment_Hourly_20210401-1118.csv: The file name is composed of the research object, attributes of the object, frequency of data collection, and period of data collection.
```

##Attributes:
```
Root Dir/
	-Segments/
		-Image1
			-Name Format: Date_Time_DD-MM-Branch-FruitNumber.png 
		-Image2	
		-...
	-Strawberry_Measurements_with_Seg_Connections_mtd1.csv:
		-Strawberry ID [DD-MM-Branch-FruitNumber]
		-Marketable or not [1 or 0]
		-Ripeness Level [1 to 10]
		-Size Class [Tiny/Small/Coarse/Misshaped]
		-Sugariness [Brix value]
		-Firmness [kg/m^2]
		-RGB_Camera [The camera that monitored the strawberry]
		-frame_key [The latest frame where the strawberry is observable]
		-segment_file [The name of the file in Segments/]
	-Strawberry_Plant_Load_2021.xlsx:
		-Cultivation details about the research object
		-Calendar week number
		-Number of flowers per m^2.
		-Number of fruits per m^2.
		-Number of flowers and fruits per m^2.
	-Greenhouse_Environment_Hourly_20210401-1118.csv:
		-Timestamp when the environmental data was recorded
		-Attribute1
		-Attribute2
		-...
	-README.md
	-License.md
```

## Principal Investigator: 
- TU Delft: Junhan Wen, Thomas Abeel, Mathijs de Weerdt; 
- Birds.ai: Camiel Verschoor; 
- Delphy BV: Lisanne Schuddebeurs, Klaas Walraven, Stijn Jochems, Vera Theelen