%-------------------
%GENERAL INFORMATION
%-------------------

% 1. Dataset title: Supporting data belonging to publication: 
% "Lift-Induced Wake Re-Energization for a VAWT-Based Multi-Rotor System"

% 2. Authorship: 
    % Name: David Bensason and Thomas Broertjes (MSc student)
    % Institution: Delft University of Technology 
    % Email: d.y.bensason@tudelft.nl
    % ORCID: 0000-0002-0590-1524

%-------------------
% DESCRIPTION
%-------------------

% This is a README file for an experimental data repository
% on 4TU DOI: 10.4121/24529850-7f34-42b6-9f29-fcc1577bb1ae. The data concerns the
% experimental results presented in the manuscript titled 
% "Lift-Induced Wake Re-Energization for a VAWT-Based Multi-Rotor System". 

% A zip folder contains the .mat files for the time-averaged measurement
% planes entitled "mat_flow_global.zip". % Furthermore, CAD files for the total
% assembly of the MRS with wings is included in the zipped folder
% 'CAD_Share_4TU.zip'.
 
%% Description of "mat_flow_global.zip"
%{
This zip folder includes data structures of the stitched flowfields at each
cross-stream measurement plane. There are cases with and without the wing.
The datafiles are already fully stiched following the method explained in
the manuscript. An example of the file name is as follows: 
MRS_NoWing_1.0_D.mat OR MRS_Wing_1.0_D.mat : NoWing is the baseline case
and Wing is the case with wings. The number 1.0_D indiates the measurement
is one diameter downstream. 

When loading the mat structure using load('MRS_NoWing_1.0_D.mat'), it will load
a structure named "field_data" with flow metrics of a 40×38 matrix. 
The definition of the entries of this structure is as follows: 
 
field_data.x; % streamwise coordinate (mm)
field_data.y; % lateral coordinate (mm)
field_data.z; % vertical coordinate (mm)
field_data.Ux; % streamwise flow (m/s)
field_data.Uy; % lateral flow (m/s)
field_data.Uz; % vertical flow (m/s)
field_data.Umag; % velocity magnitude (m/s)
field_data.dUydy; % Lateral velocity gradient (1/s)
field_data.dUydz; % Lateral velocity gradient (1/s)
field_data.dUzdy; % Vertical velocity gradient (1/s)
field_data.dUzdz; % Vertical velocity gradient (1/s)
field_data.dUxdy; % Streamwise velocity gradient (1/s)
field_data.dUxdz; % Streamwise velocity gradient (1/s)
field_data.vort_x; % Streamwise vorticity (1/s)
field_data.vort_mag; % Vorticity magnitude (1/s)
field_data.div; % 2D Divergence (1/s)
field_data.swirl_strength; % 2D Swirl Strength (1/s^2)
field_data.numvec; % Number of vectors (n)
field_data.Re_stress_UyUy; % Reynolds stress lateral-lateral ((m/s)^2)
field_data.Re_stress_UyUz; % Reynolds stress lateral-vertical ((m/s)^2)
field_data.Re_stress_UxUy; % Reynolds stress streamwise-lateral ((m/s)^2)
field_data.Re_stress_UzUz; % Reynolds stress vertical-vertical ((m/s)^2)
field_data.Re_stress_UxUz; % Reynolds stress streamwise-vertical ((m/s)^2)
field_data.Re_stress_UxUx; % Reynolds stress streamwise-streamwise ((m/s)^2)
field_data.std_Vmag; % Standard deviation velocity magnitude  (m/s)
field_data.std_Uy; % Standard deviation in lateral velocity (m/s)
field_data.std_Uz; % Standard deviation in vertical velocity (m/s)
field_data.std_Ux; % Standard deviation in streamwise velocity (m/s)
field_data.Unc_mag; % Uncertainty magnitude velocity (m/s)
field_data.Unc_Uy; % Uncertainty in lateral velocity (m/s)
field_data.Unc_Uz; % Uncertainty deviation in vertical velocity (m/s)
field_data.Unc_Ux; % Uncertainty deviation in streamwise velocity (m/s)
field_data.valid; % (=0, no data) (=1, data)
%}
    

%% Description of 'CAD_Share_4TU.zip'
%{
This zip folder contains part (.ipt) and assembly files (.iam) for the MRS
with wings, generated in Autodesk Inventor 2023. The assembly file entitled
"MultiRotorSystem_Assembly A.1_NO_WING.iam" is the main assembly file which
should be opened. All other files are parts and sub-assemblies which are
subsidiary. 

%}

