#ifndef MLTREE_HH
#define MLTREE_HH

#include <gecode/brancher/ml-node.cpp>
#include <mutex>

using namespace std;

class MLTree {

    public:
        // Public constructor
        MLTree(MLNode* root);
        // Check whether an MLNode can be stored, store it if so
        bool storeNode(MLNode* node);
        // Computes deep impact for each node in the tree which has at least a certain depth of children
        void computeDeepImpact(int depth);
        // Deep smallest computes average smallest values for a node computed over a certain depth
        void computeDeepSmallest(int depth);
        // Deep regret computes average smallest values for a node computed over a certain depth
        void computeDeepMaxRegret(int depth);
        // Deep anti first fail: average of largest domain sizes.
        void computeAntiFF(int depth);
        vector<MLNode*> getNodes();
        int countLeafs();
        int countLeafsRec(MLNode* node);
        int getHeight();
        void setHeight(int tree_height);
        void toString();
        // Check the size of the assignments of the last node stored
        int getLastAssignmentSize();
        void setLastAssignmentSize(int size);
        bool checkNodeByAssignment(vector<int> assignment);
        MLNode* getNodeByAssignment(vector<int> assignment);
        // Check last node
        MLNode* getLastNode();
        void setLastNode(MLNode* node);
        

    private:
        MLNode* root;
        // All the nodes in the tree (convenient for calling on all data)
        vector<MLNode*> nodes;
        int height;
        int lastAssignmentSize;
        MLNode* last_node;
        int current_pos;

        bool recursiveNodeStore(MLNode* node2check, MLNode* node);
        bool storeAsChild(MLNode* parent, MLNode* child);

        // Deep Impact
        void computeAllImpact(MLNode* node, int depth);
        double recursiveImpact(MLNode* node, int depth, int cur_depth);

        // Deep Smallest
        int smallest_nodes_counted;
        void computeAllSmallest(MLNode* node, int depth);
        double recursiveSmallest(MLNode* node, int depth, int cur_depth);

        // Deep Max Regret
        int regret_nodes_counted;
        void computeAllMaxRegret(MLNode* node, int depth);
        double recursiveMaxRegret(MLNode* node, int depth, int cur_depth);

        // Deep Anti-First Fail
        int dom_size_nodes_counted;
        void computeAllAntiFF(MLNode* node, int depth);
        double recursiveAntiFF(MLNode* node, int depth, int cur_depth);

        void storeInTree(MLNode* parent, MLNode* child);

        void toStringRec(MLNode* node);

        mutex values_mutex;
        

};

#endif